package com.marcodinacci.android.commons.io;

import java.util.ArrayList;
import java.util.List;

import android.util.Log;

import com.marcodinacci.android.commons.AsyncTaskListener;

/**
 * Asynchroniczny zapis do strumienia
 * 
 * @author Marco Dinacci <marco.dinacci@gmail.com>
 */
@SuppressWarnings("rawtypes")
public class DataWriter {

	private static final String TAG = "DataWriter";

	@SuppressWarnings({ "unchecked" })
	// FIXME Poprawi parametry odbiornika
	public void writeAsync(AsyncTaskListener<Integer, Long> listener, 
			DataSink ds, boolean flushOnWrite, boolean closeOnWrite) {
		
		List<AsyncTaskListener> listeners = new ArrayList<AsyncTaskListener>(1);
		listeners.add(listener);
		
		Log.d(TAG, "Asynchroniczny zapis do " + ds.getSink().toString());
		new StreamDataTask((AsyncTaskListener<Integer, Long>[]) 
				listeners.toArray(),flushOnWrite, closeOnWrite).execute(ds);
	}
	
	public void writeAsync(DataSink ds) {
		writeAsync(null, ds, true, true);
	}
}
