package com.androidcookbook.homeapp;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

/** 
 * Uproszczony ekran gwny oparty na kontrolce ListView.
 * Ma dziaa "w trybie kiosku" i udostpnia tylko wybrane aplikacje.
 * Nie jest zbyt elegancka!
 * NIE JEST BEZPIECZNA: zobacz stron http://androidcookbook/r/4124
 * Z kodu korzystasz na wasne ryzyko (podobnie jak z innych darmowych programw)!!!
 * @author Ian Darwin
 */
public class HomeActivity extends ListActivity {
	
	/** Zaufaj mi, w wersji produkcyjnej naley ustawi t zmienn na false! */
	private final boolean DEBUG = true;

	/** Prosta struktura danych na wywietlane aplikacje */
	class MyAppDesc {
		public MyAppDesc(String name, Intent intent) {
			super();
			this.name = name;
			this.intent = intent;
		}
		String name;
		Intent intent;
	}

	/** Wywietlane aplikacje */
	MyAppDesc[] progs = {
			new MyAppDesc("Phone", 
					new Intent(Intent.ACTION_DIAL, null)),
			new MyAppDesc("Web",
							new Intent(Intent.ACTION_VIEW, Uri.parse("http://google.com"))),
	};

	@Override
	public void onCreate(final Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.home_activity);

		setListAdapter(adapter);
		if (!DEBUG) {
			View v = findViewById(R.id.exitButton);
			v.setVisibility(View.GONE);
		}
	}
	
	/**
	 * Gwny fragment aplikacji: uruchamianie programu wybranego przez uytkownika
	 */
	protected void onListItemClick(final ListView l, final View v, int position, long id) {
		startActivity(progs[position].intent);
	}

	private final ListAdapter adapter = new BaseAdapter() {

		@Override
		public View getView(final int position, final View convertView, final ViewGroup parent) {
			View v = convertView;

			if (v == null) {
				LayoutInflater vi = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
				v = vi.inflate(R.layout.app_row, null);
			}

			MyAppDesc prog = progs[position];
			TextView name = (TextView)v.findViewById(R.id.app_name);

			name.setText(prog.name);

			return v;
		}

		@Override
		public long getItemId(int position) {
			return position;
		}

		@Override
		public Object getItem(int position) {
			return progs[position];
		}

		@Override
		public int getCount() {
			return progs.length;
		}
	};

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.activity_home, menu);
		return true;
	}

	/** W wersji produkcyjnej metod t naley usun 
	 * (za pomoc CodeGuarda) 
	 */
	 public void exitPressed(View v) {
		 System.exit(0);
	 }
}
