package com.example.displayinfo;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {

	TextView log;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);		
		log = (TextView) findViewById(R.id.logTextView);
		showInfo();	// Pocztkowo wywietlane dane
	}
	
	/** Aktualizowanie informacji (np. po obrceniu ekranu) */
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		showInfo();
	}
	
	/** Ustalanie aktualnych informacji i dodawanie ich do pola tekstowego */
	void showInfo() {

		// Pobieranie informacji
		final Display display = getWindowManager().getDefaultDisplay();

		int width, height;

		// T metod dodano w 13. wersji interfejsu API
		Point point = new Point();
		display.getSize(point); // PRZECZYTAJ DOKUMENTACJ TEJ METODY!
		width = point.x;
		height = point.y;
		dump("display.getSize()", width, height);

		width = display.getWidth();
		height = display.getHeight();

		dump("display.getWidth(),getHeight", width, height);

		DisplayMetrics metrics = new DisplayMetrics();
		display.getMetrics(metrics);

		width = metrics.widthPixels;
		height = metrics.heightPixels;
		dump("metrics.fields", width, height);
	}

	private void dump(String m, int w, int h) {
		log.append(String.format("Z %s: Szeroko %d, Wysoko %d%n", m, w, h));
	}

}
