package com.darwinsys.calendar;

import java.util.Calendar;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.TimePicker;
import android.widget.Toast;

public class MainActivity extends Activity implements OnClickListener {
	public static final String TAG = "CalAdder";
	
	Calendar mCal = Calendar.getInstance();
	String title = "Spotkanie zespou";
	String location = "Sala zebra";
	int duration = 1;	// Godziny
	Button addUsingContentProvider, addUsingIntent;
		
    /** Wywoywana, gdy aktywno tworzona jest po raz pierwszy */
    @Override
    public void onCreate(Bundle savedInstanceState) {
    	Log.d(TAG, "onCreate()");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
		addUsingIntent = (Button) findViewById(R.id.addUsingIntentButton);
		addUsingContentProvider = (Button) findViewById(R.id.addUsingContentProviderButton);
		
		addUsingIntent.setOnClickListener(this);
		addUsingContentProvider.setOnClickListener(this);
    }

	@Override
	public void onClick(View v) {
		// DatePicker umoliwia pobieranie wartoci; TimePicker wymaga odbiornika.
		// Tu na stae zapisano spotkanie w godzinach od 12. do 13.
		DatePicker dp = (DatePicker) findViewById(R.id.datePicker);
		final Calendar c = Calendar.getInstance();
		c.set(Calendar.YEAR, dp.getYear());
		c.set(Calendar.YEAR, dp.getMonth());
		c.set(Calendar.YEAR, dp.getDayOfMonth());
		c.set(Calendar.HOUR, 12);
		final Calendar d = Calendar.getInstance();
		d.setTimeInMillis(c.getTimeInMillis());
		d.roll(Calendar.HOUR, +1);
		switch (v.getId()) {
		case R.id.addUsingIntentButton:
			// To rozwizanie dziaa w prawie kadej wersji
			new AddUsingIntent().addEvent(this, title, c, d);
			break;
		case R.id.addUsingContentProviderButton:
			// To podejcie oparte jest na API z Androida 4.0.
            // Wykorzystywany jest interfejs Reflection API
			try {
				String packageName = getClass().getPackage().getName();
				EventAdder eventAdder = (EventAdder)Class.forName(packageName + ".AddUsingContentProvider").newInstance();
				eventAdder.addEvent(this, title, c, d);
			} catch (Exception e) {
				Toast.makeText(this, "Nie mona wczyta dostawcy AddUsingContentProvider: " + e, Toast.LENGTH_LONG).show();
			}
			break;
		default:
			throw new IllegalArgumentException("Nieznany widok w metodzie onClick()");
		}
	}
}