package com.marcodinacci.android.commons.io;

import java.io.File;
import java.io.IOException;

/**
 * Kolekcja narzdzi do obsugi plikw
 * 
 * @author Marco Dinacci <dev@dinointeractive.com>
 *
 */
public class FileUtils {
	/**
	 * Naladowanie linuksowego narzdzia <em>touch</em>.
	 * 
	 * @param File Przetwarzany plik. Informacje o ciece 
	 *             s okrelane na podstawie pliku
	 */
	public static void touch(File file) throws IOException {
		if(!file.exists()) {
			File parent = file.getParentFile();
			if(parent != null) 
				if(!parent.exists())
					if(!parent.mkdirs())
						throw new IOException("Nie mona utworzy katalogu na plik: " + file);
			
				file.createNewFile();
		}
		
		boolean success = file.setLastModified(System.currentTimeMillis());
        if (!success)
            throw new IOException("Nie mona ustawi czasu ostatniej modyfikacji pliku " + file);
	}
	
	/**
	 * Naladowanie linuksowego narzdzia <em>touch</em>.
	 * 
	 * @param String cieka do przetwarzanego pliku
	 */
	public static void touch(String path) throws IOException {
		touch(new File(path));
	}
}
