package com.plot;

import java.util.Arrays;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import com.androidplot.series.XYSeries;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.SimpleXYSeries;
import com.androidplot.xy.XYPlot;

public class AndroidPlot extends Activity {
    private XYPlot mySimpleXYPlot;

	/** Wywoywana, gdy aktywno tworzona jest po raz pierwszy */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        // Tworzenie referencji do obiektu XYPlot
        mySimpleXYPlot = (XYPlot) findViewById(R.id.mySimpleXYPlot);
 
        // Tworzenie dwch tablic rysowanych wartoci y:
        Number[] series1Numbers = {1, 8, 5, 2, 7, 4};
        Number[] series2Numbers = {4, 6, 3, 8, 2, 10};
 
        // Przeksztacanie tablic na obiektu XYSeries
        XYSeries series1 = new SimpleXYSeries(
        		// Konstruktor SimpleXYSeries przyjmuje list, dlatego naley przeksztaci tablic na list
                Arrays.asList(series1Numbers),          
                // Staa Y_VALS_ONLY sprawia, e jako warto x ustawiany jest indeks elementu
                SimpleXYSeries.ArrayFormat.Y_VALS_ONLY, 
                // Ustawianie nagwka dla zestawu wartoci
                "Seria1");                             
 
        // Te same operacje dla drugiej tablicy
        XYSeries series2 = new SimpleXYSeries(Arrays.asList(series2Numbers), SimpleXYSeries.ArrayFormat.Y_VALS_ONLY, 
                "Seria2");
 
        // Tworzenie obiektu formatujcego
        LineAndPointFormatter series1Format = new LineAndPointFormatter(
                Color.rgb(0, 200, 0),                   // Kolor linii
                Color.rgb(0, 100, 0),                   // Kolor punktw
                Color.rgb(150, 190, 150));              // Kolor wypenienia (opcjonalnie)
 
        // Dodawanie obiektu series1 do wykresu
        mySimpleXYPlot.addSeries(series1, series1Format);
 
        // Dodawanie obiektu series2 do wykresu
        mySimpleXYPlot.addSeries(series2, new LineAndPointFormatter(Color.rgb(0, 0, 200), Color.rgb(0, 0, 100),
                Color.rgb(150, 150, 190)));
 
 
        // Zmniejszanie liczby etykiet
        mySimpleXYPlot.setTicksPerRangeLabel(3);
 
        // Biblioteka AndroidPlot domylnie wywietla linie pomagajce w ustawianiu wykresu.
        // Aby je usun, naley wywoa metod disableAllMarkup():
        mySimpleXYPlot.disableAllMarkup();
        
        mySimpleXYPlot.getBackgroundPaint().setAlpha(0);
        mySimpleXYPlot.getGraphWidget().getBackgroundPaint().setAlpha(0);
        mySimpleXYPlot.getGraphWidget().getGridBackgroundPaint().setAlpha(0);   
    
    }
}