package com.examples.tipcalc;

import java.text.NumberFormat;

import com.darwinsys.android.NumberPickerLogic;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnKeyListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.TextView;

public class TipsterActivity extends Activity {
	
	final static int DEFAULT_NUM_PEOPLE = 3;
	
	final static NumberFormat formatter =
			NumberFormat.getCurrencyInstance();
	
    // Kontrolki z aplikacji
    private EditText txtAmount;
    private EditText txtPeople;
    private EditText txtTipOther;
    private RadioGroup rdoGroupTips;
    private Button btnCalculate;
    private Button btnReset;
 
    private TextView txtTipAmount;
    private TextView txtTotalToPay;
    private TextView txtTipPerPerson;
 
    // Identyfikator wybranego przycisku opcji
    private int radioCheckedId = -1;
	private NumberPickerLogic mLogic;
 
    /** Wywoywana, gdy aktywno tworzona jest po raz pierwszy */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
 
        // Dostp do kontrolek na podstawie identyfikatora z pliku R.java
        txtAmount = (EditText) findViewById(R.id.txtAmount);
        // Po uruchomieniu aplikacji kursor powinien znajdowa si w polu Wysoko rachunku
        txtAmount.requestFocus();
       
        txtPeople = (EditText) findViewById(R.id.txtPeople);
        txtPeople.setText(Integer.toString(DEFAULT_NUM_PEOPLE));

        txtTipOther = (EditText) findViewById(R.id.txtTipOther);
 
        rdoGroupTips = (RadioGroup) findViewById(R.id.RadioGroupTips);
 
        btnCalculate = (Button) findViewById(R.id.btnCalculate);
        // Bezporednio po uruchomieniu aplikacji przycisk Oblicz jest nieaktywny
        btnCalculate.setEnabled(false);
 
        btnReset = (Button) findViewById(R.id.btnReset);
 
        txtTipAmount = (TextView) findViewById(R.id.txtTipAmount);
        txtTotalToPay = (TextView) findViewById(R.id.txtTotalToPay);
        txtTipPerPerson = (TextView) findViewById(R.id.txtTipPerPerson);
 
        // Po uruchomieniu aplikacji naley wyczy pole Inny:
        txtTipOther.setEnabled(false);
        
        /*
         * Doczanie odbiornika OnCheckedChangeListener do grupy przyciskw opcji,
         * aby mc ledzi, ktry przycisk zosta zaznaczony przez uytkownika
         */
        rdoGroupTips.setOnCheckedChangeListener(new OnCheckedChangeListener() {

        	@Override
        	public void onCheckedChanged(RadioGroup group, int checkedId) {
        		// Wczanie i wyczanie pola Inny:
        		if (checkedId == R.id.radioFifteen
        				|| checkedId == R.id.radioTwenty) {
        			txtTipOther.setEnabled(false);
        			/*
        			 * Wczanie przycisku Oblicz, jeli pola Wysoko rachunku i Liczba osb
        			 * maj poprawne wartoci
        			 */
        			btnCalculate.setEnabled(txtAmount.getText().length() > 0
        					&& txtPeople.getText().length() > 0);
        		}
        		if (checkedId == R.id.radioOther) {
        			// Wczanie pola Inny:
        			txtTipOther.setEnabled(true);
        			// Ustawianie kursora w tym polu
        			txtTipOther.requestFocus();
        			/*
        			 * Wczanie przycisku Oblicz, jeli w polach Wysoko rachunku i Liczba
        			 * osb znajduj si prawidowe wartoci. Naley te si upewni, e
        			 * uytkownik wprowadzi warto w polu Inny:
        			 */
        			btnCalculate.setEnabled(txtAmount.getText().length() > 0
        					&& txtPeople.getText().length() > 0
        					&& txtTipOther.getText().length() > 0);
        		}
        		// Okrelanie, jaki procent napiwku wybra uytkownik
        		radioCheckedId = checkedId;
        	}
        });
         
         /*
          * Doczanie odbiornika KeyListener do pl Wysoko rachunku, Liczba osb i
          * Inny:
          */
         txtAmount.setOnKeyListener(mKeyListener);
         txtPeople.setOnKeyListener(mKeyListener);
         txtTipOther.setOnKeyListener(mKeyListener);
         
         btnCalculate.setOnClickListener(mClickListener);
         btnReset.setOnClickListener(mClickListener);
         
         /** Tworzenie obiektu NumberPickerLogic do obsugi klikni klawiszy + i - */
         mLogic = new NumberPickerLogic(txtPeople, 1, Integer.MAX_VALUE);
    }
    
    /*
     * Odbiornik KeyListener dla pl Wysoko rachunku, Liczba osb i Inny.
     * Odbiornik ten ma sprawdza nastpujce warunki:
     *
     * 1) Jeli uytkownik zaznaczy przycisk opcji Inny, w powizanym z nim polu
     * powinna znajdowa si poprawna procentowa warto napiwku. Przycisk Oblicz
     * naley wczy tylko wtedy, jeli dostpna jest taka warto.
     *
     * 2) Jeli uytkownik nie wprowadzi wartoci w polach Wysoko rachunku i Liczba osb,
     * nie mona przeprowadzi oblicze. Dlatego przycisk Oblicz naley wczy 
     * tylko po wprowadzeniu poprawnych wartoci w wymienionych polach.
     */
    private OnKeyListener mKeyListener = new OnKeyListener() {
        @Override
        public boolean onKey(View v, int keyCode, KeyEvent event) {
     
        switch (v.getId()) {
        case R.id.txtAmount:
        case R.id.txtPeople:
            btnCalculate.setEnabled(txtAmount.getText().length() > 0
                    && txtPeople.getText().length() > 0);
            break;
        case R.id.txtTipOther:
            btnCalculate.setEnabled(txtAmount.getText().length() > 0
                    && txtPeople.getText().length() > 0
                    && txtTipOther.getText().length() > 0);
            break;
        }
        return false;
        }
     
    };
    
    /**
     * Odbiornik ClickListener dla przyciskw Oblicz i Wyczy.
     * W zalenoci od kliknitego przycisku wywoywana jest odpowiednia
     * metoda.
     */
    private OnClickListener mClickListener = new OnClickListener() {
     
        @Override
        public void onClick(View v) {
            if (v.getId() == R.id.btnCalculate) {
                calculate();
            } else {
                reset();
            }
        }
    };


    /**
     * Usuwa kontrolk z obliczon wysokoci napiwku, a take usuwa
     * zawarto pl tekstowych i zaznaczenie przycisku opcji.
     */
    private void reset() {
        txtTipAmount.setText("");
        txtTotalToPay.setText("");
        txtTipPerPerson.setText("");
        txtAmount.setText("");
        txtPeople.setText(Integer.toString(DEFAULT_NUM_PEOPLE));
        txtTipOther.setText("");
        rdoGroupTips.clearCheck();
        rdoGroupTips.check(R.id.radioFifteen);
        // Umieszczanie kursora w pierwszym polu
        txtAmount.requestFocus();
    }
    
    public void decrement(View v) {
    	mLogic.decrement();
    }
    
    public void increment(View v) {
    	mLogic.increment();
    }
 
    /**
     * Obliczanie napiwku na podstawie danych od uytkownika.
     */
    private void calculate() {
        Double billAmount = Double.parseDouble(
            txtAmount.getText().toString());
        Double totalPeople = Double.parseDouble(
            txtPeople.getText().toString());
        Double percentage = null;
        boolean isError = false;
        if (billAmount < 1.0) {
            showErrorAlert("Wprowad wysoko rachunku.",
                txtAmount.getId());
            isError = true;
        }
     
        if (totalPeople < 1.0) {
            showErrorAlert("Podaj liczb osb.",
                txtPeople.getId());
            isError = true;
        }
     
        /*
         * Jeli uytkownik nie wybra adnego przycisku opcji, oznacza to,
         * e ustawione jest 15%. Bezpieczniej jednak jest to sprawdzi.
         */
        if (radioCheckedId == -1) {
            radioCheckedId = rdoGroupTips.getCheckedRadioButtonId();
        }
        if (radioCheckedId == R.id.radioFifteen) {
            percentage = 15.00;
        } else if (radioCheckedId == R.id.radioTwenty) {
            percentage = 20.00;
        } else if (radioCheckedId == R.id.radioOther) {
            percentage = Double.parseDouble(
                txtTipOther.getText().toString());
            if (percentage < 1.0) {
                showErrorAlert("Podaj procent napiwku",
                    txtTipOther.getId());
                isError = true;
            }
        }
        /*
         * Jeli we wszystkich polach znajduj si poprawne wartoci, naley
         * przystpi do obliczania napiwku
         */
        if (!isError) {
            double tipAmount = ((billAmount * percentage) / 100);
            double totalToPay = billAmount + tipAmount;
            double perPersonPays = totalToPay / totalPeople;
     
            txtTipAmount.setText(formatter.format(tipAmount));
            txtTotalToPay.setText(formatter.format(totalToPay));
            txtTipPerPerson.setText(formatter.format(perPersonPays));
        }
    }
    
    /**
     * Wywietla komunikat o bdzie w oknie ostrzegawczym
     *
     * @param errorMessage
     *            acuch znakw z komunikatem o bdzie
     * @param fieldId
     *            Identyfikator pola, ktre spowodowao bd.
     *            Jest to potrzebne, aby mona ustawi kursor w 
     *            odpowiednim polu po zamkniciu okna dialogowego
     */
	private void showErrorAlert(String errorMessage, final int fieldId) {
		new AlertDialog.Builder(this)
				.setTitle("Bd")
				.setMessage(errorMessage)
				.setNeutralButton("Zamknij",
						new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog,
									int which) {
								findViewById(fieldId).requestFocus();
							}
						}).show();
	}
}