/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYSeries
implements Serializable {
    private String mTitle;
    private List<Double> mX = new ArrayList<Double>();
    private List<Double> mY = new ArrayList<Double>();
    private double mMinX = Double.MAX_VALUE;
    private double mMaxX = -1.7976931348623157E308;
    private double mMinY = Double.MAX_VALUE;
    private double mMaxY = -1.7976931348623157E308;

    public XYSeries(String string) {
        this.mTitle = string;
        this.initRange();
    }

    private void initRange() {
        this.mMinX = Double.MAX_VALUE;
        this.mMaxX = -1.7976931348623157E308;
        this.mMinY = Double.MAX_VALUE;
        this.mMaxY = -1.7976931348623157E308;
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            double d = this.getX(i);
            double d2 = this.getY(i);
            this.updateRange(d, d2);
        }
    }

    private void updateRange(double d, double d2) {
        this.mMinX = Math.min(this.mMinX, d);
        this.mMaxX = Math.max(this.mMaxX, d);
        this.mMinY = Math.min(this.mMinY, d2);
        this.mMaxY = Math.max(this.mMaxY, d2);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void add(double d, double d2) {
        this.mX.add(d);
        this.mY.add(d2);
        this.updateRange(d, d2);
    }

    public void remove(int n) {
        double d = this.mX.remove(n);
        double d2 = this.mY.remove(n);
        if (d == this.mMinX || d == this.mMaxX || d2 == this.mMinY || d2 == this.mMaxY) {
            this.initRange();
        }
    }

    public void clear() {
        this.mX.clear();
        this.mY.clear();
        this.initRange();
    }

    public double getX(int n) {
        return this.mX.get(n);
    }

    public double getY(int n) {
        return this.mY.get(n);
    }

    public int getItemCount() {
        return this.mX.size();
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }
}

