/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.HashMap;
import org.apache.cordova.DroidGap;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class App
extends Plugin {
    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("clearCache")) {
                this.clearCache();
            } else if (action.equals("loadUrl")) {
                this.loadUrl(args.getString(0), args.optJSONObject(1));
            } else if (action.equals("cancelLoadUrl")) {
                this.cancelLoadUrl();
            } else if (action.equals("clearHistory")) {
                this.clearHistory();
            } else if (action.equals("backHistory")) {
                this.backHistory();
            } else if (action.equals("overrideBackbutton")) {
                this.overrideBackbutton(args.getBoolean(0));
            } else {
                if (action.equals("isBackbuttonOverridden")) {
                    boolean b = this.isBackbuttonOverridden();
                    return new PluginResult(status, b);
                }
                if (action.equals("exitApp")) {
                    this.exitApp();
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public void clearCache() {
        ((DroidGap)this.ctx).clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUrl(String url, JSONObject props) throws JSONException {
        Object keys;
        LOG.d("App", "App.loadUrl(" + url + "," + props + ")");
        int wait = 0;
        boolean openExternal = false;
        boolean clearHistory = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (props != null) {
            keys = props.names();
            for (int i = 0; i < keys.length(); ++i) {
                String key = keys.getString(i);
                if (key.equals("wait")) {
                    wait = props.getInt(key);
                    continue;
                }
                if (key.equalsIgnoreCase("openexternal")) {
                    openExternal = props.getBoolean(key);
                    continue;
                }
                if (key.equalsIgnoreCase("clearhistory")) {
                    clearHistory = props.getBoolean(key);
                    continue;
                }
                Object value = props.get(key);
                if (value == null) continue;
                if (value.getClass().equals(String.class)) {
                    params.put(key, (String)value);
                    continue;
                }
                if (value.getClass().equals(Boolean.class)) {
                    params.put(key, (Boolean)value);
                    continue;
                }
                if (!value.getClass().equals(Integer.class)) continue;
                params.put(key, (Integer)value);
            }
        }
        if (wait > 0) {
            try {
                keys = this;
                synchronized (keys) {
                    this.wait(wait);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ((DroidGap)this.ctx).showWebPage(url, openExternal, clearHistory, params);
    }

    public void cancelLoadUrl() {
        ((DroidGap)this.ctx).cancelLoadUrl();
    }

    public void clearHistory() {
        ((DroidGap)this.ctx).clearHistory();
    }

    public void backHistory() {
        ((DroidGap)this.ctx).backHistory();
    }

    public void overrideBackbutton(boolean override) {
        LOG.i("DroidGap", "WARNING: Back Button Default Behaviour will be overridden.  The backbutton event will be fired!");
        ((DroidGap)this.ctx).bound = override;
    }

    public boolean isBackbuttonOverridden() {
        return ((DroidGap)this.ctx).bound;
    }

    public void exitApp() {
        ((DroidGap)this.ctx).endActivity();
    }
}

