/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import java.io.File;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTileFilesystemProvider
extends MapTileFileStorageProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(MapTileFilesystemProvider.class);
    private final long mMaximumCachedFileAge;
    private ITileSource mTileSource;

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver) {
        this(pRegisterReceiver, TileSourceFactory.DEFAULT_TILE_SOURCE);
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource aTileSource) {
        this(pRegisterReceiver, aTileSource, 604800000L);
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge) {
        super(pRegisterReceiver, 8, 40);
        this.mTileSource = pTileSource;
        this.mMaximumCachedFileAge = pMaximumCachedFileAge;
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "File System Cache Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "filesystem";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.mTileSource != null ? this.mTileSource.getMinimumZoomLevel() : 22;
    }

    @Override
    public int getMaximumZoomLevel() {
        return this.mTileSource != null ? this.mTileSource.getMaximumZoomLevel() : 0;
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource = pTileSource;
    }

    private class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        private TileLoader() {
            super(MapTileFilesystemProvider.this);
        }

        @Override
        public Drawable loadTile(MapTileRequestState pState) throws MapTileModuleProviderBase.CantContinueException {
            if (MapTileFilesystemProvider.this.mTileSource == null) {
                return null;
            }
            MapTile tile = pState.getMapTile();
            if (!MapTileFilesystemProvider.this.getSdCardAvailable()) {
                return null;
            }
            File file = new File(OpenStreetMapTileProviderConstants.TILE_PATH_BASE, MapTileFilesystemProvider.this.mTileSource.getTileRelativeFilenameString(tile) + ".tile");
            if (file.exists()) {
                boolean fileExpired;
                long now = System.currentTimeMillis();
                long lastModified = file.lastModified();
                boolean bl = fileExpired = lastModified < now - MapTileFilesystemProvider.this.mMaximumCachedFileAge;
                if (!fileExpired) {
                    try {
                        Drawable drawable = MapTileFilesystemProvider.this.mTileSource.getDrawable(file.getPath());
                        return drawable;
                    }
                    catch (BitmapTileSourceBase.LowMemoryException e) {
                        logger.warn("LowMemoryException downloading MapTile: " + tile + " : " + e);
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileFilesystemProvider.this, (Throwable)e);
                    }
                }
                try {
                    Drawable drawable = MapTileFilesystemProvider.this.mTileSource.getDrawable(file.getPath());
                    this.tileCandidateLoaded(pState, drawable);
                    return null;
                }
                catch (BitmapTileSourceBase.LowMemoryException e) {
                    logger.warn("LowMemoryException downloading MapTile: " + tile + " : " + e);
                    throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileFilesystemProvider.this, (Throwable)e);
                }
            }
            return null;
        }
    }
}

