/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.contributor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.osmdroid.contributor.util.RecordedGeoPoint;
import org.osmdroid.contributor.util.RecordedRouteGPXFormatter;
import org.osmdroid.contributor.util.Util;
import org.osmdroid.contributor.util.constants.OpenStreetMapContributorConstants;

public class OSMUploader
implements OpenStreetMapContributorConstants {
    public static final String API_VERSION = "0.5";
    private static final int BUFFER_SIZE = 65535;
    private static final String BASE64_ENC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String BOUNDARY = "----------------------------d10f7aa230e8";
    private static final String LINE_END = "\r\n";
    private static final String DEFAULT_DESCRIPTION = "AndNav - automatically created route.";
    private static final String DEFAULT_TAGS = "AndNav";
    public static final SimpleDateFormat pseudoFileNameFormat = new SimpleDateFormat("yyyyMMdd'_'HHmmss'_'SSS");
    private static final SimpleDateFormat autoTagFormat = new SimpleDateFormat("MMMM yyyy");

    private OSMUploader() {
    }

    public static void uploadAsync(ArrayList<RecordedGeoPoint> recordedGeoPoints) {
        OSMUploader.uploadAsync(DEFAULT_DESCRIPTION, DEFAULT_TAGS, true, recordedGeoPoints);
    }

    public static void uploadAsync(String description, String tags, boolean addDateTags, ArrayList<RecordedGeoPoint> recordedGeoPoints) {
        OSMUploader.uploadAsync("PUT_YOUR_USERNAME_HERE", "PUT_YOUR_PASSWORD_HERE", description, tags, addDateTags, recordedGeoPoints, pseudoFileNameFormat.format(new GregorianCalendar().getTime()) + "_" + "PUT_YOUR_USERNAME_HERE" + ".gpx");
    }

    public static void uploadAsync(final String username, final String password, final String description, final String tags, final boolean addDateTags, final ArrayList<RecordedGeoPoint> recordedGeoPoints, final String pseudoFileName) {
        if (username == null || username.length() == 0) {
            return;
        }
        if (password == null || password.length() == 0) {
            return;
        }
        if (description == null || description.length() == 0) {
            return;
        }
        if (tags == null || tags.length() == 0) {
            return;
        }
        if (pseudoFileName == null || pseudoFileName.endsWith(".gpx")) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!Util.isSufficienDataForUpload(recordedGeoPoints)) {
                    return;
                }
                ByteArrayInputStream gpxInputStream = new ByteArrayInputStream(RecordedRouteGPXFormatter.create(recordedGeoPoints).getBytes());
                String tagsToUse = tags;
                if (addDateTags || tagsToUse == null) {
                    tagsToUse = tagsToUse == null ? autoTagFormat.format(new GregorianCalendar().getTime()) : tagsToUse + " " + autoTagFormat.format(new GregorianCalendar().getTime());
                }
                try {
                    String urlDesc = description == null ? OSMUploader.DEFAULT_DESCRIPTION : description.replaceAll("\\.;&?,/", "_");
                    String urlTags = tagsToUse == null ? OSMUploader.DEFAULT_TAGS : tagsToUse.replaceAll("\\\\.;&?,/", "_");
                    URL url = new URL("http://www.openstreetmap.org/api/0.5/gpx/create");
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setConnectTimeout(15000);
                    con.setRequestMethod("POST");
                    con.setDoOutput(true);
                    con.addRequestProperty("Authorization", "Basic " + OSMUploader.encodeBase64(username + ":" + password));
                    con.addRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------d10f7aa230e8");
                    con.addRequestProperty("Connection", "close");
                    con.addRequestProperty("Expect", "");
                    con.connect();
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(con.getOutputStream()));
                    OSMUploader.writeContentDispositionFile(out, "file", gpxInputStream, pseudoFileName);
                    OSMUploader.writeContentDisposition(out, "description", urlDesc);
                    OSMUploader.writeContentDisposition(out, "tags", urlTags);
                    OSMUploader.writeContentDisposition(out, "public", "1");
                    out.writeBytes("------------------------------d10f7aa230e8--\r\n");
                    out.flush();
                    int retCode = con.getResponseCode();
                    String retMsg = con.getResponseMessage();
                    if (retCode != 200) {
                        if (con.getHeaderField("Error") != null) {
                            retMsg = retMsg + "\n" + con.getHeaderField("Error");
                        }
                        con.disconnect();
                        throw new RuntimeException(retCode + " " + retMsg);
                    }
                    out.close();
                    con.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "OSMUpload-Thread").start();
    }

    public static void upload(String username, String password, String description, String tags, boolean addDateTags, ArrayList<RecordedGeoPoint> recordedGeoPoints, String pseudoFileName) throws IOException {
        OSMUploader.uploadAsync(username, password, description, tags, addDateTags, recordedGeoPoints, pseudoFileName);
    }

    private static void writeContentDispositionFile(DataOutputStream out, String name, InputStream gpxInputStream, String pseudoFileName) throws IOException {
        int read;
        out.writeBytes("------------------------------d10f7aa230e8\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + pseudoFileName + "\"" + LINE_END);
        out.writeBytes("Content-Type: application/octet-stream\r\n");
        out.writeBytes(LINE_END);
        byte[] buffer = new byte[65535];
        int sumread = 0;
        BufferedInputStream in = new BufferedInputStream(gpxInputStream);
        while ((read = ((InputStream)in).read(buffer)) >= 0) {
            out.write(buffer, 0, read);
            out.flush();
            sumread += read;
        }
        ((InputStream)in).close();
        out.writeBytes(LINE_END);
    }

    private static void writeContentDisposition(DataOutputStream out, String name, String value) throws IOException {
        out.writeBytes("------------------------------d10f7aa230e8\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + LINE_END);
        out.writeBytes(LINE_END);
        out.writeBytes(value + LINE_END);
    }

    private static String encodeBase64(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < (s.length() + 2) / 3; ++i) {
            int l = Math.min(3, s.length() - i * 3);
            String buf = s.substring(i * 3, i * 3 + l);
            out.append(BASE64_ENC.charAt(buf.charAt(0) >> 2));
            out.append(BASE64_ENC.charAt((buf.charAt(0) & 3) << 4 | (l == 1 ? 0 : (buf.charAt(1) & 0xF0) >> 4)));
            out.append(l > 1 ? BASE64_ENC.charAt((buf.charAt(1) & 0xF) << 2 | (l == 2 ? 0 : (buf.charAt(2) & 0xC0) >> 6)) : (char)'=');
            out.append(l > 2 ? BASE64_ENC.charAt(buf.charAt(2) & 0x3F) : (char)'=');
        }
        return out.toString();
    }
}

