/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileCache;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapTileProviderBase
implements IMapTileProviderCallback,
OpenStreetMapTileProviderConstants {
    private static final Logger logger = LoggerFactory.getLogger(MapTileProviderBase.class);
    protected final MapTileCache mTileCache = new MapTileCache();
    protected Handler mTileRequestCompleteHandler;
    protected boolean mUseDataConnection = true;
    private ITileSource mTileSource;

    public abstract Drawable getMapTile(MapTile var1);

    public abstract void detach();

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource = pTileSource;
        this.clearTileCache();
    }

    public ITileSource getTileSource() {
        return this.mTileSource;
    }

    public MapTileProviderBase(ITileSource pTileSource) {
        this(pTileSource, null);
    }

    public MapTileProviderBase(ITileSource pTileSource, Handler pDownloadFinishedListener) {
        this.mTileRequestCompleteHandler = pDownloadFinishedListener;
        this.mTileSource = pTileSource;
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState pState, Drawable pDrawable) {
        MapTile tile = pState.getMapTile();
        if (pDrawable != null) {
            this.mTileCache.putTile(tile, pDrawable);
        }
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(0);
        }
    }

    @Override
    public void mapTileRequestCandidate(MapTileRequestState pState, Drawable pDrawable) {
        this.mapTileRequestCompleted(pState, pDrawable);
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState pState) {
        MapTile tile = pState.getMapTile();
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(1);
        }
    }

    public void setTileRequestCompleteHandler(Handler handler) {
        this.mTileRequestCompleteHandler = handler;
    }

    public void ensureCapacity(int pCapacity) {
        this.mTileCache.ensureCapacity(pCapacity);
    }

    public void clearTileCache() {
        this.mTileCache.clear();
    }

    @Override
    public boolean useDataConnection() {
        return this.mUseDataConnection;
    }

    public void setUseDataConnection(boolean pMode) {
        this.mUseDataConnection = pMode;
    }
}

