/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.renderer.category;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.ArrayList;
import net.droidsolutions.droidcharts.awt.Ellipse2D;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.RectangularShape;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.LengthAdjustmentType;
import net.droidsolutions.droidcharts.common.ObjectList;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.axis.CategoryAxis;
import net.droidsolutions.droidcharts.core.axis.ValueAxis;
import net.droidsolutions.droidcharts.core.data.CategoryDataset;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.data.general.DatasetUtilities;
import net.droidsolutions.droidcharts.core.entity.CategoryItemEntity;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.label.CategoryItemLabelGenerator;
import net.droidsolutions.droidcharts.core.label.CategorySeriesLabelGenerator;
import net.droidsolutions.droidcharts.core.label.ItemLabelPosition;
import net.droidsolutions.droidcharts.core.label.StandardCategorySeriesLabelGenerator;
import net.droidsolutions.droidcharts.core.plot.CategoryCrosshairState;
import net.droidsolutions.droidcharts.core.plot.CategoryMarker;
import net.droidsolutions.droidcharts.core.plot.CategoryPlot;
import net.droidsolutions.droidcharts.core.plot.DrawingSupplier;
import net.droidsolutions.droidcharts.core.plot.IntervalMarker;
import net.droidsolutions.droidcharts.core.plot.Marker;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.ValueMarker;
import net.droidsolutions.droidcharts.core.renderer.AbstractRenderer;
import net.droidsolutions.droidcharts.core.renderer.CategoryItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.CategoryItemRendererState;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable {
    private static final long serialVersionUID = 1247553218442497391L;
    private CategoryPlot plot;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private CategorySeriesLabelGenerator legendItemLabelGenerator = new StandardCategorySeriesLabelGenerator();
    private CategorySeriesLabelGenerator legendItemToolTipGenerator;
    private CategorySeriesLabelGenerator legendItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;
    private CategoryItemLabelGenerator itemLabelGenerator = null;

    protected AbstractCategoryItemRenderer() {
    }

    @Override
    public int getPassCount() {
        return 1;
    }

    @Override
    public CategoryPlot getPlot() {
        return this.plot;
    }

    @Override
    public void setPlot(CategoryPlot plot) {
        if (plot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        this.plot = plot;
    }

    @Override
    public CategoryItemLabelGenerator getItemLabelGenerator(int row, int column) {
        return this.getSeriesItemLabelGenerator(row);
    }

    @Override
    public CategoryItemLabelGenerator getSeriesItemLabelGenerator(int series) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        CategoryItemLabelGenerator generator = (CategoryItemLabelGenerator)this.itemLabelGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseItemLabelGenerator;
        }
        return generator;
    }

    @Override
    public void setSeriesItemLabelGenerator(int series, CategoryItemLabelGenerator generator) {
        this.itemLabelGeneratorList.set(series, generator);
    }

    @Override
    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    @Override
    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator generator) {
        this.baseItemLabelGenerator = generator;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected CategoryItemRendererState createState(PlotRenderingInfo info) {
        return new CategoryItemRendererState(info);
    }

    @Override
    public CategoryItemRendererState initialise(Canvas g2, Rectangle2D dataArea, CategoryPlot plot, int rendererIndex, PlotRenderingInfo info) {
        this.setPlot(plot);
        CategoryDataset data = plot.getDataset(rendererIndex);
        if (data != null) {
            this.rowCount = data.getRowCount();
            this.columnCount = data.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        CategoryItemRendererState state = this.createState(info);
        int[] visibleSeriesTemp = new int[this.rowCount];
        int visibleSeriesCount = 0;
        int row = 0;
        while (row < this.rowCount) {
            if (this.isSeriesVisible(row)) {
                visibleSeriesTemp[visibleSeriesCount] = row;
                ++visibleSeriesCount;
            }
            ++row;
        }
        int[] visibleSeries = new int[visibleSeriesCount];
        System.arraycopy(visibleSeriesTemp, 0, visibleSeries, 0, visibleSeriesCount);
        state.setVisibleSeriesArray(visibleSeries);
        return state;
    }

    @Override
    public Range findRangeBounds(CategoryDataset dataset) {
        return this.findRangeBounds(dataset, false);
    }

    protected Range findRangeBounds(CategoryDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> visibleSeriesKeys = new ArrayList<Comparable>();
            int seriesCount = dataset.getRowCount();
            int s = 0;
            while (s < seriesCount) {
                if (this.isSeriesVisible(s)) {
                    visibleSeriesKeys.add(dataset.getRowKey(s));
                }
                ++s;
            }
            return DatasetUtilities.findRangeBounds(dataset, visibleSeriesKeys, includeInterval);
        }
        return DatasetUtilities.findRangeBounds(dataset, includeInterval);
    }

    @Override
    public double getItemMiddle(Comparable rowKey, Comparable columnKey, CategoryDataset dataset, CategoryAxis axis, Rectangle2D area, RectangleEdge edge) {
        return axis.getCategoryMiddle(columnKey, dataset.getColumnKeys(), area, edge);
    }

    @Override
    public void drawBackground(Canvas g2, CategoryPlot plot, Rectangle2D dataArea) {
        plot.drawBackground(g2, dataArea);
    }

    @Override
    public void drawOutline(Canvas g2, CategoryPlot plot, Rectangle2D dataArea) {
        plot.drawOutline(g2, dataArea);
    }

    @Override
    public void drawDomainGridline(Canvas g2, CategoryPlot plot, Rectangle2D dataArea, double value) {
        Float stroke;
        Line2D.Double line = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(dataArea.getMinX(), value, dataArea.getMaxX(), value);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(value, dataArea.getMinY(), value, dataArea.getMaxY());
        }
        Paint paint = plot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        if ((stroke = Float.valueOf(plot.getDomainGridlineStroke())) == null) {
            stroke = Float.valueOf(2.0f);
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(stroke.floatValue());
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    @Override
    public void drawRangeGridline(Canvas g2, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, double value) {
        Float stroke;
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        Line2D.Double line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        }
        Paint paint = plot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        if ((stroke = Float.valueOf(plot.getRangeGridlineStroke())) == null) {
            stroke = Float.valueOf(2.0f);
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(stroke.floatValue());
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    public void drawRangeLine(Canvas g2, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, double value, Paint paint, Float stroke) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Line2D.Double line = null;
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(stroke.floatValue());
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    @Override
    public void drawDomainMarker(Canvas g2, CategoryPlot plot, CategoryAxis axis, CategoryMarker marker, Rectangle2D dataArea) {
        int oldAlpha;
        Paint paint;
        Comparable category = marker.getKey();
        CategoryDataset dataset = plot.getDataset(plot.getIndexOf(this));
        int columnIndex = dataset.getColumnIndex(category);
        if (columnIndex < 0) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Rectangle2D bounds = null;
        if (marker.getDrawAsLine()) {
            double v = axis.getCategoryMiddle(columnIndex, dataset.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            }
            paint = marker.getPaint();
            oldAlpha = paint.getAlpha();
            paint.setAlpha(marker.getAlpha());
            Float stroke = Float.valueOf(marker.getStroke());
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeCap(Paint.Cap.ROUND);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
            paint.setAlpha(oldAlpha);
            bounds = line.getBounds2D();
        } else {
            double v0 = axis.getCategoryStart(columnIndex, dataset.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            double v1 = axis.getCategoryEnd(columnIndex, dataset.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            Rectangle2D.Double area = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                area = new Rectangle2D.Double(dataArea.getMinX(), v0, dataArea.getWidth(), v1 - v0);
            } else if (orientation == PlotOrientation.VERTICAL) {
                area = new Rectangle2D.Double(v0, dataArea.getMinY(), v1 - v0, dataArea.getHeight());
            }
            Paint paint2 = marker.getPaint();
            int oldAlpha2 = paint2.getAlpha();
            paint2.setAlpha(marker.getAlpha());
            paint2.setStyle(Paint.Style.FILL);
            g2.drawRect((float)area.getMinX(), (float)area.getMinY(), (float)area.getMaxX(), (float)area.getMaxY(), paint2);
            paint2.setAlpha(oldAlpha2);
            bounds = area;
        }
        String label = marker.getLabel();
        RectangleAnchor anchor = marker.getLabelAnchor();
        if (label != null) {
            Font labelFont = marker.getLabelFont();
            paint = marker.getLabelPaint();
            oldAlpha = paint.getAlpha();
            paint.setTypeface(labelFont.getTypeFace());
            paint.setTextSize((float)labelFont.getSize());
            paint.setAlpha(marker.getAlpha());
            Point2D coordinates = this.calculateDomainMarkerTextAnchorPoint(g2, orientation, dataArea, bounds, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
            TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), paint);
            paint.setAlpha(oldAlpha);
        }
    }

    @Override
    public void drawRangeMarker(Canvas g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = axis.getRange();
            if (!range.contains(value)) {
                return;
            }
            PlotOrientation orientation = plot.getOrientation();
            double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            }
            Paint paint = marker.getPaint();
            int oldAlpha = paint.getAlpha();
            paint.setAlpha(marker.getAlpha());
            Float stroke = Float.valueOf(marker.getStroke());
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeCap(Paint.Cap.ROUND);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
            paint.setAlpha(oldAlpha);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                Paint LabelPaint = marker.getLabelPaint();
                LabelPaint.setTypeface(labelFont.getTypeFace());
                LabelPaint.setTextSize((float)labelFont.getSize());
                LabelPaint.setAlpha(marker.getAlpha());
                Point2D coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, line.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), LabelPaint);
                LabelPaint.setAlpha(oldAlpha);
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = axis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            double start2d = axis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
            double end2d = axis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
            double low = Math.min(start2d, end2d);
            double high = Math.max(start2d, end2d);
            PlotOrientation orientation = plot.getOrientation();
            RectangularShape rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                low = Math.max(low, dataArea.getMinX());
                high = Math.min(high, dataArea.getMaxX());
                rect = new Rectangle2D.Double(low, dataArea.getMinY(), high - low, dataArea.getHeight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                low = Math.max(low, dataArea.getMinY());
                high = Math.min(high, dataArea.getMaxY());
                rect = new Rectangle2D.Double(dataArea.getMinX(), low, dataArea.getWidth(), high - low);
            }
            Paint p = marker.getPaint();
            int oldAlpha = p.getAlpha();
            p.setAlpha(marker.getAlpha());
            p.setStyle(Paint.Style.FILL);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), p);
            p.setAlpha(oldAlpha);
            if (im.getOutlinePaint() != null && im.getOutlineStroke() != null) {
                Line2D.Double line;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new Line2D.Double();
                    double x0 = dataArea.getMinX();
                    double x1 = dataArea.getMaxX();
                    Paint outlinePaint = im.getOutlinePaint();
                    outlinePaint.setAlpha(marker.getAlpha());
                    outlinePaint.setStyle(Paint.Style.STROKE);
                    outlinePaint.setStrokeCap(Paint.Cap.ROUND);
                    outlinePaint.setStrokeWidth(im.getOutlineStroke().floatValue());
                    if (range.contains(start)) {
                        ((Line2D)line).setLine(x0, start2d, x1, start2d);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), outlinePaint);
                    }
                    if (range.contains(end)) {
                        ((Line2D)line).setLine(x0, end2d, x1, end2d);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), outlinePaint);
                    }
                    outlinePaint.setAlpha(oldAlpha);
                } else {
                    line = new Line2D.Double();
                    double y0 = dataArea.getMinY();
                    double y1 = dataArea.getMaxY();
                    Paint outlinePaint = im.getOutlinePaint();
                    outlinePaint.setAlpha(marker.getAlpha());
                    outlinePaint.setStyle(Paint.Style.STROKE);
                    outlinePaint.setStrokeCap(Paint.Cap.ROUND);
                    outlinePaint.setStrokeWidth(im.getOutlineStroke().floatValue());
                    if (range.contains(start)) {
                        ((Line2D)line).setLine(start2d, y0, start2d, y1);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), outlinePaint);
                    }
                    if (range.contains(end)) {
                        ((Line2D)line).setLine(end2d, y0, end2d, y1);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), outlinePaint);
                    }
                    outlinePaint.setAlpha(oldAlpha);
                }
            }
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                Paint LabelPaint = marker.getLabelPaint();
                LabelPaint.setTypeface(labelFont.getTypeFace());
                LabelPaint.setTextSize((float)labelFont.getSize());
                LabelPaint.setAlpha(marker.getAlpha());
                Point2D coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, (Rectangle2D)rect, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), LabelPaint);
                LabelPaint.setAlpha(oldAlpha);
            }
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Canvas g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetType, RectangleAnchor anchor) {
        Rectangle2D anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetType);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, labelOffsetType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    protected Point2D calculateRangeMarkerTextAnchorPoint(Canvas g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetType, RectangleAnchor anchor) {
        Rectangle2D anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, labelOffsetType, LengthAdjustmentType.CONTRACT);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetType);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    @Override
    public LegendItem getLegendItem(int datasetIndex, int series) {
        String label;
        CategoryPlot p = this.getPlot();
        if (p == null) {
            return null;
        }
        if (!this.isSeriesVisible(series) || !this.isSeriesVisibleInLegend(series)) {
            return null;
        }
        CategoryDataset dataset = p.getDataset(datasetIndex);
        String description = label = this.legendItemLabelGenerator.generateLabel(dataset, series);
        String toolTipText = null;
        if (this.legendItemToolTipGenerator != null) {
            toolTipText = this.legendItemToolTipGenerator.generateLabel(dataset, series);
        }
        String urlText = null;
        if (this.legendItemURLGenerator != null) {
            urlText = this.legendItemURLGenerator.generateLabel(dataset, series);
        }
        Shape shape = this.lookupLegendShape(series);
        Paint paint = this.lookupSeriesPaint(series);
        Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
        Float outlineStroke = this.lookupSeriesOutlineStroke(series);
        LegendItem item = new LegendItem(label, description, toolTipText, urlText, shape, paint.getColor(), outlineStroke.floatValue(), outlinePaint.getColor());
        item.setLabelFont(this.lookupLegendTextFont(series));
        Paint labelPaint = this.lookupLegendTextPaint(series);
        if (labelPaint != null) {
            item.setLabelPaint(labelPaint);
        }
        item.setSeriesKey(dataset.getRowKey(series));
        item.setSeriesIndex(series);
        item.setDataset(dataset);
        item.setDatasetIndex(datasetIndex);
        return item;
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        CategoryPlot cp = this.getPlot();
        if (cp != null) {
            result = cp.getDrawingSupplier();
        }
        return result;
    }

    protected void updateCrosshairValues(CategoryCrosshairState crosshairState, Comparable rowKey, Comparable columnKey, double value, int datasetIndex, double transX, double transY, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairPoint(rowKey, columnKey, value, datasetIndex, transX, transY, orientation);
            } else {
                crosshairState.updateCrosshairX(rowKey, columnKey, datasetIndex, transX, orientation);
            }
        }
    }

    protected void drawItemLabel(Canvas g2, PlotOrientation orientation, CategoryDataset dataset, int row, int column, double x, double y, boolean negative) {
        CategoryItemLabelGenerator generator = this.getItemLabelGenerator(row, column);
        if (generator != null) {
            Font labelFont = this.getItemLabelFont(row, column);
            Paint paint = this.getItemLabelPaint(row, column);
            paint.setTypeface(labelFont.getTypeFace());
            paint.setTextSize((float)labelFont.getSize());
            String label = generator.generateLabel(dataset, row, column);
            ItemLabelPosition position = null;
            position = !negative ? this.getPositiveItemLabelPosition(row, column) : this.getNegativeItemLabelPosition(row, column);
            Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
            TextUtilities.drawRotatedString(label, g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
        }
    }

    protected CategoryAxis getDomainAxis(CategoryPlot plot, int index) {
        CategoryAxis result = plot.getDomainAxis(index);
        if (result == null) {
            result = plot.getDomainAxis();
        }
        return result;
    }

    protected ValueAxis getRangeAxis(CategoryPlot plot, int index) {
        ValueAxis result = plot.getRangeAxis(index);
        if (result == null) {
            result = plot.getRangeAxis();
        }
        return result;
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection result = new LegendItemCollection();
        int index = this.plot.getIndexOf(this);
        CategoryDataset dataset = this.plot.getDataset(index);
        if (dataset != null) {
            int seriesCount = dataset.getRowCount();
            int i = 0;
            while (i < seriesCount) {
                LegendItem item;
                if (this.isSeriesVisibleInLegend(i) && (item = this.getLegendItem(index, i)) != null) {
                    result.add(item);
                }
                ++i;
            }
        }
        return result;
    }

    public CategorySeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(CategorySeriesLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = generator;
    }

    public CategorySeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    protected void addItemEntity(EntityCollection entities, CategoryDataset dataset, int row, int column, Shape hotspot) {
        if (hotspot == null) {
            throw new IllegalArgumentException("Null 'hotspot' argument.");
        }
        if (!this.getItemCreateEntity(row, column)) {
            return;
        }
        CategoryItemEntity entity = new CategoryItemEntity(hotspot, "", "", dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
        entities.add(entity);
    }

    protected void addEntity(EntityCollection entities, Shape hotspot, CategoryDataset dataset, int row, int column, double entityX, double entityY) {
        if (!this.getItemCreateEntity(row, column)) {
            return;
        }
        Shape s = hotspot;
        if (hotspot == null) {
            double r = this.getDefaultEntityRadius();
            double w = r * 2.0;
            s = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(entityX - r, entityY - r, w, w) : new Ellipse2D.Double(entityY - r, entityX - r, w, w);
        }
        CategoryItemEntity entity = new CategoryItemEntity(s, "", "", dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
        entities.add(entity);
    }

    @Override
    public void setItemLabelGenerator(CategoryItemLabelGenerator generator) {
        this.itemLabelGenerator = generator;
    }
}

