/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.data.xy;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.droidsolutions.droidcharts.core.data.DomainInfo;
import net.droidsolutions.droidcharts.core.data.DomainOrder;
import net.droidsolutions.droidcharts.core.data.IntervalXYDataset;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.data.RangeInfo;
import net.droidsolutions.droidcharts.core.data.UnknownKeyException;
import net.droidsolutions.droidcharts.core.data.xy.AbstractIntervalXYDataset;
import net.droidsolutions.droidcharts.core.data.xy.IntervalXYDelegate;
import net.droidsolutions.droidcharts.core.data.xy.XYDataItem;
import net.droidsolutions.droidcharts.core.data.xy.XYSeries;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
RangeInfo,
Serializable {
    private static final long serialVersionUID = -7590013825931496766L;
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries series) {
        if (series != null) {
            this.data.add(series);
        }
    }

    @Override
    public DomainOrder getDomainOrder() {
        int seriesCount = this.getSeriesCount();
        int i = 0;
        while (i < seriesCount) {
            XYSeries s = this.getSeries(i);
            if (!s.getAutoSort()) {
                return DomainOrder.NONE;
            }
            ++i;
        }
        return DomainOrder.ASCENDING;
    }

    public void addSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
    }

    public void removeSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYSeries ts = (XYSeries)this.data.get(series);
        this.data.remove(series);
    }

    public void removeSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(series)) {
            this.data.remove(series);
        }
    }

    public void removeAllSeries() {
        int i = 0;
        while (i < this.data.size()) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            ++i;
        }
        this.data.clear();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int indexOf(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        return this.data.indexOf(series);
    }

    public XYSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYSeries)this.data.get(series);
    }

    public XYSeries getSeries(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        for (XYSeries series : this.data) {
            if (!key.equals(series.getKey())) continue;
            return series;
        }
        throw new UnknownKeyException("Key not found: " + key);
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public Number getX(int series, int item) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataItem xyItem = ts.getDataItem(item);
        return xyItem.getX();
    }

    @Override
    public Number getStartX(int series, int item) {
        return this.intervalDelegate.getStartX(series, item);
    }

    @Override
    public Number getEndX(int series, int item) {
        return this.intervalDelegate.getEndX(series, item);
    }

    @Override
    public Number getY(int series, int index) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataItem xyItem = ts.getDataItem(index);
        return xyItem.getY();
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public double getDomainLowerBound(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainLowerBound(includeInterval);
        }
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            XYSeries series = this.getSeries(s);
            double lowX = series.getMinX();
            if (Double.isNaN(result)) {
                result = lowX;
            } else if (!Double.isNaN(lowX)) {
                result = Math.min(result, lowX);
            }
            ++s;
        }
        return result;
    }

    @Override
    public double getDomainUpperBound(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainUpperBound(includeInterval);
        }
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            XYSeries series = this.getSeries(s);
            double hiX = series.getMaxX();
            if (Double.isNaN(result)) {
                result = hiX;
            } else if (!Double.isNaN(hiX)) {
                result = Math.max(result, hiX);
            }
            ++s;
        }
        return result;
    }

    @Override
    public Range getDomainBounds(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainBounds(includeInterval);
        }
        double lower = Double.POSITIVE_INFINITY;
        double upper = Double.NEGATIVE_INFINITY;
        int seriesCount = this.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            double maxX;
            XYSeries series = this.getSeries(s);
            double minX = series.getMinX();
            if (!Double.isNaN(minX)) {
                lower = Math.min(lower, minX);
            }
            if (!Double.isNaN(maxX = series.getMaxX())) {
                upper = Math.max(upper, maxX);
            }
            ++s;
        }
        if (lower > upper) {
            return null;
        }
        return new Range(lower, upper);
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double width) {
        if (width < 0.0) {
            throw new IllegalArgumentException("Negative 'width' argument.");
        }
        this.intervalDelegate.setFixedIntervalWidth(width);
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double factor) {
        this.intervalDelegate.setIntervalPositionFactor(factor);
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean b) {
        this.intervalDelegate.setAutoWidth(b);
    }

    @Override
    public Range getRangeBounds(boolean includeInterval) {
        double lower = Double.POSITIVE_INFINITY;
        double upper = Double.NEGATIVE_INFINITY;
        int seriesCount = this.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            double maxY;
            XYSeries series = this.getSeries(s);
            double minY = series.getMinY();
            if (!Double.isNaN(minY)) {
                lower = Math.min(lower, minY);
            }
            if (!Double.isNaN(maxY = series.getMaxY())) {
                upper = Math.max(upper, maxY);
            }
            ++s;
        }
        if (lower > upper) {
            return null;
        }
        return new Range(lower, upper);
    }

    @Override
    public double getRangeLowerBound(boolean includeInterval) {
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            XYSeries series = this.getSeries(s);
            double lowY = series.getMinY();
            if (Double.isNaN(result)) {
                result = lowY;
            } else if (!Double.isNaN(lowY)) {
                result = Math.min(result, lowY);
            }
            ++s;
        }
        return result;
    }

    @Override
    public double getRangeUpperBound(boolean includeInterval) {
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            XYSeries series = this.getSeries(s);
            double hiY = series.getMaxY();
            if (Double.isNaN(result)) {
                result = hiY;
            } else if (!Double.isNaN(hiY)) {
                result = Math.max(result, hiY);
            }
            ++s;
        }
        return result;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
    }
}

