/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.droidsolutions.droidcharts.core.data.DefaultKeyedValues;
import net.droidsolutions.droidcharts.core.data.KeyedValues2D;
import net.droidsolutions.droidcharts.core.data.UnknownKeyException;

public class DefaultKeyedValues2D
implements KeyedValues2D,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5514169970951994748L;
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();
    private boolean sortRowKeys;

    public DefaultKeyedValues2D() {
        this(false);
    }

    public DefaultKeyedValues2D(boolean sortRowKeys) {
        this.sortRowKeys = sortRowKeys;
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    @Override
    public Number getValue(int row, int column) {
        Comparable columnKey;
        int index;
        Number result = null;
        DefaultKeyedValues rowData = (DefaultKeyedValues)this.rows.get(row);
        if (rowData != null && (index = rowData.getIndex(columnKey = (Comparable)this.columnKeys.get(column))) >= 0) {
            result = rowData.getValue(index);
        }
        return result;
    }

    @Override
    public Comparable getRowKey(int row) {
        return (Comparable)this.rowKeys.get(row);
    }

    @Override
    public int getRowIndex(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, key);
        }
        return this.rowKeys.indexOf(key);
    }

    @Override
    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    @Override
    public Comparable getColumnKey(int column) {
        return (Comparable)this.columnKeys.get(column);
    }

    @Override
    public int getColumnIndex(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.columnKeys.indexOf(key);
    }

    @Override
    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    @Override
    public Number getValue(Comparable rowKey, Comparable columnKey) {
        if (rowKey == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (columnKey == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        if (!this.columnKeys.contains(columnKey)) {
            throw new UnknownKeyException("Unrecognised columnKey: " + columnKey);
        }
        int row = this.getRowIndex(rowKey);
        if (row >= 0) {
            DefaultKeyedValues rowData = (DefaultKeyedValues)this.rows.get(row);
            int col = rowData.getIndex(columnKey);
            return col >= 0 ? (Number)rowData.getValue(col) : (Number)null;
        }
        throw new UnknownKeyException("Unrecognised rowKey: " + rowKey);
    }

    public void addValue(Number value, Comparable rowKey, Comparable columnKey) {
        this.setValue(value, rowKey, columnKey);
    }

    public void setValue(Number value, Comparable rowKey, Comparable columnKey) {
        DefaultKeyedValues row;
        int rowIndex = this.getRowIndex(rowKey);
        if (rowIndex >= 0) {
            row = (DefaultKeyedValues)this.rows.get(rowIndex);
        } else {
            row = new DefaultKeyedValues();
            if (this.sortRowKeys) {
                rowIndex = -rowIndex - 1;
                this.rowKeys.add(rowIndex, rowKey);
                this.rows.add(rowIndex, row);
            } else {
                this.rowKeys.add(rowKey);
                this.rows.add(row);
            }
        }
        row.setValue(columnKey, value);
        int columnIndex = this.columnKeys.indexOf(columnKey);
        if (columnIndex < 0) {
            this.columnKeys.add(columnKey);
        }
    }

    public void removeValue(Comparable rowKey, Comparable columnKey) {
        int columnIndex;
        this.setValue(null, rowKey, columnKey);
        boolean allNull = true;
        int rowIndex = this.getRowIndex(rowKey);
        DefaultKeyedValues row = (DefaultKeyedValues)this.rows.get(rowIndex);
        int item = 0;
        int itemCount = row.getItemCount();
        while (item < itemCount) {
            if (row.getValue(item) != null) {
                allNull = false;
                break;
            }
            ++item;
        }
        if (allNull) {
            this.rowKeys.remove(rowIndex);
            this.rows.remove(rowIndex);
        }
        allNull = true;
        item = 0;
        itemCount = this.rows.size();
        while (item < itemCount) {
            row = (DefaultKeyedValues)this.rows.get(item);
            columnIndex = row.getIndex(columnKey);
            if (columnIndex >= 0 && row.getValue(columnIndex) != null) {
                allNull = false;
                break;
            }
            ++item;
        }
        if (allNull) {
            item = 0;
            itemCount = this.rows.size();
            while (item < itemCount) {
                row = (DefaultKeyedValues)this.rows.get(item);
                columnIndex = row.getIndex(columnKey);
                if (columnIndex >= 0) {
                    row.removeValue(columnIndex);
                }
                ++item;
            }
            this.columnKeys.remove(columnKey);
        }
    }

    public void removeRow(int rowIndex) {
        this.rowKeys.remove(rowIndex);
        this.rows.remove(rowIndex);
    }

    public void removeRow(Comparable rowKey) {
        if (rowKey == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        int index = this.getRowIndex(rowKey);
        if (index < 0) {
            throw new UnknownKeyException("Unknown key: " + rowKey);
        }
        this.removeRow(index);
    }

    public void removeColumn(int columnIndex) {
        Comparable columnKey = this.getColumnKey(columnIndex);
        this.removeColumn(columnKey);
    }

    public void removeColumn(Comparable columnKey) {
        if (columnKey == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        if (!this.columnKeys.contains(columnKey)) {
            throw new UnknownKeyException("Unknown key: " + columnKey);
        }
        for (DefaultKeyedValues rowData : this.rows) {
            int index = rowData.getIndex(columnKey);
            if (index < 0) continue;
            rowData.removeValue(columnKey);
        }
        this.columnKeys.remove(columnKey);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }
}

