/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.axis;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.core.axis.NumberAxis;
import net.droidsolutions.droidcharts.core.plot.IntervalMarker;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public class MarkerAxisBand
implements Serializable {
    private static final long serialVersionUID = -1729482413886398919L;
    private NumberAxis axis;
    private double topOuterGap;
    private double topInnerGap;
    private double bottomOuterGap;
    private double bottomInnerGap;
    private Font font;
    private List markers;

    public MarkerAxisBand(NumberAxis axis, double topOuterGap, double topInnerGap, double bottomOuterGap, double bottomInnerGap, Font font) {
        this.axis = axis;
        this.topOuterGap = topOuterGap;
        this.topInnerGap = topInnerGap;
        this.bottomOuterGap = bottomOuterGap;
        this.bottomInnerGap = bottomInnerGap;
        this.font = font;
        this.markers = new ArrayList();
    }

    public void addMarker(IntervalMarker marker) {
        this.markers.add(marker);
    }

    public double getHeight(Canvas g2) {
        double result = 0.0;
        if (this.markers.size() > 0) {
            Paint p = new Paint(1);
            p.setTextSize((float)this.font.getSize());
            Rectangle2D rec = TextUtilities.getTextBounds("123g", p);
            result = this.topOuterGap + this.topInnerGap + rec.getHeight() + this.bottomInnerGap + this.bottomOuterGap;
        }
        return result;
    }

    private void drawStringInRect(Canvas g2, Rectangle2D bounds, Font font, String text) {
        Paint p = new Paint(1);
        p.setTextSize((float)font.getSize());
        Rectangle2D r = TextUtilities.getTextBounds(text, p);
        double x = bounds.getX();
        if (r.getWidth() < bounds.getWidth()) {
            x += (bounds.getWidth() - r.getWidth()) / 2.0;
        }
        g2.drawText(text, (float)x, (float)(bounds.getMaxY() - this.bottomInnerGap), p);
    }

    public void draw(Canvas g2, Rectangle2D plotArea, Rectangle2D dataArea, double x, double y) {
        double h = this.getHeight(g2);
        for (IntervalMarker marker : this.markers) {
            double start = Math.max(marker.getStartValue(), this.axis.getRange().getLowerBound());
            double end = Math.min(marker.getEndValue(), this.axis.getRange().getUpperBound());
            double s = this.axis.valueToJava2D(start, dataArea, RectangleEdge.BOTTOM);
            double e = this.axis.valueToJava2D(end, dataArea, RectangleEdge.BOTTOM);
            Rectangle2D.Double r = new Rectangle2D.Double(s, y + this.topOuterGap, e - s, h - this.topOuterGap - this.bottomOuterGap);
            Paint p = marker.getPaint();
            p.setAlpha(marker.getAlpha());
            p.setStyle(Paint.Style.FILL);
            g2.drawRect((float)r.getMinX(), (float)r.getMinY(), (float)r.getMaxX(), (float)r.getMaxY(), p);
            p = marker.getOutlinePaint();
            p.setStyle(Paint.Style.STROKE);
            g2.drawRect((float)r.getMinX(), (float)r.getMinY(), (float)r.getMaxX(), (float)r.getMaxY(), p);
            p.setAlpha(255);
            Paint stringPaint = new Paint(1);
            stringPaint.setColor(-16777216);
            this.drawStringInRect(g2, r, this.font, marker.getLabel());
        }
    }
}

