/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.droidsolutions.droidcharts.awt.Ellipse2D;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.RectangularShape;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.Layer;
import net.droidsolutions.droidcharts.common.LengthAdjustmentType;
import net.droidsolutions.droidcharts.common.ObjectList;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.anotations.XYAnnotation;
import net.droidsolutions.droidcharts.core.axis.ValueAxis;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.data.general.DatasetUtilities;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.entity.XYItemEntity;
import net.droidsolutions.droidcharts.core.label.ItemLabelPosition;
import net.droidsolutions.droidcharts.core.label.StandardXYSeriesLabelGenerator;
import net.droidsolutions.droidcharts.core.label.XYItemLabelGenerator;
import net.droidsolutions.droidcharts.core.label.XYSeriesLabelGenerator;
import net.droidsolutions.droidcharts.core.plot.CrosshairState;
import net.droidsolutions.droidcharts.core.plot.DrawingSupplier;
import net.droidsolutions.droidcharts.core.plot.IntervalMarker;
import net.droidsolutions.droidcharts.core.plot.Marker;
import net.droidsolutions.droidcharts.core.plot.Plot;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.ValueMarker;
import net.droidsolutions.droidcharts.core.plot.XYPlot;
import net.droidsolutions.droidcharts.core.renderer.AbstractRenderer;
import net.droidsolutions.droidcharts.core.renderer.xy.XYItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.xy.XYItemRendererState;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer {
    private static final long serialVersionUID = 8019124836026607990L;
    private XYPlot plot;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private XYItemLabelGenerator baseItemLabelGenerator;
    private ObjectList toolTipGeneratorList;
    private List backgroundAnnotations = new ArrayList();
    private List foregroundAnnotations = new ArrayList();
    private XYSeriesLabelGenerator legendItemLabelGenerator = new StandardXYSeriesLabelGenerator("{0}");
    private XYSeriesLabelGenerator legendItemToolTipGenerator;
    private XYSeriesLabelGenerator legendItemURLGenerator;

    protected AbstractXYItemRenderer() {
    }

    @Override
    public int getPassCount() {
        return 1;
    }

    @Override
    public XYPlot getPlot() {
        return this.plot;
    }

    @Override
    public void setPlot(XYPlot plot) {
        this.plot = plot;
    }

    @Override
    public XYItemRendererState initialise(Canvas g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYItemRendererState state = new XYItemRendererState(info);
        return state;
    }

    @Override
    public XYItemLabelGenerator getItemLabelGenerator(int series, int item) {
        XYItemLabelGenerator generator = (XYItemLabelGenerator)this.itemLabelGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseItemLabelGenerator;
        }
        return generator;
    }

    @Override
    public XYItemLabelGenerator getSeriesItemLabelGenerator(int series) {
        return (XYItemLabelGenerator)this.itemLabelGeneratorList.get(series);
    }

    @Override
    public void setSeriesItemLabelGenerator(int series, XYItemLabelGenerator generator) {
        this.itemLabelGeneratorList.set(series, generator);
    }

    @Override
    public XYItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    @Override
    public void setBaseItemLabelGenerator(XYItemLabelGenerator generator) {
        this.baseItemLabelGenerator = generator;
    }

    @Override
    public void addAnnotation(XYAnnotation annotation) {
        this.addAnnotation(annotation, Layer.FOREGROUND);
    }

    @Override
    public void addAnnotation(XYAnnotation annotation, Layer layer) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        if (layer.equals(Layer.FOREGROUND)) {
            this.foregroundAnnotations.add(annotation);
        } else if (layer.equals(Layer.BACKGROUND)) {
            this.backgroundAnnotations.add(annotation);
        } else {
            throw new RuntimeException("Unknown layer.");
        }
    }

    @Override
    public boolean removeAnnotation(XYAnnotation annotation) {
        boolean removed = this.foregroundAnnotations.remove(annotation);
        return removed &= this.backgroundAnnotations.remove(annotation);
    }

    @Override
    public void removeAnnotations() {
        this.foregroundAnnotations.clear();
        this.backgroundAnnotations.clear();
    }

    public Collection getAnnotations() {
        ArrayList result = new ArrayList(this.foregroundAnnotations);
        result.addAll(this.backgroundAnnotations);
        return result;
    }

    @Override
    public XYSeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    @Override
    public void setLegendItemLabelGenerator(XYSeriesLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = generator;
    }

    @Override
    public Range findDomainBounds(XYDataset dataset) {
        return this.findDomainBounds(dataset, false);
    }

    protected Range findDomainBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> visibleSeriesKeys = new ArrayList<Comparable>();
            int seriesCount = dataset.getSeriesCount();
            int s = 0;
            while (s < seriesCount) {
                if (this.isSeriesVisible(s)) {
                    visibleSeriesKeys.add(dataset.getSeriesKey(s));
                }
                ++s;
            }
            return DatasetUtilities.findDomainBounds(dataset, visibleSeriesKeys, includeInterval);
        }
        return DatasetUtilities.findDomainBounds(dataset, includeInterval);
    }

    @Override
    public Range findRangeBounds(XYDataset dataset) {
        return this.findRangeBounds(dataset, false);
    }

    protected Range findRangeBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> visibleSeriesKeys = new ArrayList<Comparable>();
            int seriesCount = dataset.getSeriesCount();
            int s = 0;
            while (s < seriesCount) {
                if (this.isSeriesVisible(s)) {
                    visibleSeriesKeys.add(dataset.getSeriesKey(s));
                }
                ++s;
            }
            Range xRange = null;
            XYPlot p = this.getPlot();
            if (p != null) {
                ValueAxis xAxis = null;
                int index = p.getIndexOf(this);
                if (index >= 0) {
                    xAxis = this.plot.getDomainAxisForDataset(index);
                }
                if (xAxis != null) {
                    xRange = xAxis.getRange();
                }
            }
            if (xRange == null) {
                xRange = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
            return DatasetUtilities.findRangeBounds(dataset, visibleSeriesKeys, xRange, includeInterval);
        }
        return DatasetUtilities.findRangeBounds(dataset, includeInterval);
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection result = new LegendItemCollection();
        int index = this.plot.getIndexOf(this);
        XYDataset dataset = this.plot.getDataset(index);
        if (dataset != null) {
            int seriesCount = dataset.getSeriesCount();
            int i = 0;
            while (i < seriesCount) {
                LegendItem item;
                if (this.isSeriesVisibleInLegend(i) && (item = this.getLegendItem(index, i)) != null) {
                    result.add(item);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot xyplot = this.getPlot();
        if (xyplot != null && (dataset = xyplot.getDataset(datasetIndex)) != null) {
            String label;
            String description = label = this.legendItemLabelGenerator.generateLabel(dataset, series);
            Shape shape = this.lookupLegendShape(series);
            Paint paint = this.lookupSeriesPaint(series);
            Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
            Float outlineStroke = this.lookupSeriesOutlineStroke(series);
            result = new LegendItem(label, description, "", "", shape, paint.getColor(), outlineStroke.floatValue(), outlinePaint.getColor());
            Paint labelPaint = this.lookupLegendTextPaint(series);
            result.setLabelFont(this.lookupLegendTextFont(series));
            if (labelPaint != null) {
                result.setLabelPaint(labelPaint);
            }
            result.setSeriesKey(dataset.getSeriesKey(series));
            result.setSeriesIndex(series);
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
        }
        return result;
    }

    @Override
    public void fillDomainGridBand(Canvas g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double start, double end) {
        double x1 = axis.valueToJava2D(start, dataArea, plot.getDomainAxisEdge());
        double x2 = axis.valueToJava2D(end, dataArea, plot.getDomainAxisEdge());
        Rectangle2D.Double band = plot.getOrientation() == PlotOrientation.VERTICAL ? new Rectangle2D.Double(Math.min(x1, x2), dataArea.getMinY(), Math.abs(x2 - x1), dataArea.getWidth()) : new Rectangle2D.Double(dataArea.getMinX(), Math.min(x1, x2), dataArea.getWidth(), Math.abs(x2 - x1));
        Paint paint = plot.getDomainTickBandPaint();
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
            g2.drawRect((float)band.getMinX(), (float)band.getMinY(), (float)band.getMaxX(), (float)band.getMaxY(), paint);
        }
    }

    @Override
    public void fillRangeGridBand(Canvas g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double start, double end) {
        double y1 = axis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
        double y2 = axis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
        Rectangle2D.Double band = plot.getOrientation() == PlotOrientation.VERTICAL ? new Rectangle2D.Double(dataArea.getMinX(), Math.min(y1, y2), dataArea.getWidth(), Math.abs(y2 - y1)) : new Rectangle2D.Double(Math.min(y1, y2), dataArea.getMinY(), Math.abs(y2 - y1), dataArea.getHeight());
        Paint paint = plot.getRangeTickBandPaint();
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
            g2.drawRect((float)band.getMinX(), (float)band.getMinY(), (float)band.getMaxX(), (float)band.getMaxY(), paint);
        }
    }

    @Override
    public void drawDomainGridLine(Canvas g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double v = axis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
        Line2D.Double line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        }
        Paint paint = plot.getDomainGridlinePaint();
        Float stroke = plot.getDomainGridlineStroke();
        Paint p = paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT;
        Float s = Float.valueOf(stroke != null ? stroke.floatValue() : 0.5f);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeWidth(s.floatValue());
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), p);
    }

    public void drawDomainLine(Canvas g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double value, Paint paint, Float stroke) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Line2D.Double line = null;
        double v = axis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(stroke.floatValue());
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    @Override
    public void drawRangeLine(Canvas g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double value, Paint paint, Float stroke) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Line2D.Double line = null;
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(stroke.floatValue());
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    @Override
    public void drawDomainMarker(Canvas g2, XYPlot plot, ValueAxis domainAxis, Marker marker, Rectangle2D dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = domainAxis.getRange();
            if (!range.contains(value)) {
                return;
            }
            double v = domainAxis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            }
            Paint paint = marker.getPaint();
            int oldAlpha = paint.getAlpha();
            paint.setAlpha(marker.getAlpha());
            Float stroke = Float.valueOf(marker.getStroke());
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                Paint lPaint = marker.getLabelPaint();
                lPaint.setTypeface(labelFont.getTypeFace());
                lPaint.setTextSize((float)labelFont.getSize());
                int lOldAlpha = lPaint.getAlpha();
                lPaint.setAlpha(marker.getAlpha());
                Point2D coordinates = this.calculateDomainMarkerTextAnchorPoint(g2, orientation, dataArea, line.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), lPaint);
                lPaint.setAlpha(lOldAlpha);
            }
            paint.setAlpha(oldAlpha);
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = domainAxis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            double start2d = domainAxis.valueToJava2D(start, dataArea, plot.getDomainAxisEdge());
            double end2d = domainAxis.valueToJava2D(end, dataArea, plot.getDomainAxisEdge());
            double low = Math.min(start2d, end2d);
            double high = Math.max(start2d, end2d);
            PlotOrientation orientation = plot.getOrientation();
            RectangularShape rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                low = Math.max(low, dataArea.getMinY());
                high = Math.min(high, dataArea.getMaxY());
                rect = new Rectangle2D.Double(dataArea.getMinX(), low, dataArea.getWidth(), high - low);
            } else if (orientation == PlotOrientation.VERTICAL) {
                low = Math.max(low, dataArea.getMinX());
                high = Math.min(high, dataArea.getMaxX());
                rect = new Rectangle2D.Double(low, dataArea.getMinY(), high - low, dataArea.getHeight());
            }
            Paint p = marker.getPaint();
            int oldAlpha = p.getAlpha();
            p.setAlpha(marker.getAlpha());
            p.setStyle(Paint.Style.FILL);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), p);
            p.setAlpha(oldAlpha);
            if (im.getOutlinePaint() != null && im.getOutlineStroke() != null) {
                Line2D.Double line;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new Line2D.Double();
                    double y0 = dataArea.getMinY();
                    double y1 = dataArea.getMaxY();
                    Paint oPiant = im.getOutlinePaint();
                    oPiant.setStyle(Paint.Style.STROKE);
                    int oOldAlpha = oPiant.getAlpha();
                    oPiant.setAlpha(marker.getAlpha());
                    oPiant.setStrokeWidth(im.getOutlineStroke().floatValue());
                    if (range.contains(start)) {
                        ((Line2D)line).setLine(start2d, y0, start2d, y1);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    if (range.contains(end)) {
                        ((Line2D)line).setLine(end2d, y0, end2d, y1);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    oPiant.setAlpha(oOldAlpha);
                } else {
                    line = new Line2D.Double();
                    double x0 = dataArea.getMinX();
                    double x1 = dataArea.getMaxX();
                    Paint oPiant = im.getOutlinePaint();
                    oPiant.setStyle(Paint.Style.STROKE);
                    int oOldAlpha = oPiant.getAlpha();
                    oPiant.setAlpha(marker.getAlpha());
                    oPiant.setStrokeWidth(im.getOutlineStroke().floatValue());
                    if (range.contains(start)) {
                        ((Line2D)line).setLine(x0, start2d, x1, start2d);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    if (range.contains(end)) {
                        ((Line2D)line).setLine(x0, end2d, x1, end2d);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    oPiant.setAlpha(oOldAlpha);
                }
            }
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                Paint paint = marker.getLabelPaint();
                paint.setTypeface(labelFont.getTypeFace());
                paint.setTextSize((float)labelFont.getSize());
                Point2D coordinates = this.calculateDomainMarkerTextAnchorPoint(g2, orientation, dataArea, (Rectangle2D)rect, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), paint);
            }
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Canvas g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetType, RectangleAnchor anchor) {
        Rectangle2D anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetType);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, labelOffsetType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    @Override
    public void drawRangeMarker(Canvas g2, XYPlot plot, ValueAxis rangeAxis, Marker marker, Rectangle2D dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = rangeAxis.getRange();
            if (!range.contains(value)) {
                return;
            }
            double v = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            }
            Paint oPiant = marker.getPaint();
            oPiant.setStyle(Paint.Style.STROKE);
            int oOldAlpha = oPiant.getAlpha();
            oPiant.setAlpha(marker.getAlpha());
            oPiant.setStrokeWidth(marker.getStroke());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
            oPiant.setAlpha(oOldAlpha);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                Paint paint = marker.getLabelPaint();
                paint.setTypeface(labelFont.getTypeFace());
                paint.setTextSize((float)labelFont.getSize());
                Point2D coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, line.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), paint);
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = rangeAxis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            double start2d = rangeAxis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
            double end2d = rangeAxis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
            double low = Math.min(start2d, end2d);
            double high = Math.max(start2d, end2d);
            PlotOrientation orientation = plot.getOrientation();
            RectangularShape rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                low = Math.max(low, dataArea.getMinX());
                high = Math.min(high, dataArea.getMaxX());
                rect = new Rectangle2D.Double(low, dataArea.getMinY(), high - low, dataArea.getHeight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                low = Math.max(low, dataArea.getMinY());
                high = Math.min(high, dataArea.getMaxY());
                rect = new Rectangle2D.Double(dataArea.getMinX(), low, dataArea.getWidth(), high - low);
            }
            Paint p = marker.getPaint();
            int oldAlpha = p.getAlpha();
            p.setAlpha(marker.getAlpha());
            p.setStyle(Paint.Style.FILL);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), p);
            p.setAlpha(oldAlpha);
            if (im.getOutlinePaint() != null && im.getOutlineStroke() != null) {
                Line2D.Double line;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new Line2D.Double();
                    double x0 = dataArea.getMinX();
                    double x1 = dataArea.getMaxX();
                    Paint oPiant = im.getOutlinePaint();
                    oPiant.setStyle(Paint.Style.STROKE);
                    int oOldAlpha = oPiant.getAlpha();
                    oPiant.setAlpha(marker.getAlpha());
                    oPiant.setStrokeWidth(im.getOutlineStroke().floatValue());
                    if (range.contains(start)) {
                        ((Line2D)line).setLine(x0, start2d, x1, start2d);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    if (range.contains(end)) {
                        ((Line2D)line).setLine(x0, end2d, x1, end2d);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    oPiant.setAlpha(oOldAlpha);
                } else {
                    line = new Line2D.Double();
                    double y0 = dataArea.getMinY();
                    double y1 = dataArea.getMaxY();
                    Paint oPiant = im.getOutlinePaint();
                    oPiant.setStyle(Paint.Style.STROKE);
                    int oOldAlpha = oPiant.getAlpha();
                    oPiant.setAlpha(marker.getAlpha());
                    oPiant.setStrokeWidth(im.getOutlineStroke().floatValue());
                    if (range.contains(start)) {
                        ((Line2D)line).setLine(start2d, y0, start2d, y1);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    if (range.contains(end)) {
                        ((Line2D)line).setLine(end2d, y0, end2d, y1);
                        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), oPiant);
                    }
                    oPiant.setAlpha(oOldAlpha);
                }
            }
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                Paint paint = marker.getLabelPaint();
                paint.setTypeface(labelFont.getTypeFace());
                paint.setTextSize((float)labelFont.getSize());
                Point2D coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, (Rectangle2D)rect, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor(), paint);
            }
        }
    }

    private Point2D calculateRangeMarkerTextAnchorPoint(Canvas g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetForRange, RectangleAnchor anchor) {
        Rectangle2D anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, labelOffsetForRange, LengthAdjustmentType.CONTRACT);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectangle(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetForRange);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        XYPlot p = this.getPlot();
        if (p != null) {
            result = p.getDrawingSupplier();
        }
        return result;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double x, double y, int domainAxisIndex, int rangeAxisIndex, double transX, double transY, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(x, y, domainAxisIndex, rangeAxisIndex, transX, transY, orientation);
                } else {
                    crosshairState.updateCrosshairX(x, domainAxisIndex);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(y, rangeAxisIndex);
            }
        }
    }

    protected void drawItemLabel(Canvas g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
        XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
        if (generator != null) {
            Font labelFont = this.getItemLabelFont(series, item);
            Paint paint = this.getItemLabelPaint(series, item);
            paint.setTypeface(labelFont.getTypeFace());
            paint.setTextSize((float)labelFont.getSize());
            String label = generator.generateLabel(dataset, series, item);
            ItemLabelPosition position = null;
            position = !negative ? this.getPositiveItemLabelPosition(series, item) : this.getNegativeItemLabelPosition(series, item);
            Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
            TextUtilities.drawRotatedString(label, g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawAnnotations(Canvas g2, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, Layer layer, PlotRenderingInfo info) {
        Iterator iterator = null;
        if (layer.equals(Layer.FOREGROUND)) {
            iterator = this.foregroundAnnotations.iterator();
        } else {
            if (!layer.equals(Layer.BACKGROUND)) {
                throw new RuntimeException("Unknown layer.");
            }
            iterator = this.backgroundAnnotations.iterator();
        }
        while (iterator.hasNext()) {
            XYAnnotation annotation = (XYAnnotation)iterator.next();
            annotation.draw(g2, this.plot, dataArea, domainAxis, rangeAxis, 0, info);
        }
    }

    protected void addEntity(EntityCollection entities, Shape area, XYDataset dataset, int series, int item, double entityX, double entityY) {
        if (!this.getItemCreateEntity(series, item)) {
            return;
        }
        Shape hotspot = area;
        if (hotspot == null) {
            double r = this.getDefaultEntityRadius();
            double w = r * 2.0;
            hotspot = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(entityX - r, entityY - r, w, w) : new Ellipse2D.Double(entityY - r, entityX - r, w, w);
        }
        XYItemEntity entity = new XYItemEntity(hotspot, dataset, series, item, "", "");
        entities.add(entity);
    }

    public static boolean isPointInRect(Rectangle2D rect, double x, double y) {
        return x >= rect.getMinX() && x <= rect.getMaxX() && y >= rect.getMinY() && y <= rect.getMaxY();
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double x, double y, double transX, double transY, PlotOrientation orientation) {
        this.updateCrosshairValues(crosshairState, x, y, 0, 0, transX, transY, orientation);
    }
}

