/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.plot;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Ellipse2D;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.LegendItemSource;
import net.droidsolutions.droidcharts.core.axis.AxisLocation;
import net.droidsolutions.droidcharts.core.data.general.DatasetGroup;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.entity.PlotEntity;
import net.droidsolutions.droidcharts.core.plot.DefaultDrawingSupplier;
import net.droidsolutions.droidcharts.core.plot.DrawingSupplier;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.PlotState;
import net.droidsolutions.droidcharts.core.text.G2TextMeasurer;
import net.droidsolutions.droidcharts.core.text.TextBlock;
import net.droidsolutions.droidcharts.core.text.TextBlockAnchor;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public abstract class Plot
implements LegendItemSource,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8831571430103671324L;
    public static final Number ZERO = new Integer(0);
    public static final RectangleInsets DEFAULT_INSETS = new RectangleInsets(0.0, 0.0, 0.0, 0.0);
    public static final float DEFAULT_OUTLINE_STROKE = 0.5f;
    public static final Paint DEFAULT_OUTLINE_PAINT = new Paint(1);
    public static final int DEFAULT_FOREGROUND_ALPHA = 200;
    public static final int DEFAULT_BACKGROUND_ALPHA = 200;
    public static final Paint DEFAULT_BACKGROUND_PAINT;
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    public static final Shape DEFAULT_LEGEND_ITEM_BOX;
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE;
    private Plot parent = null;
    private DatasetGroup datasetGroup;
    private String noDataMessage = null;
    private Font noDataMessageFont;
    private transient Paint noDataMessagePaint;
    private RectangleInsets insets = DEFAULT_INSETS;
    private boolean outlineVisible = true;
    private transient float outlineStroke = 0.5f;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint = DEFAULT_BACKGROUND_PAINT;
    private int backgroundImageAlignment = 15;
    private float backgroundImageAlpha = 0.5f;
    private int foregroundAlpha = 200;
    private int backgroundAlpha = 200;
    private DrawingSupplier drawingSupplier;
    private boolean notify;

    static {
        DEFAULT_OUTLINE_PAINT.setColor(-12303292);
        DEFAULT_BACKGROUND_PAINT = new Paint(1);
        DEFAULT_BACKGROUND_PAINT.setColor(-1);
        DEFAULT_LEGEND_ITEM_BOX = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        DEFAULT_LEGEND_ITEM_CIRCLE = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    }

    protected Plot() {
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.noDataMessageFont = new Font("SansSerif", 0, 12);
        this.noDataMessagePaint = new Paint(1);
        this.noDataMessagePaint.setARGB(0, 255, 255, 255);
        this.drawingSupplier = new DefaultDrawingSupplier();
    }

    public DatasetGroup getDatasetGroup() {
        return this.datasetGroup;
    }

    protected void setDatasetGroup(DatasetGroup group) {
        this.datasetGroup = group;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String message) {
        this.noDataMessage = message;
    }

    public Font getNoDataMessageFont() {
        return this.noDataMessageFont;
    }

    public void setNoDataMessageFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.noDataMessageFont = font;
    }

    public Paint getNoDataMessagePaint() {
        return this.noDataMessagePaint;
    }

    public void setNoDataMessagePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.noDataMessagePaint = paint;
    }

    public abstract String getPlotType();

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(Plot parent) {
        this.parent = parent;
    }

    public Plot getRootPlot() {
        Plot p = this.getParent();
        if (p == null) {
            return this;
        }
        return p.getRootPlot();
    }

    public boolean isSubplot() {
        return this.getParent() != null;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets insets) {
        this.setInsets(insets, true);
    }

    public void setInsets(RectangleInsets insets, boolean notify) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!this.insets.equals(insets)) {
            this.insets = insets;
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
        }
    }

    public int getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(int alpha) {
        if (this.backgroundAlpha != alpha) {
            this.backgroundAlpha = alpha;
        }
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        Plot p = this.getParent();
        result = p != null ? p.getDrawingSupplier() : this.drawingSupplier;
        return result;
    }

    public void setDrawingSupplier(DrawingSupplier supplier) {
        this.drawingSupplier = supplier;
    }

    public void setDrawingSupplier(DrawingSupplier supplier, boolean notify) {
        this.drawingSupplier = supplier;
    }

    public boolean isOutlineVisible() {
        return this.outlineVisible;
    }

    public void setOutlineVisible(boolean visible) {
        this.outlineVisible = visible;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(float stroke) {
        this.outlineStroke = stroke;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
        }
    }

    public int getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(int alpha) {
        if (this.foregroundAlpha != alpha) {
            this.foregroundAlpha = alpha;
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        return null;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public abstract void draw(Canvas var1, Rectangle2D var2, Point2D var3, PlotState var4, PlotRenderingInfo var5);

    public void drawBackground(Canvas g2, Rectangle2D area) {
        this.fillBackground(g2, area);
    }

    protected void fillBackground(Canvas g2, Rectangle2D area) {
        this.fillBackground(g2, area, PlotOrientation.VERTICAL);
    }

    protected void fillBackground(Canvas g2, Rectangle2D area, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (this.backgroundPaint == null) {
            return;
        }
        Paint p = this.backgroundPaint;
        int oldAlpha = p.getAlpha();
        Paint.Style oldStyle = p.getStyle();
        p.setAlpha(150);
        p.setStyle(Paint.Style.FILL);
        g2.drawRect((float)area.getMinX(), (float)area.getMinY(), (float)area.getMaxX(), (float)area.getMaxY(), p);
        p.setAlpha(oldAlpha);
        p.setStyle(oldStyle);
    }

    public void drawOutline(Canvas g2, Rectangle2D area) {
        if (!this.outlineVisible) {
            return;
        }
        if (this.outlinePaint != null) {
            float oldStroke = this.outlinePaint.getStrokeWidth();
            Paint.Style oldStyle = this.outlinePaint.getStyle();
            this.outlinePaint.setStrokeWidth(this.outlineStroke);
            this.outlinePaint.setStyle(Paint.Style.STROKE);
            g2.drawRect((float)area.getMinX(), (float)area.getMinY(), (float)area.getMaxX(), (float)area.getMaxY(), this.outlinePaint);
            this.outlinePaint.setStrokeWidth(this.outlineStroke);
            this.outlinePaint.setStyle(oldStyle);
        }
    }

    protected void drawNoDataMessage(Canvas g2, Rectangle2D area) {
        g2.save();
        g2.clipRect((float)area.getMinX(), (float)area.getMinY(), (float)area.getMaxX(), (float)area.getMaxY());
        String message = this.noDataMessage;
        if (message != null) {
            TextBlock block = TextUtilities.createTextBlock(this.noDataMessage, this.noDataMessageFont, this.noDataMessagePaint, 0.9f * (float)area.getWidth(), new G2TextMeasurer(this.noDataMessagePaint));
            block.draw(g2, (float)area.getCenterX(), (float)area.getCenterY(), TextBlockAnchor.CENTER, this.noDataMessagePaint);
        }
        g2.restore();
    }

    protected void createAndAddEntity(Rectangle2D dataArea, PlotRenderingInfo plotState, String toolTip, String urlText) {
        EntityCollection e;
        if (plotState != null && plotState.getOwner() != null && (e = plotState.getOwner().getEntityCollection()) != null) {
            e.add(new PlotEntity(dataArea, this, toolTip, urlText));
        }
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
    }

    public void zoom(double percent) {
    }

    protected double getRectX(double x, double w1, double w2, RectangleEdge edge) {
        double result = x;
        if (edge == RectangleEdge.LEFT) {
            result += w1;
        } else if (edge == RectangleEdge.RIGHT) {
            result += w2;
        }
        return result;
    }

    protected double getRectY(double y, double h1, double h2, RectangleEdge edge) {
        double result = y;
        if (edge == RectangleEdge.TOP) {
            result += h1;
        } else if (edge == RectangleEdge.BOTTOM) {
            result += h2;
        }
        return result;
    }

    public static RectangleEdge resolveDomainAxisLocation(AxisLocation location, PlotOrientation orientation) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        RectangleEdge result = null;
        if (location == AxisLocation.TOP_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.RIGHT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.TOP;
            }
        } else if (location == AxisLocation.TOP_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.LEFT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.TOP;
            }
        } else if (location == AxisLocation.BOTTOM_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.RIGHT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.BOTTOM;
            }
        } else if (location == AxisLocation.BOTTOM_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.LEFT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.BOTTOM;
            }
        }
        if (result == null) {
            throw new IllegalStateException("resolveDomainAxisLocation()");
        }
        return result;
    }

    public static RectangleEdge resolveRangeAxisLocation(AxisLocation location, PlotOrientation orientation) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        RectangleEdge result = null;
        if (location == AxisLocation.TOP_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.TOP;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.RIGHT;
            }
        } else if (location == AxisLocation.TOP_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.TOP;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.LEFT;
            }
        } else if (location == AxisLocation.BOTTOM_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.BOTTOM;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.RIGHT;
            }
        } else if (location == AxisLocation.BOTTOM_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.BOTTOM;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.LEFT;
            }
        }
        if (result == null) {
            throw new IllegalStateException("resolveRangeAxisLocation()");
        }
        return result;
    }
}

