/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.plot;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.droidsolutions.droidcharts.awt.Arc2D;
import net.droidsolutions.droidcharts.awt.CubicCurve2D;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.QuadCurve2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.RectangularShape;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.common.Rotation;
import net.droidsolutions.droidcharts.common.ShapeUtilities;
import net.droidsolutions.droidcharts.common.TextAnchor;
import net.droidsolutions.droidcharts.common.UnitType;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.PaintMap;
import net.droidsolutions.droidcharts.core.StrokeMap;
import net.droidsolutions.droidcharts.core.data.DefaultKeyedValues;
import net.droidsolutions.droidcharts.core.data.KeyedValues;
import net.droidsolutions.droidcharts.core.data.PieDataset;
import net.droidsolutions.droidcharts.core.data.general.DatasetUtilities;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.entity.PieSectionEntity;
import net.droidsolutions.droidcharts.core.label.PieSectionLabelGenerator;
import net.droidsolutions.droidcharts.core.label.StandardPieSectionLabelGenerator;
import net.droidsolutions.droidcharts.core.plot.AbstractPieLabelDistributor;
import net.droidsolutions.droidcharts.core.plot.DrawingSupplier;
import net.droidsolutions.droidcharts.core.plot.PieLabelDistributor;
import net.droidsolutions.droidcharts.core.plot.PieLabelLinkStyle;
import net.droidsolutions.droidcharts.core.plot.PieLabelRecord;
import net.droidsolutions.droidcharts.core.plot.PiePlotState;
import net.droidsolutions.droidcharts.core.plot.Plot;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.PlotState;
import net.droidsolutions.droidcharts.core.text.G2TextMeasurer;
import net.droidsolutions.droidcharts.core.text.TextBlock;
import net.droidsolutions.droidcharts.core.text.TextBox;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public class PiePlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -795612466005590431L;
    public static final double DEFAULT_INTERIOR_GAP = 0.08;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = new Paint(1);
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT;
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT;
    public static final float DEFAULT_LABEL_OUTLINE_STROKE = 0.5f;
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT;
    public static final Paint DEFAULT_SHADOW_PAINT;
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private PaintMap sectionPaintMap;
    private transient Paint baseSectionPaint;
    private boolean autoPopulateSectionPaint;
    private boolean sectionOutlinesVisible;
    private PaintMap sectionOutlinePaintMap;
    private transient Paint baseSectionOutlinePaint;
    private boolean autoPopulateSectionOutlinePaint;
    private StrokeMap sectionOutlineStrokeMap;
    private transient float baseSectionOutlineStroke;
    private boolean autoPopulateSectionOutlineStroke;
    private transient Paint shadowPaint = null;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private Map explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private transient Paint labelOutlinePaint;
    private transient Float labelOutlineStroke;
    private transient Paint labelShadowPaint;
    private boolean simpleLabels = true;
    private RectangleInsets labelPadding;
    private RectangleInsets simpleLabelOffset;
    private double maximumLabelWidth = 0.14;
    private double labelGap = 0.025;
    private boolean labelLinksVisible;
    private PieLabelLinkStyle labelLinkStyle = PieLabelLinkStyle.STANDARD;
    private double labelLinkMargin = 0.025;
    private transient Paint labelLinkPaint = DEFAULT_LABEL_PAINT;
    private transient float labelLinkStroke = 2.0f;
    private AbstractPieLabelDistributor labelDistributor;
    private PieSectionLabelGenerator legendLabelGenerator;
    private PieSectionLabelGenerator legendLabelToolTipGenerator;
    private boolean ignoreNullValues;
    private boolean ignoreZeroValues;
    private transient Shape legendItemShape;
    private double minimumArcAngleToDraw;
    static final boolean DEBUG_DRAW_INTERIOR = false;
    static final boolean DEBUG_DRAW_LINK_AREA = false;
    static final boolean DEBUG_DRAW_PIE_AREA = false;
    private transient Paint sectionPaint;
    private transient Paint sectionOutlinePaint;
    private transient Float sectionOutlineStroke;

    static {
        DEFAULT_LABEL_PAINT.setColor(-16777216);
        DEFAULT_LABEL_BACKGROUND_PAINT = new Paint(1);
        DEFAULT_LABEL_BACKGROUND_PAINT.setColor(-12303292);
        DEFAULT_LABEL_OUTLINE_PAINT = new Paint(1);
        DEFAULT_LABEL_OUTLINE_PAINT.setColor(-16777216);
        DEFAULT_LABEL_SHADOW_PAINT = new Paint(1);
        DEFAULT_LABEL_SHADOW_PAINT.setColor(-3355444);
        DEFAULT_SHADOW_PAINT = new Paint(1);
        DEFAULT_SHADOW_PAINT.setColor(-3355444);
    }

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset dataset) {
        this.dataset = dataset;
        this.pieIndex = 0;
        this.interiorGap = 0.08;
        this.circular = true;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintMap = new PaintMap();
        Paint gray = new Paint(1);
        gray.setColor(-7829368);
        this.baseSectionPaint = gray;
        this.autoPopulateSectionPaint = true;
        this.sectionOutlinesVisible = true;
        this.sectionOutlinePaint = null;
        this.sectionOutlinePaintMap = new PaintMap();
        this.baseSectionOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.autoPopulateSectionOutlinePaint = false;
        this.sectionOutlineStrokeMap = new StrokeMap();
        this.baseSectionOutlineStroke = 0.5f;
        this.autoPopulateSectionOutlineStroke = false;
        this.explodePercentages = new TreeMap();
        this.labelGenerator = new StandardPieSectionLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelBackgroundPaint = DEFAULT_LABEL_BACKGROUND_PAINT;
        this.labelOutlinePaint = DEFAULT_LABEL_OUTLINE_PAINT;
        this.labelOutlineStroke = Float.valueOf(0.5f);
        this.labelShadowPaint = DEFAULT_LABEL_SHADOW_PAINT;
        this.labelLinksVisible = true;
        this.labelDistributor = new PieLabelDistributor(0);
        this.simpleLabels = false;
        this.simpleLabelOffset = new RectangleInsets(UnitType.RELATIVE, 0.18, 0.18, 0.18, 0.18);
        this.labelPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        this.legendLabelGenerator = new StandardPieSectionLabelGenerator();
        this.legendLabelToolTipGenerator = null;
        this.legendItemShape = Plot.DEFAULT_LEGEND_ITEM_CIRCLE;
        this.ignoreNullValues = false;
        this.ignoreZeroValues = false;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset dataset) {
        PieDataset existing = this.dataset;
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
        }
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int index) {
        this.pieIndex = index;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = direction;
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double percent) {
        if (percent < 0.0 || percent > 0.4) {
            throw new IllegalArgumentException("Invalid 'percent' (" + percent + ") argument.");
        }
        if (this.interiorGap != percent) {
            this.interiorGap = percent;
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean flag) {
        this.setCircular(flag, true);
    }

    public void setCircular(boolean circular, boolean notify) {
        this.circular = circular;
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean flag) {
        this.ignoreNullValues = flag;
    }

    public boolean getIgnoreZeroValues() {
        return this.ignoreZeroValues;
    }

    public void setIgnoreZeroValues(boolean flag) {
        this.ignoreZeroValues = flag;
    }

    protected Paint lookupSectionPaint(Comparable key) {
        return this.lookupSectionPaint(key, this.getAutoPopulateSectionPaint());
    }

    protected Paint lookupSectionPaint(Comparable key, boolean autoPopulate) {
        Paint result = this.getSectionPaint();
        if (result != null) {
            return result;
        }
        result = this.sectionPaintMap.getPaint(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = ds.getNextPaint();
                this.sectionPaintMap.put(key, result);
            } else {
                result = this.baseSectionPaint;
            }
        } else {
            result = this.baseSectionPaint;
        }
        return result;
    }

    public Paint getSectionPaint() {
        return this.sectionPaint;
    }

    public void setSectionPaint(Paint paint) {
        this.sectionPaint = paint;
    }

    protected Comparable getSectionKey(int section) {
        Comparable<Integer> key = null;
        if (this.dataset != null && section >= 0 && section < this.dataset.getItemCount()) {
            key = this.dataset.getKey(section);
        }
        if (key == null) {
            key = new Integer(section);
        }
        return key;
    }

    public Paint getSectionPaint(Comparable key) {
        return this.sectionPaintMap.getPaint(key);
    }

    public void setSectionPaint(Comparable key, Paint paint) {
        this.sectionPaintMap.put(key, paint);
    }

    public void clearSectionPaints(boolean notify) {
        this.sectionPaintMap.clear();
    }

    public Paint getBaseSectionPaint() {
        return this.baseSectionPaint;
    }

    public void setBaseSectionPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionPaint = paint;
    }

    public boolean getAutoPopulateSectionPaint() {
        return this.autoPopulateSectionPaint;
    }

    public void setAutoPopulateSectionPaint(boolean auto) {
        this.autoPopulateSectionPaint = auto;
    }

    public boolean getSectionOutlinesVisible() {
        return this.sectionOutlinesVisible;
    }

    public void setSectionOutlinesVisible(boolean visible) {
        this.sectionOutlinesVisible = visible;
    }

    protected Paint lookupSectionOutlinePaint(Comparable key) {
        return this.lookupSectionOutlinePaint(key, this.getAutoPopulateSectionOutlinePaint());
    }

    protected Paint lookupSectionOutlinePaint(Comparable key, boolean autoPopulate) {
        Paint result = this.getSectionOutlinePaint();
        if (result != null) {
            return result;
        }
        result = this.sectionOutlinePaintMap.getPaint(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = ds.getNextOutlinePaint();
                this.sectionOutlinePaintMap.put(key, result);
            } else {
                result = this.baseSectionOutlinePaint;
            }
        } else {
            result = this.baseSectionOutlinePaint;
        }
        return result;
    }

    public Paint getSectionOutlinePaint(Comparable key) {
        return this.sectionOutlinePaintMap.getPaint(key);
    }

    public void setSectionOutlinePaint(Comparable key, Paint paint) {
        this.sectionOutlinePaintMap.put(key, paint);
    }

    public void clearSectionOutlinePaints(boolean notify) {
        this.sectionOutlinePaintMap.clear();
    }

    public Paint getBaseSectionOutlinePaint() {
        return this.baseSectionOutlinePaint;
    }

    public void setBaseSectionOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionOutlinePaint = paint;
    }

    public boolean getAutoPopulateSectionOutlinePaint() {
        return this.autoPopulateSectionOutlinePaint;
    }

    public void setAutoPopulateSectionOutlinePaint(boolean auto) {
        this.autoPopulateSectionOutlinePaint = auto;
    }

    protected Float lookupSectionOutlineStroke(Comparable key) {
        return this.lookupSectionOutlineStroke(key, this.getAutoPopulateSectionOutlineStroke());
    }

    protected Float lookupSectionOutlineStroke(Comparable key, boolean autoPopulate) {
        Float result = this.getSectionOutlineStroke();
        if (result != null) {
            return result;
        }
        result = this.sectionOutlineStrokeMap.getStroke(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = Float.valueOf(ds.getNextOutlineStroke());
                this.sectionOutlineStrokeMap.put(key, result);
            } else {
                result = Float.valueOf(this.baseSectionOutlineStroke);
            }
        } else {
            result = Float.valueOf(this.baseSectionOutlineStroke);
        }
        return result;
    }

    public Float getSectionOutlineStroke(Comparable key) {
        return this.sectionOutlineStrokeMap.getStroke(key);
    }

    public void setSectionOutlineStroke(Comparable key, Float stroke) {
        this.sectionOutlineStrokeMap.put(key, stroke);
    }

    public void clearSectionOutlineStrokes(boolean notify) {
        this.sectionOutlineStrokeMap.clear();
    }

    public Float getBaseSectionOutlineStroke() {
        return Float.valueOf(this.baseSectionOutlineStroke);
    }

    public void setBaseSectionOutlineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSectionOutlineStroke = stroke.floatValue();
    }

    public boolean getAutoPopulateSectionOutlineStroke() {
        return this.autoPopulateSectionOutlineStroke;
    }

    public void setAutoPopulateSectionOutlineStroke(boolean auto) {
        this.autoPopulateSectionOutlineStroke = auto;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public double getExplodePercent(Comparable key) {
        Number percent;
        double result = 0.0;
        if (this.explodePercentages != null && (percent = (Number)this.explodePercentages.get(key)) != null) {
            result = percent.doubleValue();
        }
        return result;
    }

    public void setExplodePercent(Comparable key, double percent) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (this.explodePercentages == null) {
            this.explodePercentages = new TreeMap();
        }
        this.explodePercentages.put(key, new Double(percent));
    }

    public double getMaximumExplodePercent() {
        if (this.dataset == null) {
            return 0.0;
        }
        double result = 0.0;
        for (Comparable key : this.dataset.getKeys()) {
            Number explode = (Number)this.explodePercentages.get(key);
            if (explode == null) continue;
            result = Math.max(result, explode.doubleValue());
        }
        return result;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator generator) {
        this.labelGenerator = generator;
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double gap) {
        this.labelGap = gap;
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double width) {
        this.maximumLabelWidth = width;
    }

    public boolean getLabelLinksVisible() {
        return this.labelLinksVisible;
    }

    public void setLabelLinksVisible(boolean visible) {
        this.labelLinksVisible = visible;
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("Null 'style' argument.");
        }
        this.labelLinkStyle = style;
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double margin) {
        this.labelLinkMargin = margin;
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaint = paint;
    }

    public Float getLabelLinkStroke() {
        return Float.valueOf(this.labelLinkStroke);
    }

    public void setLabelLinkStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.labelLinkStroke = stroke.floatValue();
    }

    protected double getLabelLinkDepth() {
        return 0.1;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        this.labelBackgroundPaint = paint;
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        this.labelOutlinePaint = paint;
    }

    public Float getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Float stroke) {
        this.labelOutlineStroke = stroke;
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
    }

    public RectangleInsets getLabelPadding() {
        return this.labelPadding;
    }

    public void setLabelPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.labelPadding = padding;
    }

    public boolean getSimpleLabels() {
        return this.simpleLabels;
    }

    public void setSimpleLabels(boolean simple) {
        this.simpleLabels = simple;
    }

    public RectangleInsets getSimpleLabelOffset() {
        return this.simpleLabelOffset;
    }

    public void setSimpleLabelOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.simpleLabelOffset = offset;
    }

    public AbstractPieLabelDistributor getLabelDistributor() {
        return this.labelDistributor;
    }

    public void setLabelDistributor(AbstractPieLabelDistributor distributor) {
        if (distributor == null) {
            throw new IllegalArgumentException("Null 'distributor' argument.");
        }
        this.labelDistributor = distributor;
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double angle) {
        this.minimumArcAngleToDraw = angle;
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
    }

    public PieSectionLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(PieSectionLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendLabelGenerator = generator;
    }

    public PieSectionLabelGenerator getLegendLabelToolTipGenerator() {
        return this.legendLabelToolTipGenerator;
    }

    public void setLegendLabelToolTipGenerator(PieSectionLabelGenerator generator) {
        this.legendLabelToolTipGenerator = generator;
    }

    public PiePlotState initialise(Canvas g2, Rectangle2D plotArea, PiePlot plot, Integer index, PlotRenderingInfo info) {
        PiePlotState state = new PiePlotState(info);
        state.setPassesRequired(2);
        if (this.dataset != null) {
            state.setTotal(DatasetUtilities.calculatePieDatasetTotal(plot.getDataset()));
        }
        state.setLatestAngle(plot.getStartAngle());
        return state;
    }

    @Override
    public void draw(Canvas g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.drawBackground(g2, area);
        this.drawOutline(g2, area);
        g2.save();
        g2.clipRect((float)area.getMinX(), (float)area.getMinY(), (float)area.getMaxX(), (float)area.getMaxY());
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawPie(g2, area, info, this.getForegroundAlpha());
        } else {
            this.drawNoDataMessage(g2, area);
        }
        g2.restore();
        this.drawOutline(g2, area);
    }

    protected void drawPie(Canvas g2, Rectangle2D plotArea, PlotRenderingInfo info, int alpha) {
        PiePlotState state = this.initialise(g2, plotArea, this, null, info);
        double labelReserve = 0.0;
        if (this.labelGenerator != null && !this.simpleLabels) {
            labelReserve = this.labelGap + this.maximumLabelWidth;
        }
        double gapHorizontal = plotArea.getWidth() * (this.interiorGap + labelReserve) * 2.0;
        double gapVertical = plotArea.getHeight() * this.interiorGap * 2.0;
        double linkX = plotArea.getX() + gapHorizontal / 2.0;
        double linkY = plotArea.getY() + gapVertical / 2.0;
        double linkW = plotArea.getWidth() - gapHorizontal;
        double linkH = plotArea.getHeight() - gapVertical;
        if (this.circular) {
            double min = Math.min(linkW, linkH) / 2.0;
            linkX = (linkX + linkX + linkW) / 2.0 - min;
            linkY = (linkY + linkY + linkH) / 2.0 - min;
            linkW = 2.0 * min;
            linkH = 2.0 * min;
        }
        Rectangle2D.Double linkArea = new Rectangle2D.Double(linkX, linkY, linkW, linkH);
        state.setLinkArea(linkArea);
        double lm = 0.0;
        if (!this.simpleLabels) {
            lm = this.labelLinkMargin;
        }
        double hh = ((RectangularShape)linkArea).getWidth() * lm * 2.0;
        double vv = ((RectangularShape)linkArea).getHeight() * lm * 2.0;
        Rectangle2D.Double explodeArea = new Rectangle2D.Double(linkX + hh / 2.0, linkY + vv / 2.0, linkW - hh, linkH - vv);
        state.setExplodedPieArea(explodeArea);
        double maximumExplodePercent = this.getMaximumExplodePercent();
        double percent = maximumExplodePercent / (1.0 + maximumExplodePercent);
        double h1 = ((RectangularShape)explodeArea).getWidth() * percent;
        double v1 = ((RectangularShape)explodeArea).getHeight() * percent;
        Rectangle2D.Double pieArea = new Rectangle2D.Double(((RectangularShape)explodeArea).getX() + h1 / 2.0, ((RectangularShape)explodeArea).getY() + v1 / 2.0, ((RectangularShape)explodeArea).getWidth() - h1, ((RectangularShape)explodeArea).getHeight() - v1);
        state.setPieArea(pieArea);
        state.setPieCenterX(pieArea.getCenterX());
        state.setPieCenterY(pieArea.getCenterY());
        state.setPieWRadius(((RectangularShape)pieArea).getWidth() / 2.0);
        state.setPieHRadius(((RectangularShape)pieArea).getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List keys = this.dataset.getKeys();
            double totalValue = DatasetUtilities.calculatePieDatasetTotal(this.dataset);
            int passesRequired = state.getPassesRequired();
            int pass = 0;
            while (pass < passesRequired) {
                double runningTotal = 0.0;
                int section = 0;
                while (section < keys.size()) {
                    double value;
                    Number n = this.dataset.getValue(section);
                    if (n != null && (value = n.doubleValue()) > 0.0) {
                        runningTotal += value;
                        this.drawItem(g2, section, explodeArea, state, pass, alpha);
                    }
                    ++section;
                }
                ++pass;
            }
            if (this.simpleLabels) {
                this.drawSimpleLabels(g2, keys, totalValue, plotArea, linkArea, state, alpha);
            } else {
                this.drawLabels(g2, keys, totalValue, plotArea, linkArea, state, alpha);
            }
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
    }

    protected void drawItem(Canvas g2, int section, Rectangle2D dataArea, PiePlotState state, int currentPass, int alpha) {
        Number n = this.dataset.getValue(section);
        if (n == null) {
            return;
        }
        double value = n.doubleValue();
        double angle1 = 0.0;
        double angle2 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 - value / state.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 + value / state.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double angle = angle2 - angle1;
        if (Math.abs(angle) > this.getMinimumArcAngleToDraw()) {
            double ep = 0.0;
            double mep = this.getMaximumExplodePercent();
            if (mep > 0.0) {
                ep = this.getExplodePercent(section) / mep;
            }
            Rectangle2D arcBounds = this.getArcBounds(state.getPieArea(), state.getExplodedPieArea(), angle1, angle, ep);
            RectF arcBoundsRect = new RectF((float)arcBounds.getMinX(), (float)arcBounds.getMinY(), (float)arcBounds.getMaxX(), (float)arcBounds.getMaxY());
            Arc2D.Double arc = new Arc2D.Double(arcBounds, angle1, angle, 2);
            if (currentPass == 0) {
                if (this.shadowPaint != null) {
                    this.shadowPaint.setAlpha(alpha);
                    this.shadowPaint.setStyle(Paint.Style.FILL);
                    Shape shadowArc = ShapeUtilities.createTranslatedShape(arc, (float)this.shadowXOffset, (float)this.shadowYOffset);
                    Rectangle2D shadowBounds = shadowArc.getBounds2D();
                    RectF sharcBoundsRect = new RectF((float)shadowBounds.getMinX(), (float)shadowBounds.getMinY(), (float)shadowBounds.getMaxX(), (float)shadowBounds.getMaxY());
                    g2.drawArc(sharcBoundsRect, (float)angle1, (float)angle, true, this.shadowPaint);
                }
            } else if (currentPass == 1) {
                EntityCollection entities;
                Comparable key = this.getSectionKey(section);
                Paint paint = this.lookupSectionPaint(key);
                paint.setAlpha(alpha);
                paint.setStyle(Paint.Style.FILL);
                g2.drawArc(arcBoundsRect, (float)angle1, (float)angle, true, paint);
                Paint outlinePaint = this.lookupSectionOutlinePaint(key);
                Float outlineStroke = this.lookupSectionOutlineStroke(key);
                if (this.sectionOutlinesVisible) {
                    outlinePaint.setAlpha(alpha);
                    outlinePaint.setStyle(Paint.Style.STROKE);
                    outlinePaint.setStrokeWidth(outlineStroke.floatValue());
                    outlinePaint.setStrokeMiter(90.0f);
                    outlinePaint.setStrokeJoin(Paint.Join.MITER);
                    g2.drawArc(arcBoundsRect, (float)arc.getAngleStart(), (float)arc.getAngleExtent(), true, outlinePaint);
                }
                if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
                    String tip = null;
                    String url = null;
                    PieSectionEntity entity = new PieSectionEntity(arc, this.dataset, this.pieIndex, section, key, tip, url);
                    entities.add(entity);
                }
            }
        }
        state.setLatestAngle(angle2);
    }

    protected void drawSimpleLabels(Canvas g2, List keys, double totalValue, Rectangle2D plotArea, Rectangle2D pieArea, PiePlotState state, int alpha) {
        int oldAlpha = this.labelPaint.getAlpha();
        RectangleInsets labelInsets = new RectangleInsets(UnitType.RELATIVE, 0.18, 0.18, 0.18, 0.18);
        Rectangle2D labelsArea = labelInsets.createInsetRectangle(pieArea);
        double runningTotal = 0.0;
        for (Comparable key : keys) {
            Rectangle2D b;
            String label;
            boolean include = true;
            double v = 0.0;
            Number n = this.getDataset().getValue(key);
            if (n == null) {
                include = !this.getIgnoreNullValues();
            } else {
                v = n.doubleValue();
                boolean bl = this.getIgnoreZeroValues() ? v > 0.0 : (include = v >= 0.0);
            }
            if (!include) continue;
            double mid = this.getStartAngle() + this.getDirection().getFactor() * (((runningTotal += v) - v / 2.0) * 360.0) / totalValue;
            Arc2D.Double arc = new Arc2D.Double(labelsArea, this.getStartAngle(), mid - this.getStartAngle(), 0);
            int x = (int)arc.getEndPoint().getX();
            int y = (int)arc.getEndPoint().getY();
            PieSectionLabelGenerator labelGenerator = this.getLabelGenerator();
            if (labelGenerator == null || (label = labelGenerator.generateSectionLabel(this.dataset, key)) == null) continue;
            this.labelPaint.setTypeface(this.labelFont.getTypeFace());
            this.labelPaint.setTextSize((float)this.labelFont.getSize());
            this.labelPaint.setAlpha(255);
            Rectangle2D bounds = TextUtilities.getTextBounds(label, this.labelPaint);
            Rectangle2D out = this.labelPadding.createOutsetRectangle(bounds);
            Shape bg = ShapeUtilities.createTranslatedShape(out, (double)x - bounds.getCenterX(), (double)y - bounds.getCenterY());
            if (this.labelShadowPaint != null) {
                Shape shadow = ShapeUtilities.createTranslatedShape(bg, this.shadowXOffset, this.shadowYOffset);
                this.labelShadowPaint.setStyle(Paint.Style.FILL);
                Rectangle2D b2 = shadow.getBounds2D();
                g2.drawRect((float)b2.getMinX(), (float)b2.getMinY(), (float)b2.getMaxX(), (float)b2.getMaxY(), this.labelShadowPaint);
            }
            if (this.labelBackgroundPaint != null) {
                this.labelBackgroundPaint.setStyle(Paint.Style.FILL);
                b = bg.getBounds2D();
                g2.drawRect((float)b.getMinX(), (float)b.getMinY(), (float)b.getMaxX(), (float)b.getMaxY(), this.labelBackgroundPaint);
            }
            if (this.labelOutlinePaint != null && this.labelOutlineStroke != null) {
                this.labelOutlinePaint.setStyle(Paint.Style.STROKE);
                this.labelOutlinePaint.setStrokeWidth(this.labelOutlineStroke.floatValue());
                b = bg.getBounds2D();
                g2.drawRect((float)b.getMinX(), (float)b.getMinY(), (float)b.getMaxX(), (float)b.getMaxY(), this.labelOutlinePaint);
            }
            this.labelPaint.setTypeface(this.labelFont.getTypeFace());
            this.labelPaint.setTextSize((float)this.labelFont.getSize());
            TextUtilities.drawAlignedString(this.getLabelGenerator().generateSectionLabel(this.getDataset(), key), g2, x, y, TextAnchor.CENTER, this.labelPaint);
        }
        this.labelPaint.setAlpha(oldAlpha);
    }

    protected void drawLabels(Canvas g2, List keys, double totalValue, Rectangle2D plotArea, Rectangle2D linkArea, PiePlotState state, int alphaa) {
        DefaultKeyedValues leftKeys = new DefaultKeyedValues();
        DefaultKeyedValues rightKeys = new DefaultKeyedValues();
        double runningTotal = 0.0;
        for (Comparable key : keys) {
            boolean include = true;
            double v = 0.0;
            Number n = this.dataset.getValue(key);
            if (n == null) {
                include = !this.ignoreNullValues;
            } else {
                v = n.doubleValue();
                boolean bl = this.ignoreZeroValues ? v > 0.0 : (include = v >= 0.0);
            }
            if (!include) continue;
            runningTotal += v;
            double mid = this.startAngle + this.direction.getFactor() * ((runningTotal - v / 2.0) * 360.0) / totalValue;
            if (Math.cos(Math.toRadians(mid)) < 0.0) {
                leftKeys.addValue(key, new Double(mid));
                continue;
            }
            rightKeys.addValue(key, new Double(mid));
        }
        Paint labelpaint = this.getLabelPaint();
        int alpha = labelpaint.getAlpha();
        labelpaint.setTypeface(this.getLabelFont().getTypeFace());
        labelpaint.setTextSize((float)this.getLabelFont().getSize());
        labelpaint.setAlpha(255);
        double marginX = plotArea.getX() + this.interiorGap * plotArea.getWidth();
        double gap = plotArea.getWidth() * this.labelGap;
        double ww = linkArea.getX() - gap - marginX;
        float labelWidth = (float)this.labelPadding.trimWidth(ww);
        if (this.labelGenerator != null) {
            this.drawLeftLabels(leftKeys, g2, plotArea, linkArea, labelWidth, state);
            this.drawRightLabels(rightKeys, g2, plotArea, linkArea, labelWidth, state);
        }
        labelpaint.setAlpha(alpha);
    }

    protected void drawLeftLabels(KeyedValues leftKeys, Canvas g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        this.labelDistributor.clear();
        double lGap = plotArea.getWidth() * this.labelGap;
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        int i = 0;
        while (i < leftKeys.getItemCount()) {
            String label = this.labelGenerator.generateSectionLabel(this.dataset, leftKeys.getKey(i));
            if (label != null) {
                TextBlock block = TextUtilities.createTextBlock(label, this.labelFont, this.labelPaint, maxLabelWidth, new G2TextMeasurer(this.labelPaint));
                TextBox labelBox = new TextBox(block);
                labelBox.setBackgroundPaint(this.labelBackgroundPaint);
                labelBox.setOutlinePaint(this.labelOutlinePaint);
                labelBox.setOutlineStroke(this.labelOutlineStroke);
                labelBox.setShadowPaint(this.labelShadowPaint);
                labelBox.setInteriorGap(this.labelPadding);
                double theta = Math.toRadians(leftKeys.getValue(i).doubleValue());
                double baseY = state.getPieCenterY() + Math.sin(theta) * verticalLinkRadius;
                double hh = labelBox.getHeight(g2);
                this.labelDistributor.addPieLabelRecord(new PieLabelRecord(leftKeys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * -Math.cos(theta), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(leftKeys.getKey(i))));
            }
            ++i;
        }
        double hh = plotArea.getHeight();
        double gap = hh * this.getInteriorGap();
        this.labelDistributor.distributeLabels(plotArea.getMinY() + gap, hh - 2.0 * gap);
        int i2 = 0;
        while (i2 < this.labelDistributor.getItemCount()) {
            this.drawLeftLabel(g2, state, this.labelDistributor.getPieLabelRecord(i2));
            ++i2;
        }
    }

    protected void drawRightLabels(KeyedValues keys, Canvas g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        this.labelDistributor.clear();
        double lGap = plotArea.getWidth() * this.labelGap;
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        int i = 0;
        while (i < keys.getItemCount()) {
            String label = this.labelGenerator.generateSectionLabel(this.dataset, keys.getKey(i));
            if (label != null) {
                this.labelPaint.setTypeface(this.labelFont.getTypeFace());
                this.labelPaint.setTextSize((float)this.labelFont.getSize());
                TextBlock block = TextUtilities.createTextBlock(label, this.labelFont, this.labelPaint, maxLabelWidth, new G2TextMeasurer(this.labelPaint));
                TextBox labelBox = new TextBox(block);
                labelBox.setBackgroundPaint(this.labelBackgroundPaint);
                labelBox.setOutlinePaint(this.labelOutlinePaint);
                labelBox.setOutlineStroke(this.labelOutlineStroke);
                labelBox.setShadowPaint(this.labelShadowPaint);
                labelBox.setInteriorGap(this.labelPadding);
                double theta = Math.toRadians(keys.getValue(i).doubleValue());
                double baseY = state.getPieCenterY() + Math.sin(theta) * verticalLinkRadius;
                double hh = labelBox.getHeight(g2);
                this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * Math.cos(theta), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keys.getKey(i))));
            }
            ++i;
        }
        double hh = plotArea.getHeight();
        double gap = hh * this.getInteriorGap();
        this.labelDistributor.distributeLabels(plotArea.getMinY() + gap, hh - 2.0 * gap);
        int i2 = 0;
        while (i2 < this.labelDistributor.getItemCount()) {
            this.drawRightLabel(g2, state, this.labelDistributor.getPieLabelRecord(i2));
            ++i2;
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.dataset == null) {
            return result;
        }
        List keys = this.dataset.getKeys();
        int section = 0;
        Shape shape = this.getLegendItemShape();
        for (Comparable key : keys) {
            Number n = this.dataset.getValue(key);
            boolean include = true;
            if (n == null) {
                include = !this.ignoreNullValues;
            } else {
                double v = n.doubleValue();
                if (v == 0.0) {
                    include = !this.ignoreZeroValues;
                } else {
                    boolean bl = include = v > 0.0;
                }
            }
            if (include) {
                String label = this.legendLabelGenerator.generateSectionLabel(this.dataset, key);
                if (label != null) {
                    String description = label;
                    String toolTipText = null;
                    if (this.legendLabelToolTipGenerator != null) {
                        toolTipText = this.legendLabelToolTipGenerator.generateSectionLabel(this.dataset, key);
                    }
                    String urlText = null;
                    Paint black = new Paint(1);
                    black.setColor(-16777216);
                    Paint paint = this.lookupSectionPaint(key);
                    Paint outlinePaint = this.lookupSectionOutlinePaint(key);
                    Float outlineStroke = this.lookupSectionOutlineStroke(key);
                    LegendItem item = new LegendItem(label, description, toolTipText, urlText, true, shape, true, paint.getColor(), true, outlinePaint.getColor(), outlineStroke.floatValue(), false, (Shape)new Line2D.Float(), 0.0f, -16777216);
                    item.setDataset(this.getDataset());
                    item.setSeriesIndex(this.dataset.getIndex(key));
                    item.setSeriesKey(key);
                    result.add(item);
                }
                ++section;
                continue;
            }
            ++section;
        }
        return result;
    }

    @Override
    public String getPlotType() {
        return "Pie_Plot";
    }

    protected Rectangle2D getArcBounds(Rectangle2D unexploded, Rectangle2D exploded, double angle, double extent, double explodePercent) {
        if (explodePercent == 0.0) {
            return unexploded;
        }
        Arc2D.Double arc1 = new Arc2D.Double(unexploded, angle, extent / 2.0, 0);
        Point2D point1 = arc1.getEndPoint();
        Arc2D.Double arc2 = new Arc2D.Double(exploded, angle, extent / 2.0, 0);
        Point2D point2 = arc2.getEndPoint();
        double deltaX = (point1.getX() - point2.getX()) * explodePercent;
        double deltaY = (point1.getY() - point2.getY()) * explodePercent;
        return new Rectangle2D.Double(unexploded.getX() - deltaX, unexploded.getY() - deltaY, unexploded.getWidth(), unexploded.getHeight());
    }

    protected void drawLeftLabel(Canvas g2, PiePlotState state, PieLabelRecord record) {
        double anchorX = state.getLinkArea().getMinX();
        double targetX = anchorX - record.getGap();
        double targetY = record.getAllocatedY();
        if (this.labelLinksVisible) {
            double elbowY;
            double theta = record.getAngle();
            double linkX = state.getPieCenterX() + Math.cos(theta) * state.getPieWRadius() * record.getLinkPercent();
            double linkY = state.getPieCenterY() + Math.sin(theta) * state.getPieHRadius() * record.getLinkPercent();
            double elbowX = state.getPieCenterX() + Math.cos(theta) * state.getLinkArea().getWidth() / 2.0;
            double anchorY = elbowY = state.getPieCenterY() + Math.sin(theta) * state.getLinkArea().getHeight() / 2.0;
            this.labelLinkPaint.setStyle(Paint.Style.STROKE);
            this.labelLinkPaint.setStrokeWidth(this.labelLinkStroke);
            PieLabelLinkStyle style = this.getLabelLinkStyle();
            if (style.equals(PieLabelLinkStyle.STANDARD)) {
                g2.drawLine((float)linkX, (float)linkY, (float)elbowX, (float)elbowY, this.labelLinkPaint);
                g2.drawLine((float)anchorX, (float)anchorY, (float)elbowX, (float)elbowY, this.labelLinkPaint);
                g2.drawLine((float)anchorX, (float)anchorY, (float)targetX, (float)targetY, this.labelLinkPaint);
            } else if (style.equals(PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurve2D.Float q = new QuadCurve2D.Float();
                ((QuadCurve2D)q).setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY);
            } else if (style.equals(PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurve2D.Float c = new CubicCurve2D.Float();
                ((CubicCurve2D)c).setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY, linkX, linkY);
            }
        }
        TextBox tb = record.getLabel();
        tb.draw(g2, (float)targetX, (float)targetY, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Canvas g2, PiePlotState state, PieLabelRecord record) {
        double anchorX = state.getLinkArea().getMaxX();
        double targetX = anchorX + record.getGap();
        double targetY = record.getAllocatedY();
        if (this.labelLinksVisible) {
            double elbowY;
            double theta = record.getAngle();
            double linkX = state.getPieCenterX() + Math.cos(theta) * state.getPieWRadius() * record.getLinkPercent();
            double linkY = state.getPieCenterY() + Math.sin(theta) * state.getPieHRadius() * record.getLinkPercent();
            double elbowX = state.getPieCenterX() + Math.cos(theta) * state.getLinkArea().getWidth() / 2.0;
            double anchorY = elbowY = state.getPieCenterY() + Math.sin(theta) * state.getLinkArea().getHeight() / 2.0;
            this.labelLinkPaint.setStyle(Paint.Style.STROKE);
            this.labelLinkPaint.setStrokeWidth(this.labelLinkStroke);
            PieLabelLinkStyle style = this.getLabelLinkStyle();
            if (style.equals(PieLabelLinkStyle.STANDARD)) {
                g2.drawLine((float)linkX, (float)linkY, (float)elbowX, (float)elbowY, this.labelLinkPaint);
                g2.drawLine((float)anchorX, (float)anchorY, (float)elbowX, (float)elbowY, this.labelLinkPaint);
                g2.drawLine((float)anchorX, (float)anchorY, (float)targetX, (float)targetY, this.labelLinkPaint);
            } else if (style.equals(PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurve2D.Float q = new QuadCurve2D.Float();
                ((QuadCurve2D)q).setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY);
            } else if (style.equals(PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurve2D.Float c = new CubicCurve2D.Float();
                ((CubicCurve2D)c).setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY, linkX, linkY);
            }
        }
        TextBox tb = record.getLabel();
        tb.draw(g2, (float)targetX, (float)targetY, RectangleAnchor.LEFT);
    }

    public Paint getSectionPaint(int section) {
        Comparable key = this.getSectionKey(section);
        return this.getSectionPaint(key);
    }

    public void setSectionPaint(int section, Paint paint) {
        Comparable key = this.getSectionKey(section);
        this.setSectionPaint(key, paint);
    }

    public Paint getSectionOutlinePaint() {
        return this.sectionOutlinePaint;
    }

    public void setSectionOutlinePaint(Paint paint) {
        this.sectionOutlinePaint = paint;
    }

    public Paint getSectionOutlinePaint(int section) {
        Comparable key = this.getSectionKey(section);
        return this.getSectionOutlinePaint(key);
    }

    public void setSectionOutlinePaint(int section, Paint paint) {
        Comparable key = this.getSectionKey(section);
        this.setSectionOutlinePaint(key, paint);
    }

    public Float getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public void setSectionOutlineStroke(Float stroke) {
        this.sectionOutlineStroke = stroke;
    }

    public Float getSectionOutlineStroke(int section) {
        Comparable key = this.getSectionKey(section);
        return this.getSectionOutlineStroke(key);
    }

    public void setSectionOutlineStroke(int section, Float stroke) {
        Comparable key = this.getSectionKey(section);
        this.setSectionOutlineStroke(key, stroke);
    }

    public double getExplodePercent(int section) {
        Comparable key = this.getSectionKey(section);
        return this.getExplodePercent(key);
    }

    public void setExplodePercent(int section, double percent) {
        Comparable key = this.getSectionKey(section);
        this.setExplodePercent(key, percent);
    }
}

