/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.block;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.core.block.BlockFrame;

public class BlockBorder
implements BlockFrame,
Serializable {
    private static final long serialVersionUID = 4961579220410228283L;
    public static final Paint paintWhite = new Paint(1);
    public static final Paint paintBlack;
    public static final BlockBorder NONE;
    private RectangleInsets insets;
    private transient Paint paint;

    static {
        paintWhite.setARGB(0, 256, 256, 256);
        paintBlack = new Paint(1);
        paintBlack.setARGB(0, 0, 0, 0);
        NONE = new BlockBorder(RectangleInsets.ZERO_INSETS, paintWhite);
    }

    public BlockBorder() {
        this(paintBlack);
    }

    public BlockBorder(Paint paint) {
        this(new RectangleInsets(1.0, 1.0, 1.0, 1.0), paint);
    }

    public BlockBorder(double top, double left, double bottom, double right) {
        this(new RectangleInsets(top, left, bottom, right), paintBlack);
    }

    public BlockBorder(double top, double left, double bottom, double right, Paint paint) {
        this(new RectangleInsets(top, left, bottom, right), paint);
    }

    public BlockBorder(RectangleInsets insets, Paint paint) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.insets = insets;
        this.paint = paint;
        this.paint.setStyle(Paint.Style.FILL);
    }

    @Override
    public RectangleInsets getInsets() {
        return this.insets;
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void draw(Canvas g2, Rectangle2D area) {
        double t = this.insets.calculateTopInset(area.getHeight());
        double b = this.insets.calculateBottomInset(area.getHeight());
        double l = this.insets.calculateLeftInset(area.getWidth());
        double r = this.insets.calculateRightInset(area.getWidth());
        double x = area.getX();
        double y = area.getY();
        double w = area.getWidth();
        double h = area.getHeight();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        if (t > 0.0) {
            ((Rectangle2D)rect).setRect(x, y, w, t);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), this.paint);
        }
        if (b > 0.0) {
            ((Rectangle2D)rect).setRect(x, y + h - b, w, b);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), this.paint);
        }
        if (l > 0.0) {
            ((Rectangle2D)rect).setRect(x, y, l, h);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), this.paint);
        }
        if (r > 0.0) {
            ((Rectangle2D)rect).setRect(x + w - r, y, r, h);
            g2.drawRect((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), this.paint);
        }
    }
}

