/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.Drawable;
import net.droidsolutions.droidcharts.common.HorizontalAlignment;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.common.Size2D;
import net.droidsolutions.droidcharts.common.VerticalAlignment;
import net.droidsolutions.droidcharts.core.ChartRenderingInfo;
import net.droidsolutions.droidcharts.core.block.BlockParams;
import net.droidsolutions.droidcharts.core.block.EntityBlockResult;
import net.droidsolutions.droidcharts.core.block.LengthConstraintType;
import net.droidsolutions.droidcharts.core.block.LineBorder;
import net.droidsolutions.droidcharts.core.block.RectangleConstraint;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.event.PlotChangeEvent;
import net.droidsolutions.droidcharts.core.event.PlotChangeListener;
import net.droidsolutions.droidcharts.core.event.TitleChangeEvent;
import net.droidsolutions.droidcharts.core.event.TitleChangeListener;
import net.droidsolutions.droidcharts.core.plot.CategoryPlot;
import net.droidsolutions.droidcharts.core.plot.Plot;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.XYPlot;
import net.droidsolutions.droidcharts.core.title.LegendTitle;
import net.droidsolutions.droidcharts.core.title.TextTitle;
import net.droidsolutions.droidcharts.core.title.Title;

public class JFreeChart
implements Drawable,
TitleChangeListener,
PlotChangeListener,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3470703747817429120L;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 18);
    public static final Paint DEFAULT_BACKGROUND_PAINT = new Paint(1);
    public static final int DEFAULT_BACKGROUND_IMAGE_ALIGNMENT = 15;
    public static final float DEFAULT_BACKGROUND_IMAGE_ALPHA = 0.5f;
    private boolean borderVisible;
    private transient float borderStroke;
    private transient Paint borderPaint;
    private RectangleInsets padding;
    private TextTitle title;
    private List subtitles;
    private Plot plot;
    private transient Paint backgroundPaint;
    private boolean notify;

    static {
        DEFAULT_BACKGROUND_PAINT.setColor(-3355444);
        DEFAULT_BACKGROUND_PAINT.setStyle(Paint.Style.FILL);
    }

    public JFreeChart(String title, Font titleFont, Plot plot, boolean createLegend) {
        if (plot == null) {
            throw new NullPointerException("Null 'plot' argument.");
        }
        this.borderVisible = true;
        this.borderStroke = 2.0f;
        this.borderPaint = new Paint(1);
        this.borderPaint.setColor(-1);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(this.borderStroke);
        this.plot = plot;
        this.subtitles = new ArrayList();
        if (createLegend) {
            LegendTitle legend = new LegendTitle(this.plot);
            legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
            legend.setFrame(new LineBorder());
            Paint paint = new Paint(1);
            paint.setColor(-1);
            legend.setBackgroundPaint(paint);
            legend.setPosition(RectangleEdge.BOTTOM);
            this.subtitles.add(legend);
        }
        if (title != null) {
            if (titleFont == null) {
                titleFont = DEFAULT_TITLE_FONT;
            }
            this.title = new TextTitle(title, titleFont);
        }
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(boolean visible) {
        this.borderVisible = visible;
    }

    public float getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(float stroke) {
        this.borderStroke = stroke;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.padding = padding;
    }

    public TextTitle getTitle() {
        return this.title;
    }

    public void setTitle(TextTitle title) {
        this.title = title;
    }

    public void setTitle(String text) {
        if (text != null) {
            if (this.title == null) {
                this.setTitle(new TextTitle(text, DEFAULT_TITLE_FONT));
            } else {
                this.title.setText(text);
            }
        } else {
            this.setTitle((TextTitle)null);
        }
    }

    public void addLegend(LegendTitle legend) {
        this.addSubtitle(legend);
    }

    public void addSubtitle(Title subtitle) {
        if (subtitle == null) {
            throw new IllegalArgumentException("Null 'subtitle' argument.");
        }
        this.subtitles.add(subtitle);
    }

    public LegendTitle getLegend() {
        return this.getLegend(0);
    }

    public LegendTitle getLegend(int index) {
        int seen = 0;
        for (Title subtitle : this.subtitles) {
            if (!(subtitle instanceof LegendTitle)) continue;
            if (seen == index) {
                return (LegendTitle)subtitle;
            }
            ++seen;
        }
        return null;
    }

    public void removeLegend() {
        this.removeSubtitle(this.getLegend());
    }

    public void removeSubtitle(Title title) {
        this.subtitles.remove(title);
    }

    public List getSubtitles() {
        return new ArrayList(this.subtitles);
    }

    public void setSubtitles(List subtitles) {
        if (subtitles == null) {
            throw new NullPointerException("Null 'subtitles' argument.");
        }
        this.clearSubtitles();
        for (Title t : subtitles) {
            if (t == null) continue;
            this.addSubtitle(t);
        }
    }

    public void clearSubtitles() {
        for (Title title : this.subtitles) {
        }
        this.subtitles.clear();
    }

    public int getSubtitleCount() {
        return this.subtitles.size();
    }

    public Title getSubtitle(int index) {
        if (index < 0 || index >= this.getSubtitleCount()) {
            throw new IllegalArgumentException("Index out of range.");
        }
        return (Title)this.subtitles.get(index);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint != null) {
            if (!this.backgroundPaint.equals(paint)) {
                this.backgroundPaint = paint;
            }
        } else if (paint != null) {
            this.backgroundPaint = paint;
        }
    }

    public void draw(Canvas g2, Rectangle2D area) {
        this.draw(g2, area, null, null);
    }

    public void draw(Canvas g2, Rectangle2D area, ChartRenderingInfo info) {
        this.draw(g2, area, null, info);
    }

    public void draw(Canvas g2, Rectangle2D chartArea, Point2D anchor, ChartRenderingInfo info) {
        EntityCollection e;
        EntityCollection entities = null;
        Rect savedClip = g2.getClipBounds();
        g2.clipRect((float)chartArea.getMinX(), (float)chartArea.getMinY(), (float)chartArea.getMaxX(), (float)chartArea.getMaxY());
        if (this.backgroundPaint != null) {
            g2.drawRect((float)chartArea.getMinX(), (float)chartArea.getMinY(), (float)chartArea.getMaxX(), (float)chartArea.getMaxY(), this.backgroundPaint);
        }
        if (this.isBorderVisible()) {
            Paint paint = this.getBorderPaint();
            float stroke = this.getBorderStroke();
            if (paint != null) {
                Rectangle2D.Double borderArea = new Rectangle2D.Double(chartArea.getX(), chartArea.getY(), chartArea.getWidth() - 1.0, chartArea.getHeight() - 1.0);
                g2.drawRect((float)borderArea.getMinX(), (float)borderArea.getMinY(), (float)borderArea.getMaxX(), (float)borderArea.getMaxY(), this.borderPaint);
            }
        }
        Rectangle2D plotArea = chartArea;
        PlotRenderingInfo plotInfo = null;
        if (info != null) {
            plotInfo = info.getPlotInfo();
        }
        this.plot.draw(g2, plotArea, anchor, null, plotInfo);
        Rectangle2D.Double nonTitleArea = new Rectangle2D.Double();
        ((Rectangle2D)nonTitleArea).setRect(chartArea);
        if (this.padding != null) {
            this.padding.trim(nonTitleArea);
        }
        if (this.title != null && (e = this.drawTitle(this.title, g2, nonTitleArea, entities != null)) != null) {
            entities.addAll(e);
        }
        for (Title currentTitle : this.subtitles) {
            EntityCollection e2;
            if (!currentTitle.isVisible() || (e2 = this.drawTitle(currentTitle, g2, nonTitleArea, entities != null)) == null) continue;
            entities.addAll(e2);
        }
        g2.clipRect(savedClip);
    }

    private Rectangle2D createAlignedRectangle2D(Size2D dimensions, Rectangle2D frame, HorizontalAlignment hAlign, VerticalAlignment vAlign) {
        double x = Double.NaN;
        double y = Double.NaN;
        if (hAlign == HorizontalAlignment.LEFT) {
            x = frame.getX();
        } else if (hAlign == HorizontalAlignment.CENTER) {
            x = frame.getCenterX() - dimensions.width / 2.0;
        } else if (hAlign == HorizontalAlignment.RIGHT) {
            x = frame.getMaxX() - dimensions.width;
        }
        if (vAlign == VerticalAlignment.TOP) {
            y = frame.getY();
        } else if (vAlign == VerticalAlignment.CENTER) {
            y = frame.getCenterY() - dimensions.height / 2.0;
        } else if (vAlign == VerticalAlignment.BOTTOM) {
            y = frame.getMaxY() - dimensions.height;
        }
        return new Rectangle2D.Double(x, y, dimensions.width, dimensions.height);
    }

    protected EntityCollection drawTitle(Title t, Canvas g2, Rectangle2D area, boolean entities) {
        Size2D size;
        if (t == null) {
            throw new IllegalArgumentException("Null 't' argument.");
        }
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        Rectangle2D titleArea = new Rectangle2D.Double();
        RectangleEdge position = t.getPosition();
        double ww = area.getWidth();
        if (ww <= 0.0) {
            return null;
        }
        double hh = area.getHeight();
        if (hh <= 0.0) {
            return null;
        }
        RectangleConstraint constraint = new RectangleConstraint(ww, new Range(0.0, ww), LengthConstraintType.RANGE, hh, new Range(0.0, hh), LengthConstraintType.RANGE);
        Object retValue = null;
        BlockParams p = new BlockParams();
        p.setGenerateEntities(entities);
        if (position == RectangleEdge.TOP) {
            size = t.arrange(g2, constraint);
            titleArea = this.createAlignedRectangle2D(size, area, t.getHorizontalAlignment(), VerticalAlignment.TOP);
            retValue = t.draw(g2, titleArea, p);
            area.setRect(area.getX(), Math.min(area.getY() + size.height, area.getMaxY()), area.getWidth(), Math.max(area.getHeight() - size.height, 0.0));
        } else if (position == RectangleEdge.BOTTOM) {
            size = t.arrange(g2, constraint);
            titleArea = this.createAlignedRectangle2D(size, area, t.getHorizontalAlignment(), VerticalAlignment.BOTTOM);
            retValue = t.draw(g2, titleArea, p);
            area.setRect(area.getX(), area.getY(), area.getWidth(), area.getHeight() - size.height);
        } else if (position == RectangleEdge.RIGHT) {
            size = t.arrange(g2, constraint);
            titleArea = this.createAlignedRectangle2D(size, area, HorizontalAlignment.RIGHT, t.getVerticalAlignment());
            retValue = t.draw(g2, titleArea, p);
            area.setRect(area.getX(), area.getY(), area.getWidth() - size.width, area.getHeight());
        } else if (position == RectangleEdge.LEFT) {
            size = t.arrange(g2, constraint);
            titleArea = this.createAlignedRectangle2D(size, area, HorizontalAlignment.LEFT, t.getVerticalAlignment());
            retValue = t.draw(g2, titleArea, p);
            area.setRect(area.getX() + size.width, area.getY(), area.getWidth() - size.width, area.getHeight());
        } else {
            throw new RuntimeException("Unrecognised title position.");
        }
        EntityCollection result = null;
        if (retValue instanceof EntityBlockResult) {
            EntityBlockResult ebr = (EntityBlockResult)retValue;
            result = ebr.getEntityCollection();
        }
        return result;
    }

    @Override
    public void draw(Canvas g2, Rectangle area) {
        this.draw(g2, area);
    }

    @Override
    public void titleChanged(TitleChangeEvent event) {
    }

    @Override
    public void plotChanged(PlotChangeEvent event) {
    }
}

