/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.common;

import net.droidsolutions.droidcharts.awt.AffineTransform;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.RectangleAnchor;

public class ShapeUtilities {
    private ShapeUtilities() {
    }

    public static Shape createTranslatedShape(Shape shape, double transX, double transY) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(transX, transY);
        return transform.createTransformedShape(shape);
    }

    public static Shape createTranslatedShape(Shape shape, RectangleAnchor anchor, double locationX, double locationY) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        Point2D anchorPoint = RectangleAnchor.coordinates(shape.getBounds2D(), anchor);
        AffineTransform transform = AffineTransform.getTranslateInstance(locationX - anchorPoint.getX(), locationY - anchorPoint.getY());
        return transform.createTransformedShape(shape);
    }

    public static Shape rotateShape(Shape base, double angle, float x, float y) {
        if (base == null) {
            return null;
        }
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, x, y);
        Shape result = rotate.createTransformedShape(base);
        return result;
    }

    public static Point2D getPointInRectangle(double x, double y, Rectangle2D area) {
        x = Math.max(area.getMinX(), Math.min(x, area.getMaxX()));
        y = Math.max(area.getMinY(), Math.min(y, area.getMaxY()));
        return new Point2D.Double(x, y);
    }
}

