/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.RectF;
import com.androidplot.util.ValPixConverter;
import com.androidplot.xy.XYAxisType;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYStep;
import com.androidplot.xy.XYStepMode;

public class XYStepCalculator {
    public static XYStep getStep(XYPlot xYPlot, XYAxisType xYAxisType, RectF rectF, Number number, Number number2) {
        XYStep xYStep = null;
        switch (xYAxisType) {
            case DOMAIN: {
                xYStep = XYStepCalculator.getStep(xYPlot.getDomainStepMode(), rectF.width(), xYPlot.getDomainStepValue(), number, number2);
                break;
            }
            case RANGE: {
                xYStep = XYStepCalculator.getStep(xYPlot.getRangeStepMode(), rectF.height(), xYPlot.getRangeStepValue(), number, number2);
            }
        }
        return xYStep;
    }

    public static XYStep getStep(XYStepMode xYStepMode, float f, double d, Number number, Number number2) {
        double d2 = 0.0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        switch (xYStepMode) {
            case INCREMENT_BY_VAL: {
                d2 = d;
                f2 = (float)(d / ValPixConverter.valPerPix(number.floatValue(), number2.floatValue(), f));
                f3 = f / f2;
                break;
            }
            case INCREMENT_BY_PIXELS: {
                f2 = new Double(d).floatValue();
                f3 = f / f2;
                d2 = ValPixConverter.valPerPix(number.floatValue(), number2.floatValue(), f) * (double)f2;
                break;
            }
            case SUBDIVIDE: {
                f3 = new Double(d).floatValue();
                f2 = f / (f3 - 1.0f);
                d2 = ValPixConverter.valPerPix(number.floatValue(), number2.floatValue(), f) * (double)f2;
            }
        }
        return new XYStep(f3, f2, d2);
    }
}

