/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.util.Pair;
import com.androidplot.series.XYSeries;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class SimpleXYSeries
implements XYSeries {
    private LinkedList<Number> a = new LinkedList();
    private LinkedList<Number> b = new LinkedList();
    private String c = null;

    public SimpleXYSeries(String string) {
        this.c = string;
    }

    public SimpleXYSeries(List<? extends Number> list, ArrayFormat arrayFormat, String string) {
        this(string);
        this.setModel(list, arrayFormat);
    }

    public SimpleXYSeries(List<? extends Number> list, List<? extends Number> list2, String string) {
        this(string);
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("Neither the xVals nor the yVals parameters may be null.");
        }
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("xVals and yVals List parameters must be of the same size.");
        }
        this.a.addAll(list);
        this.b.addAll(list2);
    }

    public void setModel(List<? extends Number> list, ArrayFormat arrayFormat) {
        this.a.clear();
        this.b.clear();
        if (list == null || list.size() == 0) {
            return;
        }
        switch (arrayFormat) {
            case Y_VALS_ONLY: {
                for (int i = 0; i < list.size(); ++i) {
                    this.a.add(i);
                    this.b.add(list.get(i));
                }
                return;
            }
            case XY_VALS_INTERLEAVED: {
                if (list.size() % 2 != 0) {
                    throw new IndexOutOfBoundsException("Cannot auto-generate series from odd-sized xy List.");
                }
                int n = list.size() / 2;
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    this.a.add(list.get(n3));
                    this.b.add(list.get(n3 + 1));
                    ++n2;
                    n3 += 2;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected enum value: " + (Object)((Object)arrayFormat));
    }

    public void setX(Number number, int n) {
        if (this.a == null || this.a.size() <= n) {
            throw new IndexOutOfBoundsException();
        }
        this.a.set(n, number);
    }

    public void setY(Number number, int n) {
        if (this.b == null || this.b.size() <= n) {
            throw new IndexOutOfBoundsException();
        }
        this.b.set(n, number);
    }

    public synchronized void addFirst(Number number, Number number2) {
        this.a.addFirst(number);
        this.b.addFirst(number2);
    }

    public synchronized Pair<Number, Number> removeFirst() {
        if (this.size() <= 0) {
            throw new NoSuchElementException();
        }
        return new Pair((Object)this.a.removeFirst(), (Object)this.b.removeFirst());
    }

    public synchronized void addLast(Number number, Number number2) {
        this.a.addLast(number);
        this.b.addLast(number2);
    }

    public synchronized Pair<Number, Number> removeLast() {
        if (this.size() <= 0) {
            throw new NoSuchElementException();
        }
        return new Pair((Object)this.a.removeLast(), (Object)this.b.removeLast());
    }

    @Override
    public String getTitle() {
        return this.c;
    }

    @Override
    public int size() {
        if (this.a != null) {
            return this.a.size();
        }
        return 0;
    }

    @Override
    public Number getX(int n) {
        return this.a.get(n);
    }

    @Override
    public Number getY(int n) {
        return this.b.get(n);
    }

    public static enum ArrayFormat {
        Y_VALS_ONLY,
        XY_VALS_INTERLEAVED;

    }
}

