/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileArchive
implements IArchiveFile {
    private static final Logger logger = LoggerFactory.getLogger(ZipFileArchive.class);
    private final ZipFile mZipFile;

    private ZipFileArchive(ZipFile pZipFile) {
        this.mZipFile = pZipFile;
    }

    public static ZipFileArchive getZipFileArchive(File pFile) throws ZipException, IOException {
        return new ZipFileArchive(new ZipFile(pFile));
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, MapTile pTile) {
        String path = pTileSource.getTileRelativeFilenameString(pTile);
        try {
            ZipEntry entry = this.mZipFile.getEntry(path);
            if (entry != null) {
                return this.mZipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            logger.warn("Error getting zip stream: " + pTile, (Throwable)e);
        }
        return null;
    }

    public String toString() {
        return "ZipFileArchive [mZipFile=" + this.mZipFile.getName() + "]";
    }
}

