/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.ConfigurablePriorityThreadFactory;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapTileModuleProviderBase
implements OpenStreetMapTileProviderConstants {
    private final ExecutorService mExecutor;
    private static final Logger logger = LoggerFactory.getLogger(MapTileModuleProviderBase.class);
    private final ConcurrentHashMap<MapTile, MapTileRequestState> mWorking;
    final LinkedHashMap<MapTile, MapTileRequestState> mPending;

    protected abstract String getName();

    protected abstract String getThreadGroupName();

    protected abstract Runnable getTileLoader();

    public abstract boolean getUsesDataConnection();

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public abstract void setTileSource(ITileSource var1);

    public MapTileModuleProviderBase(int pThreadPoolSize, final int pPendingQueueSize) {
        this.mExecutor = Executors.newFixedThreadPool(pThreadPoolSize, new ConfigurablePriorityThreadFactory(5, this.getThreadGroupName()));
        this.mWorking = new ConcurrentHashMap();
        this.mPending = new LinkedHashMap<MapTile, MapTileRequestState>(pPendingQueueSize + 2, 0.1f, true){
            private static final long serialVersionUID = 6455337315681858866L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<MapTile, MapTileRequestState> pEldest) {
                return this.size() > pPendingQueueSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapTileAsync(MapTileRequestState pState) {
        LinkedHashMap<MapTile, MapTileRequestState> linkedHashMap = this.mPending;
        synchronized (linkedHashMap) {
            this.mPending.put(pState.getMapTile(), pState);
        }
        try {
            this.mExecutor.execute(this.getTileLoader());
        }
        catch (RejectedExecutionException e) {
            logger.warn("RejectedExecutionException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        LinkedHashMap<MapTile, MapTileRequestState> linkedHashMap = this.mPending;
        synchronized (linkedHashMap) {
            this.mPending.clear();
        }
        this.mWorking.clear();
    }

    public void detach() {
        this.clearQueue();
        this.mExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTileFromQueues(MapTile mapTile) {
        LinkedHashMap<MapTile, MapTileRequestState> linkedHashMap = this.mPending;
        synchronized (linkedHashMap) {
            this.mPending.remove(mapTile);
        }
        this.mWorking.remove(mapTile);
    }

    public class CantContinueException
    extends Exception {
        private static final long serialVersionUID = 146526524087765133L;

        public CantContinueException(String pDetailMessage) {
            super(pDetailMessage);
        }

        public CantContinueException(Throwable pThrowable) {
            super(pThrowable);
        }
    }

    protected abstract class TileLoader
    implements Runnable {
        protected TileLoader() {
        }

        protected abstract Drawable loadTile(MapTileRequestState var1) throws CantContinueException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MapTileRequestState nextTile() {
            LinkedHashMap<MapTile, MapTileRequestState> linkedHashMap = MapTileModuleProviderBase.this.mPending;
            synchronized (linkedHashMap) {
                MapTile result = null;
                Iterator<MapTile> iterator = MapTileModuleProviderBase.this.mPending.keySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        MapTile tile = iterator.next();
                        if (MapTileModuleProviderBase.this.mWorking.containsKey(tile)) continue;
                        result = tile;
                    }
                    catch (ConcurrentModificationException e) {
                        if (result != null) break;
                        iterator = MapTileModuleProviderBase.this.mPending.keySet().iterator();
                    }
                }
                if (result != null) {
                    MapTileModuleProviderBase.this.mWorking.put(result, MapTileModuleProviderBase.this.mPending.get(result));
                }
                return result != null ? MapTileModuleProviderBase.this.mPending.get(result) : null;
            }
        }

        private void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, pDrawable);
        }

        protected void tileCandidateLoaded(MapTileRequestState pState, Drawable pDrawable) {
            pState.getCallback().mapTileRequestCandidate(pState, pDrawable);
        }

        private void tileLoadedFailed(MapTileRequestState pState) {
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestFailed(pState);
        }

        @Override
        public final void run() {
            MapTileRequestState state;
            Drawable result = null;
            while ((state = this.nextTile()) != null) {
                try {
                    result = null;
                    result = this.loadTile(state);
                }
                catch (CantContinueException e) {
                    logger.info("Tile loader can't continue", (Throwable)e);
                    MapTileModuleProviderBase.this.clearQueue();
                }
                catch (Throwable e) {
                    logger.error("Error downloading tile: " + state, e);
                }
                if (result != null) {
                    this.tileLoaded(state, result);
                    continue;
                }
                this.tileLoadedFailed(state);
            }
        }
    }
}

