/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.MotionEvent;
import microsoft.mappoint.TileSystem;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileProviderBasic;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.TilesOverlay;

public class MinimapOverlay
extends TilesOverlay {
    private int mWidth = 100;
    private int mHeight = 100;
    private int mPadding = 10;
    private int mZoomDifference;
    private final Paint mPaint;
    private int mWorldSize_2;
    private final Rect mViewportRect = new Rect();
    private final Rect mTileArea = new Rect();
    private final Rect mMiniMapCanvasRect = new Rect();
    private final Rect mIntersectionRect = new Rect();

    public MinimapOverlay(Context pContext, Handler pTileRequestCompleteHandler, MapTileProviderBase pTileProvider, int pZoomDifference) {
        super(pTileProvider, pContext);
        this.setZoomDifference(pZoomDifference);
        this.mTileProvider.setTileRequestCompleteHandler(pTileRequestCompleteHandler);
        this.setLoadingLineColor(this.getLoadingBackgroundColor());
        this.mPaint = new Paint();
        this.mPaint.setColor(-7829368);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(2.0f);
    }

    public MinimapOverlay(Context pContext, Handler pTileRequestCompleteHandler, MapTileProviderBase pTileProvider) {
        this(pContext, pTileRequestCompleteHandler, pTileProvider, 3);
    }

    public MinimapOverlay(Context pContext, Handler pTileRequestCompleteHandler) {
        this(pContext, pTileRequestCompleteHandler, new MapTileProviderBasic(pContext));
    }

    public void setTileSource(ITileSource pTileSource) {
        this.mTileProvider.setTileSource(pTileSource);
    }

    public int getZoomDifference() {
        return this.mZoomDifference;
    }

    public void setZoomDifference(int zoomDifference) {
        this.mZoomDifference = zoomDifference;
    }

    @Override
    protected void draw(Canvas pC, MapView pOsmv, boolean shadow) {
        if (shadow) {
            return;
        }
        if (pOsmv.isAnimating()) {
            return;
        }
        MapView.Projection projection = pOsmv.getProjection();
        int zoomLevel = projection.getZoomLevel();
        this.mWorldSize_2 = TileSystem.MapSize(zoomLevel) / 2;
        this.mViewportRect.set(projection.getScreenRect());
        this.mViewportRect.offset(this.mWorldSize_2, this.mWorldSize_2);
        this.mTileArea.set(this.mViewportRect);
        int miniMapZoomLevelDifference = this.getZoomDifference();
        if (zoomLevel - this.getZoomDifference() < this.mTileProvider.getMinimumZoomLevel()) {
            miniMapZoomLevelDifference += zoomLevel - this.getZoomDifference() - this.mTileProvider.getMinimumZoomLevel();
        }
        this.mTileArea.set(this.mTileArea.left >> miniMapZoomLevelDifference, this.mTileArea.top >> miniMapZoomLevelDifference, this.mTileArea.right >> miniMapZoomLevelDifference, this.mTileArea.bottom >> miniMapZoomLevelDifference);
        this.mTileArea.set(this.mTileArea.centerX() - this.getWidth() / 2, this.mTileArea.centerY() - this.getHeight() / 2, this.mTileArea.centerX() + this.getWidth() / 2, this.mTileArea.centerY() + this.getHeight() / 2);
        this.mMiniMapCanvasRect.set(this.mViewportRect.right - this.getPadding() - this.getWidth(), this.mViewportRect.bottom - this.getPadding() - this.getHeight(), this.mViewportRect.right - this.getPadding(), this.mViewportRect.bottom - this.getPadding());
        this.mMiniMapCanvasRect.offset(-this.mWorldSize_2, -this.mWorldSize_2);
        pC.drawRect((float)(this.mMiniMapCanvasRect.left - 2), (float)(this.mMiniMapCanvasRect.top - 2), (float)(this.mMiniMapCanvasRect.right + 2), (float)(this.mMiniMapCanvasRect.bottom + 2), this.mPaint);
        super.drawTiles(pC, projection.getZoomLevel() - miniMapZoomLevelDifference, projection.getTileSizePixels(), this.mTileArea);
    }

    @Override
    protected void onTileReadyToDraw(Canvas c, Drawable currentMapTile, Rect tileRect) {
        int xOffset = tileRect.left - this.mTileArea.left + this.mMiniMapCanvasRect.left;
        int yOffset = tileRect.top - this.mTileArea.top + this.mMiniMapCanvasRect.top;
        currentMapTile.setBounds(xOffset, yOffset, xOffset + tileRect.width(), yOffset + tileRect.height());
        Rect oldClip = c.getClipBounds();
        if (this.mIntersectionRect.setIntersect(oldClip, this.mMiniMapCanvasRect)) {
            c.clipRect(this.mIntersectionRect);
            currentMapTile.draw(c);
            c.clipRect(oldClip);
        }
    }

    @Override
    public boolean onSingleTapUp(MotionEvent pEvent, MapView pMapView) {
        return this.mMiniMapCanvasRect.contains((int)pEvent.getX() + this.mViewportRect.left - this.mWorldSize_2, (int)pEvent.getY() + this.mViewportRect.top - this.mWorldSize_2);
    }

    @Override
    public boolean onDoubleTap(MotionEvent pEvent, MapView pMapView) {
        return this.mMiniMapCanvasRect.contains((int)pEvent.getX() + this.mViewportRect.left - this.mWorldSize_2, (int)pEvent.getY() + this.mViewportRect.top - this.mWorldSize_2);
    }

    @Override
    public boolean onLongPress(MotionEvent pEvent, MapView pMapView) {
        return this.mMiniMapCanvasRect.contains((int)pEvent.getX() + this.mViewportRect.left - this.mWorldSize_2, (int)pEvent.getY() + this.mViewportRect.top - this.mWorldSize_2);
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
    }

    public int getPadding() {
        return this.mPadding;
    }
}

