/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.plot;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.Layer;
import net.droidsolutions.droidcharts.common.ObjectList;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.common.ShapeUtilities;
import net.droidsolutions.droidcharts.common.SortOrder;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.anotations.CategoryAnnotation;
import net.droidsolutions.droidcharts.core.axis.Axis;
import net.droidsolutions.droidcharts.core.axis.AxisCollection;
import net.droidsolutions.droidcharts.core.axis.AxisLocation;
import net.droidsolutions.droidcharts.core.axis.AxisSpace;
import net.droidsolutions.droidcharts.core.axis.AxisState;
import net.droidsolutions.droidcharts.core.axis.CategoryAnchor;
import net.droidsolutions.droidcharts.core.axis.CategoryAxis;
import net.droidsolutions.droidcharts.core.axis.TickType;
import net.droidsolutions.droidcharts.core.axis.ValueAxis;
import net.droidsolutions.droidcharts.core.axis.ValueTick;
import net.droidsolutions.droidcharts.core.data.CategoryDataset;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.data.general.DatasetUtilities;
import net.droidsolutions.droidcharts.core.event.RendererChangeEvent;
import net.droidsolutions.droidcharts.core.event.RendererChangeListener;
import net.droidsolutions.droidcharts.core.plot.CategoryCrosshairState;
import net.droidsolutions.droidcharts.core.plot.CategoryMarker;
import net.droidsolutions.droidcharts.core.plot.DatasetRenderingOrder;
import net.droidsolutions.droidcharts.core.plot.Marker;
import net.droidsolutions.droidcharts.core.plot.Pannable;
import net.droidsolutions.droidcharts.core.plot.Plot;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.PlotState;
import net.droidsolutions.droidcharts.core.plot.ValueAxisPlot;
import net.droidsolutions.droidcharts.core.plot.Zoomable;
import net.droidsolutions.droidcharts.core.renderer.AbstractCategoryItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.CategoryItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.CategoryItemRendererState;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
Pannable,
Zoomable,
RendererChangeListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3537691700434728188L;
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final float DEFAULT_GRIDLINE_STROKE = 2.0f;
    public static final Paint DEFAULT_GRIDLINE_PAINT = new Paint(1);
    public static final Font DEFAULT_VALUE_LABEL_FONT;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final float DEFAULT_CROSSHAIR_STROKE = 2.0f;
    public static final Paint DEFAULT_CROSSHAIR_PAINT;
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private TreeMap datasetToDomainAxesMap;
    private TreeMap datasetToRangeAxesMap;
    private ObjectList renderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.REVERSE;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient float domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient float rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean rangeGridlinesVisible;
    private transient float rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean rangeMinorGridlinesVisible;
    private transient float rangeMinorGridlineStroke;
    private transient Paint rangeMinorGridlinePaint;
    private double anchorValue;
    private int crosshairDatasetIndex;
    private boolean domainCrosshairVisible;
    private Comparable domainCrosshairRowKey;
    private Comparable domainCrosshairColumnKey;
    private transient float domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient float rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private LegendItemCollection fixedLegendItems;
    private boolean rangePannable;

    static {
        DEFAULT_GRIDLINE_PAINT.setColor(-16776961);
        DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
        DEFAULT_CROSSHAIR_PAINT = new Paint(1);
        DEFAULT_CROSSHAIR_PAINT.setColor(-16776961);
    }

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset dataset, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.datasetToDomainAxesMap = new TreeMap();
        this.datasetToRangeAxesMap = new TreeMap();
        this.renderers = new ObjectList();
        this.datasets = new ObjectList();
        this.datasets.set(0, dataset);
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderers.set(0, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.domainAxes.set(0, domainAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (domainAxis != null) {
            domainAxis.setPlot(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxes.set(0, rangeAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = 2.0f;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeZeroBaselineVisible = false;
        Paint paint = new Paint(1);
        paint.setColor(-16777216);
        this.rangeZeroBaselinePaint = paint;
        this.rangeZeroBaselineStroke = 0.5f;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = 2.0f;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = 2.0f;
        paint = new Paint(1);
        paint.setColor(-1);
        this.rangeMinorGridlinePaint = paint;
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.anchorValue = 0.0;
        this.domainCrosshairVisible = false;
        this.domainCrosshairStroke = 2.0f;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = 2.0f;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.annotations = new ArrayList();
        this.rangePannable = false;
    }

    @Override
    public String getPlotType() {
        return "Category_Plot";
    }

    @Override
    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        this.orientation = orientation;
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = offset;
    }

    public CategoryAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public CategoryAxis getDomainAxis(int index) {
        Plot parent;
        CategoryAxis result = null;
        if (index < this.domainAxes.size()) {
            result = (CategoryAxis)this.domainAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getDomainAxis(index);
        }
        return result;
    }

    public void setDomainAxis(CategoryAxis axis) {
        this.setDomainAxis(0, axis);
    }

    public void setDomainAxis(int index, CategoryAxis axis) {
        this.setDomainAxis(index, axis, true);
    }

    public void setDomainAxis(int index, CategoryAxis axis, boolean notify) {
        CategoryAxis existing = (CategoryAxis)this.domainAxes.get(index);
        if (axis != null) {
            axis.setPlot(this);
        }
        this.domainAxes.set(index, axis);
        if (axis != null) {
            axis.configure();
        }
    }

    public void setDomainAxes(CategoryAxis[] axes) {
        int i = 0;
        while (i < axes.length) {
            this.setDomainAxis(i, axes[i], false);
            ++i;
        }
    }

    public int getDomainAxisIndex(CategoryAxis axis) {
        if (axis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        return this.domainAxes.indexOf(axis);
    }

    public AxisLocation getDomainAxisLocation() {
        return this.getDomainAxisLocation(0);
    }

    public AxisLocation getDomainAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.domainAxisLocations.size()) {
            result = (AxisLocation)this.domainAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.getDomainAxisLocation(0));
        }
        return result;
    }

    public void setDomainAxisLocation(AxisLocation location) {
        this.setDomainAxisLocation(0, location, true);
    }

    public void setDomainAxisLocation(AxisLocation location, boolean notify) {
        this.setDomainAxisLocation(0, location, notify);
    }

    public void setDomainAxisLocation(int index, AxisLocation location) {
        this.setDomainAxisLocation(index, location, true);
    }

    public void setDomainAxisLocation(int index, AxisLocation location, boolean notify) {
        if (index == 0 && location == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.set(index, location);
    }

    public RectangleEdge getDomainAxisEdge() {
        return this.getDomainAxisEdge(0);
    }

    public RectangleEdge getDomainAxisEdge(int index) {
        RectangleEdge result = null;
        AxisLocation location = this.getDomainAxisLocation(index);
        result = location != null ? Plot.resolveDomainAxisLocation(location, this.orientation) : RectangleEdge.opposite(this.getDomainAxisEdge(0));
        return result;
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        int i = 0;
        while (i < this.domainAxes.size()) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(i);
            ++i;
        }
        this.domainAxes.clear();
    }

    public void configureDomainAxes() {
        int i = 0;
        while (i < this.domainAxes.size()) {
            CategoryAxis axis = (CategoryAxis)this.domainAxes.get(i);
            if (axis != null) {
                axis.configure();
            }
            ++i;
        }
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public ValueAxis getRangeAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.rangeAxes.size()) {
            result = (ValueAxis)this.rangeAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getRangeAxis(index);
        }
        return result;
    }

    public void setRangeAxis(ValueAxis axis) {
        this.setRangeAxis(0, axis);
    }

    public void setRangeAxis(int index, ValueAxis axis) {
        this.setRangeAxis(index, axis, true);
    }

    public void setRangeAxis(int index, ValueAxis axis, boolean notify) {
        ValueAxis existing = (ValueAxis)this.rangeAxes.get(index);
        if (axis != null) {
            axis.setPlot(this);
        }
        this.rangeAxes.set(index, axis);
        if (axis != null) {
            axis.configure();
        }
    }

    public void setRangeAxes(ValueAxis[] axes) {
        int i = 0;
        while (i < axes.length) {
            this.setRangeAxis(i, axes[i], false);
            ++i;
        }
    }

    public int getRangeAxisIndex(ValueAxis axis) {
        Plot parent;
        if (axis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        int result = this.rangeAxes.indexOf(axis);
        if (result < 0 && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot p = (CategoryPlot)parent;
            result = p.getRangeAxisIndex(axis);
        }
        return result;
    }

    public AxisLocation getRangeAxisLocation() {
        return this.getRangeAxisLocation(0);
    }

    public AxisLocation getRangeAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.rangeAxisLocations.size()) {
            result = (AxisLocation)this.rangeAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.getRangeAxisLocation(0));
        }
        return result;
    }

    public void setRangeAxisLocation(AxisLocation location) {
        this.setRangeAxisLocation(location, true);
    }

    public void setRangeAxisLocation(AxisLocation location, boolean notify) {
        this.setRangeAxisLocation(0, location, notify);
    }

    public void setRangeAxisLocation(int index, AxisLocation location) {
        this.setRangeAxisLocation(index, location, true);
    }

    public void setRangeAxisLocation(int index, AxisLocation location, boolean notify) {
        if (index == 0 && location == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.set(index, location);
    }

    public RectangleEdge getRangeAxisEdge() {
        return this.getRangeAxisEdge(0);
    }

    public RectangleEdge getRangeAxisEdge(int index) {
        AxisLocation location = this.getRangeAxisLocation(index);
        RectangleEdge result = Plot.resolveRangeAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite(this.getRangeAxisEdge(0));
        }
        return result;
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            ++i;
        }
        this.rangeAxes.clear();
    }

    public void configureRangeAxes() {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis axis = (ValueAxis)this.rangeAxes.get(i);
            if (axis != null) {
                axis.configure();
            }
            ++i;
        }
    }

    public CategoryDataset getDataset() {
        return this.getDataset(0);
    }

    public CategoryDataset getDataset(int index) {
        CategoryDataset result = null;
        if (this.datasets.size() > index) {
            result = (CategoryDataset)this.datasets.get(index);
        }
        return result;
    }

    public void setDataset(CategoryDataset dataset) {
        this.setDataset(0, dataset);
    }

    public void setDataset(int index, CategoryDataset dataset) {
        CategoryDataset existing = (CategoryDataset)this.datasets.get(index);
        this.datasets.set(index, dataset);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(CategoryDataset dataset) {
        int result = -1;
        int i = 0;
        while (i < this.datasets.size()) {
            if (dataset == this.datasets.get(i)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public void mapDatasetToDomainAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(new Integer(axisIndex));
        this.mapDatasetToDomainAxes(index, axisIndices);
    }

    public void mapDatasetToDomainAxes(int index, List axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = new Integer(index);
        this.datasetToDomainAxesMap.put(key, new ArrayList(axisIndices));
    }

    private void checkAxisIndices(List indices) {
        if (indices == null) {
            return;
        }
        int count = indices.size();
        if (count == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet set = new HashSet();
        int i = 0;
        while (i < count) {
            Object item = indices.get(i);
            if (!(item instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (set.contains(item)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            set.add(item);
            ++i;
        }
    }

    public CategoryAxis getDomainAxisForDataset(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative 'index'.");
        }
        CategoryAxis axis = null;
        List axisIndices = (List)this.datasetToDomainAxesMap.get(new Integer(index));
        if (axisIndices != null) {
            Integer axisIndex = (Integer)axisIndices.get(0);
            axis = this.getDomainAxis(axisIndex);
        } else {
            axis = this.getDomainAxis(0);
        }
        return axis;
    }

    public void mapDatasetToRangeAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(new Integer(axisIndex));
        this.mapDatasetToRangeAxes(index, axisIndices);
    }

    public void mapDatasetToRangeAxes(int index, List axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = new Integer(index);
        this.datasetToRangeAxesMap.put(key, new ArrayList(axisIndices));
    }

    public ValueAxis getRangeAxisForDataset(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative 'index'.");
        }
        ValueAxis axis = null;
        List axisIndices = (List)this.datasetToRangeAxesMap.get(new Integer(index));
        if (axisIndices != null) {
            Integer axisIndex = (Integer)axisIndices.get(0);
            axis = this.getRangeAxis(axisIndex);
        } else {
            axis = this.getRangeAxis(0);
        }
        return axis;
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public CategoryItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public CategoryItemRenderer getRenderer(int index) {
        CategoryItemRenderer result = null;
        if (this.renderers.size() > index) {
            result = (CategoryItemRenderer)this.renderers.get(index);
        }
        return result;
    }

    public void setRenderer(CategoryItemRenderer renderer) {
        this.setRenderer(0, renderer, true);
    }

    public void setRenderer(CategoryItemRenderer renderer, boolean notify) {
        this.setRenderer(0, renderer, notify);
    }

    public void setRenderer(int index, CategoryItemRenderer renderer) {
        this.setRenderer(index, renderer, true);
    }

    public void setRenderer(int index, CategoryItemRenderer renderer, boolean notify) {
        CategoryItemRenderer existing = (CategoryItemRenderer)this.renderers.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.renderers.set(index, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
    }

    public void setRenderers(CategoryItemRenderer[] renderers) {
        int i = 0;
        while (i < renderers.length) {
            this.setRenderer(i, renderers[i], false);
            ++i;
        }
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset dataset) {
        CategoryItemRenderer result = null;
        int i = 0;
        while (i < this.datasets.size()) {
            if (this.datasets.get(i) == dataset) {
                result = (CategoryItemRenderer)this.renderers.get(i);
                break;
            }
            ++i;
        }
        return result;
    }

    public int getIndexOf(CategoryItemRenderer renderer) {
        return this.renderers.indexOf(renderer);
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = order;
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.columnRenderingOrder = order;
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.rowRenderingOrder = order;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean visible) {
        if (this.domainGridlinesVisible != visible) {
            this.domainGridlinesVisible = visible;
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor position) {
        if (position == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.domainGridlinePosition = position;
    }

    public float getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(float stroke) {
        this.domainGridlineStroke = stroke;
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean visible) {
        this.rangeZeroBaselineVisible = visible;
    }

    public float getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(float stroke) {
        this.rangeZeroBaselineStroke = stroke;
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeZeroBaselinePaint = paint;
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean visible) {
        if (this.rangeGridlinesVisible != visible) {
            this.rangeGridlinesVisible = visible;
        }
    }

    public float getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(float stroke) {
        this.rangeGridlineStroke = stroke;
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean visible) {
        if (this.rangeMinorGridlinesVisible != visible) {
            this.rangeMinorGridlinesVisible = visible;
        }
    }

    public float getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(float stroke) {
        this.rangeMinorGridlineStroke = stroke;
    }

    public Paint getRangeMinorGridlinePaint() {
        return this.rangeMinorGridlinePaint;
    }

    public void setRangeMinorGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeMinorGridlinePaint = paint;
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection items) {
        this.fixedLegendItems = items;
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = this.fixedLegendItems;
        if (result == null) {
            result = new LegendItemCollection();
            int count = this.datasets.size();
            int datasetIndex = 0;
            while (datasetIndex < count) {
                CategoryItemRenderer renderer;
                CategoryDataset dataset = this.getDataset(datasetIndex);
                if (dataset != null && (renderer = this.getRenderer(datasetIndex)) != null) {
                    int seriesCount = dataset.getRowCount();
                    int i = 0;
                    while (i < seriesCount) {
                        LegendItem item = renderer.getLegendItem(datasetIndex, i);
                        if (item != null) {
                            result.add(item);
                        }
                        ++i;
                    }
                }
                ++datasetIndex;
            }
        }
        return result;
    }

    @Override
    public void handleClick(int x, int y, PlotRenderingInfo info) {
        Rectangle2D dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            double java2D = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                java2D = x;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                java2D = y;
            }
            RectangleEdge edge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double value = this.getRangeAxis().java2DToValue(java2D, info.getDataArea(), edge);
            this.setAnchorValue(value);
            this.setRangeCrosshairValue(value);
        }
    }

    @Override
    public void zoom(double percent) {
        if (percent > 0.0) {
            double range = this.getRangeAxis().getRange().getLength();
            double scaledRange = range * percent;
            this.getRangeAxis().setRange(this.anchorValue - scaledRange / 2.0, this.anchorValue + scaledRange / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
        }
    }

    public void addDomainMarker(CategoryMarker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(CategoryMarker marker, Layer layer) {
        this.addDomainMarker(0, marker, layer);
    }

    public void addDomainMarker(int index, CategoryMarker marker, Layer layer) {
        this.addDomainMarker(index, marker, layer, true);
    }

    public void addDomainMarker(int index, CategoryMarker marker, Layer layer, boolean notify) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            ArrayList<CategoryMarker> markers = (ArrayList<CategoryMarker>)this.foregroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<CategoryMarker>();
                this.foregroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<CategoryMarker> markers = (ArrayList<CategoryMarker>)this.backgroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<CategoryMarker>();
                this.backgroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
    }

    public void clearDomainMarkers() {
        Set keys;
        if (this.backgroundDomainMarkers != null) {
            keys = this.backgroundDomainMarkers.keySet();
            for (Integer key : keys) {
                this.clearDomainMarkers(key);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            keys = this.foregroundDomainMarkers.keySet();
            for (Integer key : keys) {
                this.clearDomainMarkers(key);
            }
            this.foregroundDomainMarkers.clear();
        }
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getDomainMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.foregroundDomainMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.backgroundDomainMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public void clearDomainMarkers(int index) {
        Collection markers;
        Integer key = new Integer(index);
        if (this.backgroundDomainMarkers != null && (markers = (Collection)this.backgroundDomainMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
        if (this.foregroundDomainMarkers != null && (markers = (Collection)this.foregroundDomainMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int index, Marker marker, Layer layer) {
        return this.removeDomainMarker(index, marker, layer, true);
    }

    public boolean removeDomainMarker(int index, Marker marker, Layer layer, boolean notify) {
        ArrayList markers = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(index)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(index));
        if (markers == null) {
            return false;
        }
        boolean removed = markers.remove(marker);
        return removed;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void addRangeMarker(int index, Marker marker, Layer layer) {
        this.addRangeMarker(index, marker, layer, true);
    }

    public void addRangeMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
    }

    public void clearRangeMarkers() {
        Set keys;
        if (this.backgroundRangeMarkers != null) {
            keys = this.backgroundRangeMarkers.keySet();
            for (Integer key : keys) {
                this.clearRangeMarkers(key);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            keys = this.foregroundRangeMarkers.keySet();
            for (Integer key : keys) {
                this.clearRangeMarkers(key);
            }
            this.foregroundRangeMarkers.clear();
        }
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getRangeMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.foregroundRangeMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.backgroundRangeMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public void clearRangeMarkers(int index) {
        Collection markers;
        Integer key = new Integer(index);
        if (this.backgroundRangeMarkers != null && (markers = (Collection)this.backgroundRangeMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
        if (this.foregroundRangeMarkers != null && (markers = (Collection)this.foregroundRangeMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int index, Marker marker, Layer layer) {
        return this.removeRangeMarker(index, marker, layer, true);
    }

    public boolean removeRangeMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        ArrayList markers = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundRangeMarkers.get(new Integer(index)) : (ArrayList)this.backgroundRangeMarkers.get(new Integer(index));
        if (markers == null) {
            return false;
        }
        boolean removed = markers.remove(marker);
        return removed;
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean flag) {
        if (this.domainCrosshairVisible != flag) {
            this.domainCrosshairVisible = flag;
        }
    }

    public Comparable getDomainCrosshairRowKey() {
        return this.domainCrosshairRowKey;
    }

    public void setDomainCrosshairRowKey(Comparable key) {
        this.setDomainCrosshairRowKey(key, true);
    }

    public void setDomainCrosshairRowKey(Comparable key, boolean notify) {
        this.domainCrosshairRowKey = key;
    }

    public Comparable getDomainCrosshairColumnKey() {
        return this.domainCrosshairColumnKey;
    }

    public void setDomainCrosshairColumnKey(Comparable key) {
        this.setDomainCrosshairColumnKey(key, true);
    }

    public void setDomainCrosshairColumnKey(Comparable key, boolean notify) {
        this.domainCrosshairColumnKey = key;
    }

    public int getCrosshairDatasetIndex() {
        return this.crosshairDatasetIndex;
    }

    public void setCrosshairDatasetIndex(int index) {
        this.setCrosshairDatasetIndex(index, true);
    }

    public void setCrosshairDatasetIndex(int index, boolean notify) {
        this.crosshairDatasetIndex = index;
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainCrosshairPaint = paint;
    }

    public float getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(float stroke) {
        this.domainCrosshairStroke = stroke;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean flag) {
        if (this.rangeCrosshairVisible != flag) {
            this.rangeCrosshairVisible = flag;
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean flag) {
        if (this.rangeCrosshairLockedOnData != flag) {
            this.rangeCrosshairLockedOnData = flag;
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double value) {
        this.setRangeCrosshairValue(value, true);
    }

    public void setRangeCrosshairValue(double value, boolean notify) {
        this.rangeCrosshairValue = value;
    }

    public float getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(float stroke) {
        this.rangeCrosshairStroke = stroke;
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeCrosshairPaint = paint;
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation annotation) {
        this.addAnnotation(annotation, true);
    }

    public void addAnnotation(CategoryAnnotation annotation, boolean notify) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(annotation);
    }

    public boolean removeAnnotation(CategoryAnnotation annotation) {
        return this.removeAnnotation(annotation, true);
    }

    public boolean removeAnnotation(CategoryAnnotation annotation, boolean notify) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean removed = this.annotations.remove(annotation);
        return removed;
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    protected AxisSpace calculateDomainAxisSpace(Canvas g2, Rectangle2D plotArea, AxisSpace space) {
        block6: {
            block4: {
                block5: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block4;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block5;
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block6;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block6;
                space.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                space.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block6;
            }
            RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.drawSharedDomainAxis) {
                space = this.getDomainAxis().reserveSpace(g2, this, plotArea, domainEdge, space);
            }
            int i = 0;
            while (i < this.domainAxes.size()) {
                Axis xAxis = (Axis)this.domainAxes.get(i);
                if (xAxis != null) {
                    RectangleEdge edge = this.getDomainAxisEdge(i);
                    space = xAxis.reserveSpace(g2, this, plotArea, edge, space);
                }
                ++i;
            }
        }
        return space;
    }

    protected AxisSpace calculateRangeAxisSpace(Canvas g2, Rectangle2D plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                space.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            int i = 0;
            while (i < this.rangeAxes.size()) {
                Axis yAxis = (Axis)this.rangeAxes.get(i);
                if (yAxis != null) {
                    RectangleEdge edge = this.getRangeAxisEdge(i);
                    space = yAxis.reserveSpace(g2, this, plotArea, edge, space);
                }
                ++i;
            }
        }
        return space;
    }

    protected AxisSpace calculateAxisSpace(Canvas g2, Rectangle2D plotArea) {
        AxisSpace space = new AxisSpace();
        space = this.calculateRangeAxisSpace(g2, plotArea, space);
        space = this.calculateDomainAxisSpace(g2, plotArea, space);
        return space;
    }

    @Override
    public void draw(Canvas g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo state) {
        int i;
        ValueAxis rangeAxis;
        boolean b2;
        boolean b1 = area.getWidth() <= 10.0;
        boolean bl = b2 = area.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (state == null) {
            state = new PlotRenderingInfo(null);
        }
        state.setPlotArea(area);
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        AxisSpace space = this.calculateAxisSpace(g2, area);
        Rectangle2D dataArea = space.shrink(area, null);
        this.axisOffset.trim(dataArea);
        state.setDataArea(dataArea);
        this.createAndAddEntity((Rectangle2D)dataArea.clone(), state, null, null);
        if (this.getRenderer() != null) {
            this.getRenderer().drawBackground(g2, this, dataArea);
        } else {
            this.drawBackground(g2, dataArea);
        }
        Map axisStateMap = this.drawAxes(g2, area, dataArea, state);
        if (anchor != null && !dataArea.contains(anchor)) {
            anchor = ShapeUtilities.getPointInRectangle(anchor.getX(), anchor.getY(), dataArea);
        }
        CategoryCrosshairState crosshairState = new CategoryCrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(anchor);
        crosshairState.setAnchorX(Double.NaN);
        crosshairState.setAnchorY(Double.NaN);
        if (anchor != null && (rangeAxis = this.getRangeAxis()) != null) {
            double y = this.getOrientation() == PlotOrientation.VERTICAL ? rangeAxis.java2DToValue(anchor.getY(), dataArea, this.getRangeAxisEdge()) : rangeAxis.java2DToValue(anchor.getX(), dataArea, this.getRangeAxisEdge());
            crosshairState.setAnchorY(y);
        }
        crosshairState.setRowKey(this.getDomainCrosshairRowKey());
        crosshairState.setColumnKey(this.getDomainCrosshairColumnKey());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        g2.save();
        g2.clipRect((float)dataArea.getMinX(), (float)dataArea.getMaxY(), (float)dataArea.getMaxX(), (float)dataArea.getMinY());
        this.drawDomainGridlines(g2, dataArea);
        AxisState rangeAxisState = (AxisState)axisStateMap.get(this.getRangeAxis());
        if (rangeAxisState == null && parentState != null) {
            rangeAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (rangeAxisState != null) {
            this.drawRangeGridlines(g2, dataArea, rangeAxisState.getTicks());
            this.drawZeroRangeBaseline(g2, dataArea);
        }
        int i2 = 0;
        while (i2 < this.renderers.size()) {
            this.drawDomainMarkers(g2, dataArea, i2, Layer.BACKGROUND);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.renderers.size()) {
            this.drawRangeMarkers(g2, dataArea, i2, Layer.BACKGROUND);
            ++i2;
        }
        boolean foundData = false;
        DatasetRenderingOrder order = this.getDatasetRenderingOrder();
        if (order == DatasetRenderingOrder.FORWARD) {
            i = 0;
            while (i < this.datasets.size()) {
                foundData = this.render(g2, dataArea, i, state, crosshairState) || foundData;
                ++i;
            }
        } else {
            i = this.datasets.size() - 1;
            while (i >= 0) {
                foundData = this.render(g2, dataArea, i, state, crosshairState) || foundData;
                --i;
            }
        }
        i = 0;
        while (i < this.renderers.size()) {
            this.drawDomainMarkers(g2, dataArea, i, Layer.FOREGROUND);
            ++i;
        }
        i = 0;
        while (i < this.renderers.size()) {
            this.drawRangeMarkers(g2, dataArea, i, Layer.FOREGROUND);
            ++i;
        }
        this.drawAnnotations(g2, dataArea);
        g2.restore();
        if (!foundData) {
            this.drawNoDataMessage(g2, dataArea);
        }
        int datasetIndex = crosshairState.getDatasetIndex();
        this.setCrosshairDatasetIndex(datasetIndex, false);
        Comparable rowKey = crosshairState.getRowKey();
        Comparable columnKey = crosshairState.getColumnKey();
        this.setDomainCrosshairRowKey(rowKey, false);
        this.setDomainCrosshairColumnKey(columnKey, false);
        if (this.isDomainCrosshairVisible() && columnKey != null) {
            Paint paint = this.getDomainCrosshairPaint();
            float stroke = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(g2, dataArea, this.orientation, datasetIndex, rowKey, columnKey, stroke, paint);
        }
        ValueAxis yAxis = this.getRangeAxisForDataset(datasetIndex);
        RectangleEdge yAxisEdge = this.getRangeAxisEdge();
        if (!this.rangeCrosshairLockedOnData && anchor != null) {
            double yy = this.getOrientation() == PlotOrientation.VERTICAL ? yAxis.java2DToValue(anchor.getY(), dataArea, yAxisEdge) : yAxis.java2DToValue(anchor.getX(), dataArea, yAxisEdge);
            crosshairState.setCrosshairY(yy);
        }
        this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            double y = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            float stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(g2, dataArea, this.getOrientation(), y, yAxis, stroke, paint);
        }
        if (this.isOutlineVisible()) {
            if (this.getRenderer() != null) {
                this.getRenderer().drawOutline(g2, this, dataArea);
            } else {
                this.drawOutline(g2, dataArea);
            }
        }
    }

    @Override
    public void drawBackground(Canvas g2, Rectangle2D area) {
        this.fillBackground(g2, area, this.orientation);
    }

    protected Map drawAxes(Canvas g2, Rectangle2D plotArea, Rectangle2D dataArea, PlotRenderingInfo plotState) {
        AxisState axisState;
        AxisCollection axisCollection = new AxisCollection();
        int index = 0;
        while (index < this.domainAxes.size()) {
            CategoryAxis xAxis = (CategoryAxis)this.domainAxes.get(index);
            if (xAxis != null) {
                axisCollection.add(xAxis, this.getDomainAxisEdge(index));
            }
            ++index;
        }
        index = 0;
        while (index < this.rangeAxes.size()) {
            ValueAxis yAxis = (ValueAxis)this.rangeAxes.get(index);
            if (yAxis != null) {
                axisCollection.add(yAxis, this.getRangeAxisEdge(index));
            }
            ++index;
        }
        HashMap<Axis, AxisState> axisStateMap = new HashMap<Axis, AxisState>();
        double cursor = dataArea.getMinY() - this.axisOffset.calculateTopOutset(dataArea.getHeight());
        for (Axis axis : axisCollection.getAxesAtTop()) {
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.TOP, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = dataArea.getMaxY() + this.axisOffset.calculateBottomOutset(dataArea.getHeight());
        for (Axis axis : axisCollection.getAxesAtBottom()) {
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.BOTTOM, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = dataArea.getMinX() - this.axisOffset.calculateLeftOutset(dataArea.getWidth());
        for (Axis axis : axisCollection.getAxesAtLeft()) {
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.LEFT, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = dataArea.getMaxX() + this.axisOffset.calculateRightOutset(dataArea.getWidth());
        for (Axis axis : axisCollection.getAxesAtRight()) {
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.RIGHT, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        return axisStateMap;
    }

    public boolean render(Canvas g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CategoryCrosshairState crosshairState) {
        boolean hasData;
        boolean foundData = false;
        CategoryDataset currentDataset = this.getDataset(index);
        CategoryItemRenderer renderer = this.getRenderer(index);
        CategoryAxis domainAxis = this.getDomainAxisForDataset(index);
        ValueAxis rangeAxis = this.getRangeAxisForDataset(index);
        boolean bl = hasData = !DatasetUtilities.isEmptyOrNull(currentDataset);
        if (hasData && renderer != null) {
            foundData = true;
            CategoryItemRendererState state = renderer.initialise(g2, dataArea, this, index, info);
            state.setCrosshairState(crosshairState);
            int columnCount = currentDataset.getColumnCount();
            int rowCount = currentDataset.getRowCount();
            int passCount = renderer.getPassCount();
            int pass = 0;
            while (pass < passCount) {
                int row;
                int column;
                if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                    column = 0;
                    while (column < columnCount) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            row = 0;
                            while (row < rowCount) {
                                renderer.drawItem(g2, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                ++row;
                            }
                        } else {
                            row = rowCount - 1;
                            while (row >= 0) {
                                renderer.drawItem(g2, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                --row;
                            }
                        }
                        ++column;
                    }
                } else {
                    column = columnCount - 1;
                    while (column >= 0) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            row = 0;
                            while (row < rowCount) {
                                renderer.drawItem(g2, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                ++row;
                            }
                        } else {
                            row = rowCount - 1;
                            while (row >= 0) {
                                renderer.drawItem(g2, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                --row;
                            }
                        }
                        --column;
                    }
                }
                ++pass;
            }
        }
        return foundData;
    }

    protected void drawDomainGridlines(Canvas g2, Rectangle2D dataArea) {
        if (!this.isDomainGridlinesVisible()) {
            return;
        }
        CategoryAnchor anchor = this.getDomainGridlinePosition();
        RectangleEdge domainAxisEdge = this.getDomainAxisEdge();
        CategoryDataset dataset = this.getDataset();
        if (dataset == null) {
            return;
        }
        CategoryAxis axis = this.getDomainAxis();
        if (axis != null) {
            int columnCount = dataset.getColumnCount();
            int c = 0;
            while (c < columnCount) {
                double xx = axis.getCategoryJava2DCoordinate(anchor, c, columnCount, dataArea, domainAxisEdge);
                CategoryItemRenderer renderer1 = this.getRenderer();
                if (renderer1 != null) {
                    renderer1.drawDomainGridline(g2, this, dataArea, xx);
                }
                ++c;
            }
        }
    }

    protected void drawRangeGridlines(Canvas g2, Rectangle2D dataArea, List ticks) {
        if (!this.isRangeGridlinesVisible() && !this.isRangeMinorGridlinesVisible()) {
            return;
        }
        ValueAxis axis = this.getRangeAxis();
        if (axis == null) {
            return;
        }
        CategoryItemRenderer r = this.getRenderer();
        if (r == null) {
            return;
        }
        float gridStroke = 0.0f;
        Paint gridPaint = null;
        boolean paintLine = false;
        Iterator iterator = ticks.iterator();
        while (iterator.hasNext()) {
            paintLine = false;
            ValueTick tick = (ValueTick)iterator.next();
            if (tick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                gridStroke = this.getRangeMinorGridlineStroke();
                gridPaint = this.getRangeMinorGridlinePaint();
                paintLine = true;
            } else if (tick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                gridStroke = this.getRangeGridlineStroke();
                gridPaint = this.getRangeGridlinePaint();
                paintLine = true;
            }
            if (tick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !paintLine) continue;
            if (r instanceof AbstractCategoryItemRenderer) {
                AbstractCategoryItemRenderer aci = (AbstractCategoryItemRenderer)r;
                aci.drawRangeLine(g2, this, axis, dataArea, tick.getValue(), gridPaint, gridStroke);
                continue;
            }
            r.drawRangeGridline(g2, this, axis, dataArea, tick.getValue());
        }
    }

    protected void drawZeroRangeBaseline(Canvas g2, Rectangle2D area) {
        if (!this.isRangeZeroBaselineVisible()) {
            return;
        }
        CategoryItemRenderer r = this.getRenderer();
        if (r instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer aci = (AbstractCategoryItemRenderer)r;
            aci.drawRangeLine(g2, this, this.getRangeAxis(), area, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        } else {
            r.drawRangeGridline(g2, this, this.getRangeAxis(), area, 0.0);
        }
    }

    protected void drawAnnotations(Canvas g2, Rectangle2D dataArea) {
        if (this.getAnnotations() != null) {
            for (CategoryAnnotation annotation : this.getAnnotations()) {
                annotation.draw(g2, this, dataArea, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawDomainMarkers(Canvas g2, Rectangle2D dataArea, int index, Layer layer) {
        CategoryItemRenderer r = this.getRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getDomainMarkers(index, layer);
        CategoryAxis axis = this.getDomainAxisForDataset(index);
        if (markers != null && axis != null) {
            for (CategoryMarker marker : markers) {
                r.drawDomainMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawRangeMarkers(Canvas g2, Rectangle2D dataArea, int index, Layer layer) {
        CategoryItemRenderer r = this.getRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getRangeMarkers(index, layer);
        ValueAxis axis = this.getRangeAxisForDataset(index);
        if (markers != null && axis != null) {
            for (Marker marker : markers) {
                r.drawRangeMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawRangeLine(Canvas g2, Rectangle2D dataArea, double value, float stroke, Paint paint) {
        double java2D = this.getRangeAxis().valueToJava2D(value, dataArea, this.getRangeAxisEdge());
        Line2D.Double line = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(java2D, dataArea.getMinY(), java2D, dataArea.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), java2D, dataArea.getMaxX(), java2D);
        }
        paint.setStrokeWidth(stroke);
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    protected void drawDomainCrosshair(Canvas g2, Rectangle2D dataArea, PlotOrientation orientation, int datasetIndex, Comparable rowKey, Comparable columnKey, float stroke, Paint paint) {
        CategoryDataset dataset = this.getDataset(datasetIndex);
        CategoryAxis axis = this.getDomainAxisForDataset(datasetIndex);
        CategoryItemRenderer renderer = this.getRenderer(datasetIndex);
        Line2D.Double line = null;
        if (orientation == PlotOrientation.VERTICAL) {
            double xx = renderer.getItemMiddle(rowKey, columnKey, dataset, axis, dataArea, RectangleEdge.BOTTOM);
            line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
        } else {
            double yy = renderer.getItemMiddle(rowKey, columnKey, dataset, axis, dataArea, RectangleEdge.LEFT);
            line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
        }
        paint.setStrokeWidth(stroke);
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    protected void drawRangeCrosshair(Canvas g2, Rectangle2D dataArea, PlotOrientation orientation, double value, ValueAxis axis, float stroke, Paint paint) {
        if (!axis.getRange().contains(value)) {
            return;
        }
        Line2D.Double line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
            line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
        } else {
            double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
            line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
        }
        paint.setStrokeWidth(stroke);
        g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
    }

    @Override
    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        ArrayList mappedDatasets = new ArrayList();
        int rangeIndex = this.rangeAxes.indexOf(axis);
        if (rangeIndex >= 0) {
            mappedDatasets.addAll(this.datasetsMappedToRangeAxis(rangeIndex));
        } else if (axis == this.getRangeAxis()) {
            mappedDatasets.addAll(this.datasetsMappedToRangeAxis(0));
        }
        for (CategoryDataset d : mappedDatasets) {
            CategoryItemRenderer r = this.getRendererForDataset(d);
            if (r == null) continue;
            result = Range.combine(result, r.findRangeBounds(d));
        }
        return result;
    }

    private List datasetsMappedToDomainAxis(int axisIndex) {
        Integer key = new Integer(axisIndex);
        ArrayList<CategoryDataset> result = new ArrayList<CategoryDataset>();
        int i = 0;
        while (i < this.datasets.size()) {
            List mappedAxes = (List)this.datasetToDomainAxesMap.get(new Integer(i));
            CategoryDataset dataset = (CategoryDataset)this.datasets.get(i);
            if (mappedAxes == null) {
                if (key.equals(ZERO) && dataset != null) {
                    result.add(dataset);
                }
            } else if (mappedAxes.contains(key) && dataset != null) {
                result.add(dataset);
            }
            ++i;
        }
        return result;
    }

    private List datasetsMappedToRangeAxis(int index) {
        Integer key = new Integer(index);
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.datasets.size()) {
            List mappedAxes = (List)this.datasetToRangeAxesMap.get(new Integer(i));
            if (mappedAxes == null) {
                if (key.equals(ZERO)) {
                    result.add(this.datasets.get(i));
                }
            } else if (mappedAxes.contains(key)) {
                result.add(this.datasets.get(i));
            }
            ++i;
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace space) {
        this.setFixedDomainAxisSpace(space, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace space, boolean notify) {
        this.fixedDomainAxisSpace = space;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace space) {
        this.setFixedRangeAxisSpace(space, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace space, boolean notify) {
        this.fixedRangeAxisSpace = space;
    }

    public List getCategories() {
        List result = null;
        if (this.getDataset() != null) {
            result = Collections.unmodifiableList(this.getDataset().getColumnKeys());
        }
        return result;
    }

    public List getCategoriesForAxis(CategoryAxis axis) {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        int axisIndex = this.domainAxes.indexOf(axis);
        List datasets = this.datasetsMappedToDomainAxis(axisIndex);
        for (CategoryDataset dataset : datasets) {
            int i = 0;
            while (i < dataset.getColumnCount()) {
                Comparable category = dataset.getColumnKey(i);
                if (!result.contains(category)) {
                    result.add(category);
                }
                ++i;
            }
        }
        return result;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void setDrawSharedDomainAxis(boolean draw) {
        this.drawSharedDomainAxis = draw;
    }

    @Override
    public boolean isDomainPannable() {
        return false;
    }

    @Override
    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean pannable) {
        this.rangePannable = pannable;
    }

    @Override
    public void panDomainAxes(double percent, PlotRenderingInfo info, Point2D source) {
    }

    @Override
    public void panRangeAxes(double percent, PlotRenderingInfo info, Point2D source) {
        if (!this.isRangePannable()) {
            return;
        }
        int rangeAxisCount = this.getRangeAxisCount();
        int i = 0;
        while (i < rangeAxisCount) {
            ValueAxis axis = this.getRangeAxis(i);
            if (axis != null) {
                double length = axis.getRange().getLength();
                double adj = percent * length;
                if (axis.isInverted()) {
                    adj = -adj;
                }
                axis.setRange(axis.getLowerBound() + adj, axis.getUpperBound() + adj);
            }
            ++i;
        }
    }

    @Override
    public boolean isDomainZoomable() {
        return false;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo state, Point2D source) {
    }

    @Override
    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo state, Point2D source) {
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source, boolean useAnchor) {
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo state, Point2D source) {
        this.zoomRangeAxes(factor, state, source, false);
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo info, Point2D source, boolean useAnchor) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                if (useAnchor) {
                    double sourceY = source.getY();
                    if (this.orientation == PlotOrientation.HORIZONTAL) {
                        sourceY = source.getX();
                    }
                    double anchorY = rangeAxis.java2DToValue(sourceY, info.getDataArea(), this.getRangeAxisEdge());
                    rangeAxis.resizeRange2(factor, anchorY);
                } else {
                    rangeAxis.resizeRange(factor);
                }
            }
            ++i;
        }
    }

    @Override
    public void zoomRangeAxes(double lowerPercent, double upperPercent, PlotRenderingInfo state, Point2D source) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                rangeAxis.zoomRange(lowerPercent, upperPercent);
            }
            ++i;
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double value) {
        this.setAnchorValue(value, true);
    }

    public void setAnchorValue(double value, boolean notify) {
        this.anchorValue = value;
    }

    @Override
    public void rendererChanged(RendererChangeEvent event) {
    }
}

