/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.enumeration;

import com.google.code.linkedinapi.client.enumeration.CompositeEnum;
import com.google.code.linkedinapi.client.enumeration.FieldEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ProfileField implements CompositeEnum<ProfileField>
{
    ID("id", null, true),
    FIRST_NAME("first-name", null, true),
    LAST_NAME("last-name", null, true),
    HEADLINE("headline", null, true),
    LOCATION("location", null, true),
    LOCATION_NAME("name", LOCATION, true),
    LOCATION_COUNTRY("country", LOCATION, true),
    INDUSTRY("industry", null, true),
    DISTANCE("distance", null, false),
    RELATION_TO_VIEWER("relation-to-viewer", null, false),
    RELATION_TO_VIEWER_DISTANCE("distance", RELATION_TO_VIEWER, false),
    RELATION_TO_VIEWER_RELATED_CONNECTIONS("related-connections", RELATION_TO_VIEWER, false),
    RELATION_TO_VIEWER_RELATED_CONNECTIONS_FIRST_NAME("first-name", RELATION_TO_VIEWER_RELATED_CONNECTIONS, false),
    RELATION_TO_VIEWER_RELATED_CONNECTIONS_LAST_NAME("last-name", RELATION_TO_VIEWER_RELATED_CONNECTIONS, false),
    RELATION_TO_VIEWER_RELATED_CONNECTIONS_PUBLIC_PROFILE_URL("public-profile-url", RELATION_TO_VIEWER_RELATED_CONNECTIONS, false),
    RELATION_TO_VIEWER_CONNECTIONS("num-related-connections", RELATION_TO_VIEWER, false),
    CURRENT_STATUS("current-status", null, true),
    CURRENT_SHARE("current-share", null, true),
    CURRENT_STATUS_TIMESTAMP("current-status-timestamp", null, true),
    CONNECTIONS("connections", null, false),
    NUM_CONNECTIONS("num-connections", null, true),
    NUM_CONNECTIONS_CAPPED("num-connections-capped", null, true),
    SUMMARY("summary", null, false),
    SPECIALTIES("specialties", null, false),
    PROPOSAL_COMMENTS("proposal-comments", null, false),
    ASSOCIATIONS("associations", null, false),
    HONORS("honors", null, false),
    INTERESTS("interests", null, false),
    POSITIONS("positions", null, true),
    POSITIONS_ID("id", POSITIONS, true),
    POSITIONS_TITLE("title", POSITIONS, true),
    POSITIONS_SUMMARY("summary", POSITIONS, true),
    POSITIONS_START_DATE("start-date", POSITIONS, true),
    POSITIONS_END_DATE("end-date", POSITIONS, true),
    POSITIONS_IS_CURRENT("is-current", POSITIONS, true),
    POSITIONS_COMPANY("company", POSITIONS, true),
    POSITIONS_COMPANY_NAME("name", POSITIONS_COMPANY, true),
    POSITIONS_COMPANY_TYPE("type", POSITIONS_COMPANY, true),
    POSITIONS_COMPANY_SIZE("size", POSITIONS_COMPANY, true),
    POSITIONS_COMPANY_INDUSTRY("industry", POSITIONS_COMPANY, true),
    POSITIONS_COMPANY_TICKER("ticker", POSITIONS_COMPANY, true),
    PUBLICATIONS("publications", null, true),
    PUBLICATIONS_ID("id", PUBLICATIONS, true),
    PUBLICATIONS_TITLE("title", PUBLICATIONS, true),
    PUBLICATIONS_PUBLISHER("publisher", PUBLICATIONS, true),
    PUBLICATIONS_PUBLISHER_NAME("name", PUBLICATIONS_PUBLISHER, true),
    PUBLICATIONS_AUTHORS("authors", PUBLICATIONS, true),
    PUBLICATIONS_AUTHORS_ID("id", PUBLICATIONS_AUTHORS, true),
    PUBLICATIONS_AUTHORS_NAME("name", PUBLICATIONS_AUTHORS, true),
    PUBLICATIONS_AUTHORS_PERSON("person", PUBLICATIONS_AUTHORS, true),
    PUBLICATIONS_DATE("date", PUBLICATIONS, true),
    PUBLICATIONS_URL("url", PUBLICATIONS, true),
    PUBLICATIONS_SUMMARY("summary", PUBLICATIONS, true),
    PATENTS("patents", null, true),
    PATENTS_ID("id", PATENTS, true),
    PATENTS_TITLE("title", PATENTS, true),
    PATENTS_NUMBER("number", PATENTS, true),
    PATENTS_DATE("date", PATENTS, true),
    PATENTS_URL("url", PATENTS, true),
    PATENTS_SUMMARY("summary", PATENTS, true),
    PATENTS_STATUS("status", PATENTS, true),
    PATENTS_STATUS_ID("id", PATENTS_STATUS, true),
    PATENTS_STATUS_NAME("name", PATENTS_STATUS, true),
    PATENTS_OFFICE("office", PATENTS, true),
    PATENTS_OFFICE_NAME("name", PATENTS_OFFICE, true),
    PATENTS_INVENTORS("inventors", PATENTS, true),
    PATENTS_INVENTORS_ID("id", PATENTS_INVENTORS, true),
    PATENTS_INVENTORS_NAME("name", PATENTS_INVENTORS, true),
    PATENTS_INVENTORS_PERSON("person", PATENTS_INVENTORS, true),
    LANGUAGES("languages", null, true),
    LANGUAGES_ID("id", LANGUAGES, true),
    LANGUAGES_LANGUAGE("language", LANGUAGES, true),
    LANGUAGES_LANGUAGE_NAME("name", LANGUAGES_LANGUAGE, true),
    LANGUAGES_PROFICIENCY("proficiency", LANGUAGES, true),
    LANGUAGES_PROFICIENCY_LEVEL("level", LANGUAGES_PROFICIENCY, true),
    LANGUAGES_PROFICIENCY_NAME("name", LANGUAGES_PROFICIENCY, true),
    SKILLS("skills", null, true),
    SKILLS_ID("id", SKILLS, true),
    SKILLS_SKILL("skill", SKILLS, true),
    SKILLS_SKILL_NAME("name", SKILLS_SKILL, true),
    SKILLS_PROFICIENCY("proficiency", SKILLS, true),
    SKILLS_PROFICIENCY_LEVEL("level", SKILLS_PROFICIENCY, true),
    SKILLS_PROFICIENCY_NAME("name", SKILLS_PROFICIENCY, true),
    SKILLS_YEARS("years", SKILLS, true),
    SKILLS_YEARS_ID("id", SKILLS_YEARS, true),
    SKILLS_YEARS_NAME("name", SKILLS_YEARS, true),
    CERTIFICATIONS("certifications", null, true),
    CERTIFICATIONS_ID("id", CERTIFICATIONS, true),
    CERTIFICATIONS_NAME("name", CERTIFICATIONS, true),
    CERTIFICATIONS_AUTHORITY("authority", CERTIFICATIONS, true),
    CERTIFICATIONS_AUTHORITY_NAME("name", CERTIFICATIONS_AUTHORITY, true),
    CERTIFICATIONS_NUMBER("number", CERTIFICATIONS, true),
    CERTIFICATIONS_START_DATE("start-date", CERTIFICATIONS, true),
    CERTIFICATIONS_END_DATE("end-date", CERTIFICATIONS, true),
    EDUCATIONS("educations", null, true),
    EDUCATIONS_ID("id", EDUCATIONS, true),
    EDUCATIONS_SCHOOL_NAME("school-name", EDUCATIONS, true),
    EDUCATIONS_FIELD_OF_STUDY("field-of-study", EDUCATIONS, true),
    EDUCATIONS_START_DATE("start-date", EDUCATIONS, true),
    EDUCATIONS_END_DATE("end-date", EDUCATIONS, true),
    EDUCATIONS_DEGREE("degree", EDUCATIONS, true),
    EDUCATIONS_ACTIVITIES("activities", EDUCATIONS, true),
    EDUCATIONS_NOTES("notes", EDUCATIONS, true),
    THREE_CURRENT_POSITIONS("three-current-positions", null, true),
    THREE_PAST_POSITIONS("three-past-positions", null, true),
    NUM_RECOMMENDERS("num-recommenders", null, false),
    RECOMMENDATIONS_RECEIVED("recommendations-received", null, true),
    RECOMMENDATIONS_RECEIVED_ID("id", RECOMMENDATIONS_RECEIVED, true),
    RECOMMENDATIONS_RECEIVED_RECOMMENDATION_TYPE("recommendation-type", RECOMMENDATIONS_RECEIVED, true),
    RECOMMENDATIONS_RECEIVED_RECOMMENDER("recommender", RECOMMENDATIONS_RECEIVED, true),
    PHONE_NUMBERS("phone-numbers", null, true),
    IM_ACCOUNTS("im-accounts", null, true),
    TWITTER_ACCOUNTS("twitter-accounts", null, true),
    DATE_OF_BIRTH("date-of-birth", null, true),
    MAIN_ADDRESS("main-address", null, true),
    MEMBER_URL_RESOURCES("member-url-resources", null, true),
    MEMBER_URL_URL("url", MEMBER_URL_RESOURCES, false),
    MEMBER_URL_NAME("name", MEMBER_URL_RESOURCES, false),
    PICTURE_URL("picture-url", null, true),
    SITE_STANDARD_PROFILE_REQUEST("site-standard-profile-request", null, true),
    SITE_STANDARD_PROFILE_REQUEST_URL("url", SITE_STANDARD_PROFILE_REQUEST, true),
    API_STANDARD_PROFILE_REQUEST("api-standard-profile-request", null, true),
    API_STANDARD_PROFILE_REQUEST_URL("url", API_STANDARD_PROFILE_REQUEST, true),
    API_STANDARD_PROFILE_REQUEST_HEADERS("headers", API_STANDARD_PROFILE_REQUEST, true),
    PUBLIC_PROFILE_URL("public-profile-url", null, true);

    private static final Map<String, ProfileField> stringToEnum;
    private final String fieldName;
    private final ProfileField parent;
    private final boolean availableForConnections;

    static {
        stringToEnum = new HashMap<String, ProfileField>();
        ProfileField[] profileFieldArray = ProfileField.values();
        int n = profileFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileField op = profileFieldArray[n2];
            stringToEnum.put(op.fieldName(), op);
            ++n2;
        }
    }

    private ProfileField(String name, ProfileField parent, boolean availableForConnections) {
        this.fieldName = name;
        this.parent = parent;
        this.availableForConnections = availableForConnections;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public boolean isAvailableForConnections() {
        return this.availableForConnections;
    }

    public String toString() {
        return this.fieldName();
    }

    public static FieldEnum fromString(String symbol) {
        return stringToEnum.get(symbol);
    }

    public static Set<ProfileField> valuesForConnections() {
        HashSet<ProfileField> valuesForConnections = new HashSet<ProfileField>();
        ProfileField[] profileFieldArray = ProfileField.values();
        int n = profileFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileField field = profileFieldArray[n2];
            if (field.isAvailableForConnections()) {
                valuesForConnections.add(field);
            }
            ++n2;
        }
        return valuesForConnections;
    }

    @Override
    public ProfileField parent() {
        return this.parent;
    }

    public static enum Scope {
        User,
        Connections,
        All;

    }
}

