/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.impl;

import com.google.code.linkedinapi.client.LinkedInApiClient;
import com.google.code.linkedinapi.client.LinkedInApiClientException;
import com.google.code.linkedinapi.client.Parameter;
import com.google.code.linkedinapi.client.constant.ApplicationConstants;
import com.google.code.linkedinapi.client.constant.LinkedInApiUrls;
import com.google.code.linkedinapi.client.enumeration.CompanyField;
import com.google.code.linkedinapi.client.enumeration.ConnectionModificationType;
import com.google.code.linkedinapi.client.enumeration.FacetField;
import com.google.code.linkedinapi.client.enumeration.HttpMethod;
import com.google.code.linkedinapi.client.enumeration.JobField;
import com.google.code.linkedinapi.client.enumeration.NetworkUpdateType;
import com.google.code.linkedinapi.client.enumeration.ProductField;
import com.google.code.linkedinapi.client.enumeration.ProfileField;
import com.google.code.linkedinapi.client.enumeration.ProfileType;
import com.google.code.linkedinapi.client.enumeration.SearchParameter;
import com.google.code.linkedinapi.client.enumeration.SearchScope;
import com.google.code.linkedinapi.client.enumeration.SearchSortOrder;
import com.google.code.linkedinapi.client.oauth.LinkedInAccessToken;
import com.google.code.linkedinapi.client.oauth.LinkedInApiConsumer;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthService;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthServiceFactory;
import com.google.code.linkedinapi.schema.Activity;
import com.google.code.linkedinapi.schema.ApiStandardProfileRequest;
import com.google.code.linkedinapi.schema.Attribution;
import com.google.code.linkedinapi.schema.Authorization;
import com.google.code.linkedinapi.schema.Companies;
import com.google.code.linkedinapi.schema.Company;
import com.google.code.linkedinapi.schema.CompanySearch;
import com.google.code.linkedinapi.schema.Connections;
import com.google.code.linkedinapi.schema.Content;
import com.google.code.linkedinapi.schema.Error;
import com.google.code.linkedinapi.schema.FacetType;
import com.google.code.linkedinapi.schema.HttpHeader;
import com.google.code.linkedinapi.schema.InvitationRequest;
import com.google.code.linkedinapi.schema.InviteConnectType;
import com.google.code.linkedinapi.schema.Job;
import com.google.code.linkedinapi.schema.JobBookmark;
import com.google.code.linkedinapi.schema.JobBookmarks;
import com.google.code.linkedinapi.schema.JobSearch;
import com.google.code.linkedinapi.schema.JobSuggestions;
import com.google.code.linkedinapi.schema.Jobs;
import com.google.code.linkedinapi.schema.Likes;
import com.google.code.linkedinapi.schema.MailboxItem;
import com.google.code.linkedinapi.schema.Network;
import com.google.code.linkedinapi.schema.NetworkUpdateContentType;
import com.google.code.linkedinapi.schema.People;
import com.google.code.linkedinapi.schema.PeopleSearch;
import com.google.code.linkedinapi.schema.Person;
import com.google.code.linkedinapi.schema.Products;
import com.google.code.linkedinapi.schema.Recipient;
import com.google.code.linkedinapi.schema.SchemaElementFactory;
import com.google.code.linkedinapi.schema.Share;
import com.google.code.linkedinapi.schema.UpdateComment;
import com.google.code.linkedinapi.schema.UpdateComments;
import com.google.code.linkedinapi.schema.Visibility;
import com.google.code.linkedinapi.schema.VisibilityType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public abstract class BaseLinkedInApiClient
implements LinkedInApiClient {
    private static final String GZIP_ENCODING = "gzip";
    private static final Charset UTF_8_CHAR_SET = Charset.forName(ApplicationConstants.CONTENT_ENCODING);
    private final SchemaElementFactory<?> OBJECT_FACTORY = this.createObjectFactory();
    protected final Logger LOG = Logger.getLogger(this.getClass().getCanonicalName());
    private LinkedInAccessToken accessToken;
    private LinkedInApiConsumer apiConsumer;
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    protected BaseLinkedInApiClient(String consumerKey, String consumerSecret) {
        this.requestHeaders.put("Accept-Encoding", "gzip, deflate");
        this.apiConsumer = new LinkedInApiConsumer(consumerKey, consumerSecret);
    }

    @Override
    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.put(headerName, headerValue);
    }

    @Override
    public void removeRequestHeader(String headerName) {
        this.requestHeaders.remove(headerName);
    }

    @Override
    public void addLocale(Locale locale) {
    }

    @Override
    public void setApiConsumer(LinkedInApiConsumer apiConsumer) {
        this.apiConsumer = apiConsumer;
    }

    @Override
    public LinkedInApiConsumer getApiConsumer() {
        return this.apiConsumer;
    }

    @Override
    public void setAccessToken(LinkedInAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public LinkedInAccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Connections getConnectionsById(String id) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, Set<ProfileField> profileFields) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("profile fields", profileFields);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withField("id", id).withFieldEnumSet("profileFields", profileFields).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url) {
        this.assertNotNullOrEmpty("url", url);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withEmptyField("profileFields").withField("url", url, true).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, Set<ProfileField> profileFields) {
        this.assertNotNullOrEmpty("url", url);
        this.assertNotNull("profile fields", profileFields);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withField("url", url, true).withFieldEnumSet("profileFields", profileFields).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(Set<ProfileField> profileFields) {
        this.assertNotNull("profile fields", profileFields);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, int start, int count) {
        this.assertNotNullOrEmpty("id", id);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, Set<ProfileField> profileFields, int start, int count) {
        this.assertNotNullOrEmpty("id", id);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("profile fields", profileFields);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withField("id", id).withFieldEnumSet("profileFields", profileFields).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, int start, int count) {
        this.assertNotNullOrEmpty("url", url);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withEmptyField("profileFields").withField("url", url, true).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, Set<ProfileField> profileFields, int start, int count) {
        this.assertNotNullOrEmpty("url", url);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("profile fields", profileFields);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withField("url", url, true).withFieldEnumSet("profileFields", profileFields).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(int start, int count) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withEmptyField("profileFields").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(Set<ProfileField> profileFields, int start, int count) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("profile fields", profileFields);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, Set<ProfileField> profileFields, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withField("id", id).withFieldEnumSet("profileFields", profileFields).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("url", url);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withEmptyField("profileFields").withField("url", url, true).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, Set<ProfileField> profileFields, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("url", url);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withField("url", url, true).withFieldEnumSet("profileFields", profileFields).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withEmptyField("profileFields").withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(Set<ProfileField> profileFields, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, int start, int count, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("id", id);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsById(String id, Set<ProfileField> profileFields, int start, int count, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("id", id);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_ID);
        String apiUrl = builder.withField("id", id).withFieldEnumSet("profileFields", profileFields).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, int start, int count, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("url", url);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withEmptyField("profileFields").withField("url", url, true).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsByUrl(String url, Set<ProfileField> profileFields, int start, int count, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertNotNullOrEmpty("url", url);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_BY_URL);
        String apiUrl = builder.withField("url", url, true).withFieldEnumSet("profileFields", profileFields).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(int start, int count, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withEmptyField("profileFields").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Connections getConnectionsForCurrentUser(Set<ProfileField> profileFields, int start, int count, Date modificationDate, ConnectionModificationType modificationType) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("modification date", modificationDate);
        this.assertNotNull("modification type", modificationType);
        profileFields.retainAll(CONNECTION_FIELDS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_CONNECTIONS_FOR_CURRENT_USER);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("modified-since", String.valueOf(modificationDate.getTime())).withParameterEnum("modification", modificationType).buildUrl();
        return this.readResponse(Connections.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(int start, int count) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(Date startDate, Date endDate) {
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(Set<NetworkUpdateType> updateTypes) {
        this.assertNotNull("update types", updateTypes);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(Set<NetworkUpdateType> updateTypes, int start, int count) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("update types", updateTypes);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(Set<NetworkUpdateType> updateTypes, Date startDate, Date endDate) {
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(Set<NetworkUpdateType> updateTypes, int start, int count, Date startDate, Date endDate) {
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getNetworkUpdates(Set<NetworkUpdateType> updateTypes, int start, int count, Date startDate, Date endDate, boolean showHiddenMembers) {
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).withParameter("show-hidden-members", String.valueOf(showHiddenMembers)).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(int start, int count) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(Date startDate, Date endDate) {
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(Set<NetworkUpdateType> updateTypes) {
        this.assertNotNull("update types", updateTypes);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(Set<NetworkUpdateType> updateTypes, int start, int count) {
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("update types", updateTypes);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(Set<NetworkUpdateType> updateTypes, Date startDate, Date endDate) {
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(Set<NetworkUpdateType> updateTypes, int start, int count, Date startDate, Date endDate) {
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATES);
        String apiUrl = builder.withParameter("scope", "self").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id, int start, int count) {
        this.assertNotNullOrEmpty("id", id);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id, Date startDate, Date endDate) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id, Set<NetworkUpdateType> updateTypes) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("update types", updateTypes);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id, Set<NetworkUpdateType> updateTypes, int start, int count) {
        this.assertNotNullOrEmpty("id", id);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.assertNotNull("update types", updateTypes);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id, Set<NetworkUpdateType> updateTypes, Date startDate, Date endDate) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Network getUserUpdates(String id, Set<NetworkUpdateType> updateTypes, int start, int count, Date startDate, Date endDate) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("update types", updateTypes);
        this.assertNotNull("start date", startDate);
        this.assertNotNull("end date", endDate);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.USER_UPDATES);
        String apiUrl = builder.withField("id", id).withParameter("scope", "self").withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).withParameter("after", String.valueOf(startDate.getTime())).withParameter("before", String.valueOf(endDate.getTime())).withParameterEnumSet("type", updateTypes).buildUrl();
        return this.readResponse(Network.class, this.callApiMethod(apiUrl));
    }

    @Override
    public UpdateComments getNetworkUpdateComments(String networkUpdateId) {
        this.assertNotNullOrEmpty("network update id", networkUpdateId);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATE_COMMENTS);
        String apiUrl = builder.withField("updateKey", networkUpdateId).buildUrl();
        return this.readResponse(UpdateComments.class, this.callApiMethod(apiUrl));
    }

    public Person getProfileById(String id, ProfileType profileType) {
        return this.getProfileById(id);
    }

    @Override
    public Person getProfileById(String id) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_PROFILE_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).withFieldEnum("profileType", ProfileType.STANDARD).buildUrl();
        return this.readResponse(Person.class, this.callApiMethod(apiUrl));
    }

    public Person getProfileById(String id, ProfileType profileType, Set<ProfileField> profileFields) {
        return this.getProfileById(id, profileFields);
    }

    @Override
    public Person getProfileById(String id, Set<ProfileField> profileFields) {
        this.assertNotNullOrEmpty("id", id);
        this.assertNotNull("profile fields", profileFields);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_PROFILE_BY_ID);
        String apiUrl = builder.withField("id", id).withFieldEnum("profileType", ProfileType.STANDARD).withFieldEnumSet("profileFields", profileFields).buildUrl();
        return this.readResponse(Person.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Person getProfileByUrl(String url, ProfileType profileType) {
        this.assertNotNullOrEmpty("url", url);
        this.assertNotNull("profile type", profileType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_PROFILE_BY_URL);
        String apiUrl = builder.withEmptyField("profileFields").withField("url", url, true).withFieldEnum("profileType", profileType).buildUrl();
        return this.readResponse(Person.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Person getProfileByUrl(String url, ProfileType profileType, Set<ProfileField> profileFields) {
        this.assertNotNullOrEmpty("url", url);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("profile type", profileType);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_PROFILE_BY_URL);
        String apiUrl = builder.withField("url", url, true).withFieldEnum("profileType", profileType).withFieldEnumSet("profileFields", profileFields).buildUrl();
        return this.readResponse(Person.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Person getProfileForCurrentUser() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_PROFILE_FOR_CURRENT_USER);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        return this.readResponse(Person.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Person getProfileForCurrentUser(Set<ProfileField> profileFields) {
        this.assertNotNull("profile fields", profileFields);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_PROFILE_FOR_CURRENT_USER);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).buildUrl();
        return this.readResponse(Person.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Person getProfileByApiRequest(ApiStandardProfileRequest apiRequest) {
        this.assertNotNull("api request", apiRequest);
        if (apiRequest.getHeaders() != null) {
            return this.readResponse(Person.class, this.callApiMethod(apiRequest.getUrl(), apiRequest.getHeaders().getHttpHeaderList()));
        }
        return this.readResponse(Person.class, this.callApiMethod(apiRequest.getUrl()));
    }

    @Override
    public void postComment(String networkUpdateId, String commentText) {
        this.assertNotNullOrEmpty("network update id", networkUpdateId);
        this.assertNotNullOrEmpty("comment", commentText);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.POST_COMMENT);
        String apiUrl = builder.withField("updateKey", networkUpdateId).buildUrl();
        UpdateComment comment = this.OBJECT_FACTORY.createUpdateComment();
        comment.setComment(commentText);
        this.callApiMethod(apiUrl, this.marshallObject(comment), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public void postNetworkUpdate(String updateText) {
        this.assertNotNullOrEmpty("network update", updateText);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.POST_UPDATE);
        String apiUrl = builder.buildUrl();
        Activity update = this.OBJECT_FACTORY.createActivity();
        update.setBody(updateText);
        update.setLocale(Locale.getDefault().toString());
        update.setContentType(NetworkUpdateContentType.LINKED_IN_HTML);
        update.setTimestamp(System.currentTimeMillis());
        this.callApiMethod(apiUrl, this.marshallObject(update), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public People searchPeople() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters) {
        this.assertNotNull("search parameters", searchParameters);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("profile fields", profileFields);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public People searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        PeopleSearch response = this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getPeople();
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public PeopleSearch searchPeople(Map<SearchParameter, String> searchParameters, Set<ProfileField> profileFields, Set<FacetField> facetFields, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("profile fields", profileFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.PEOPLE);
        this.filterFacets(facets, PEOPLE_FACETS, SearchScope.PEOPLE);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_PEOPLE_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", profileFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(PeopleSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public void sendInviteByEmail(String email, String firstName, String lastName, String subject, String message) {
        this.assertNotNullOrEmpty("email", email);
        this.assertNotNullOrEmpty("firstName", firstName);
        this.assertNotNullOrEmpty("lastName", lastName);
        this.assertNotNullOrEmpty("subject", subject);
        this.assertNotNullOrEmpty("message", message);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEND_MESSAGE);
        String apiUrl = builder.buildUrl();
        MailboxItem invite = this.OBJECT_FACTORY.createMailboxItem();
        invite.setBody(message);
        invite.setSubject(subject);
        invite.setRecipients(this.OBJECT_FACTORY.createRecipients());
        Person person = this.OBJECT_FACTORY.createPerson();
        person.setPath(this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEND_INVITE_EMAIL_PERSON_PATH).withField("email", email).buildUrl());
        person.setFirstName(firstName);
        person.setLastName(lastName);
        Recipient recepient = this.OBJECT_FACTORY.createRecipient();
        recepient.setPerson(person);
        invite.getRecipients().getRecipientList().add(recepient);
        invite.setItemContent(this.OBJECT_FACTORY.createItemContent());
        InvitationRequest request = this.OBJECT_FACTORY.createInvitationRequest();
        request.setConnectType(InviteConnectType.FRIEND);
        invite.getItemContent().setInvitationRequest(request);
        this.callApiMethod(apiUrl, this.marshallObject(invite), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public void sendInviteById(String recepientId, String subject, String message, String authHeader) {
        this.assertNotNullOrEmpty("recepient id", recepientId);
        this.assertNotNullOrEmpty("subject", subject);
        this.assertNotNullOrEmpty("message", message);
        this.assertNotNullOrEmpty("auth header", authHeader);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEND_MESSAGE);
        String apiUrl = builder.buildUrl();
        MailboxItem invite = this.OBJECT_FACTORY.createMailboxItem();
        invite.setBody(message);
        invite.setSubject(subject);
        invite.setRecipients(this.OBJECT_FACTORY.createRecipients());
        Person person = this.OBJECT_FACTORY.createPerson();
        person.setPath(this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEND_INVITE_ID_PERSON_PATH).withField("id", recepientId).buildUrl());
        Recipient recepient = this.OBJECT_FACTORY.createRecipient();
        recepient.setPerson(person);
        invite.getRecipients().getRecipientList().add(recepient);
        invite.setItemContent(this.OBJECT_FACTORY.createItemContent());
        InvitationRequest request = this.OBJECT_FACTORY.createInvitationRequest();
        request.setConnectType(InviteConnectType.FRIEND);
        String[] authTuple = authHeader.split(":");
        if (authTuple.length == 2) {
            Authorization authorization = this.OBJECT_FACTORY.createAuthorization();
            authorization.setName(authTuple[0]);
            authorization.setValue(authTuple[1]);
            request.setAuthorization(authorization);
        }
        invite.getItemContent().setInvitationRequest(request);
        this.callApiMethod(apiUrl, this.marshallObject(invite), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public void sendInviteToPerson(Person recepient, String subject, String message) {
        this.assertNotNull("recepient", recepient);
        this.assertNotNull("recepient api request", recepient.getApiStandardProfileRequest());
        String authHeader = null;
        if (recepient.getApiStandardProfileRequest().getHeaders() != null) {
            for (HttpHeader header : recepient.getApiStandardProfileRequest().getHeaders().getHttpHeaderList()) {
                if (!ApplicationConstants.AUTH_HEADER_NAME.equals(header.getName())) continue;
                authHeader = header.getValue();
                break;
            }
        }
        this.sendInviteById(recepient.getId(), subject, message, authHeader);
    }

    @Override
    public void sendMessage(List<String> recepientIds, String subject, String message) {
        this.assertNotNullOrEmpty("recepient ids", recepientIds);
        this.assertNotNullOrEmpty("subject", subject);
        this.assertNotNullOrEmpty("message", message);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEND_MESSAGE);
        String apiUrl = builder.buildUrl();
        MailboxItem messageItem = this.OBJECT_FACTORY.createMailboxItem();
        messageItem.setBody(message);
        messageItem.setSubject(subject);
        messageItem.setRecipients(this.OBJECT_FACTORY.createRecipients());
        for (String recepientId : recepientIds) {
            Person person = this.OBJECT_FACTORY.createPerson();
            person.setPath(this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEND_MESSAGE_PERSON_PATH).withField("id", recepientId).buildUrl());
            Recipient recepient = this.OBJECT_FACTORY.createRecipient();
            recepient.setPerson(person);
            messageItem.getRecipients().getRecipientList().add(recepient);
        }
        this.callApiMethod(apiUrl, this.marshallObject(messageItem), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    @Deprecated
    public void updateCurrentStatus(String statusText) {
        this.updateCurrentStatus(statusText, false);
    }

    @Override
    @Deprecated
    public void updateCurrentStatus(String statusText, boolean postToTwitter) {
        if (this.isNullOrEmpty(statusText)) {
            this.deleteCurrentStatus();
        } else {
            LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.POST_STATUS);
            if (postToTwitter) {
                builder.withParameter("twitter-post", "true");
            }
            String apiUrl = builder.buildUrl();
            Object status = this.OBJECT_FACTORY.createCurrentStatus(statusText);
            this.callApiMethod(apiUrl, this.marshallObject(status), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.PUT, 204);
        }
    }

    @Override
    public void deleteCurrentStatus() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.POST_STATUS);
        String apiUrl = builder.buildUrl();
        this.callApiMethod(apiUrl, null, null, HttpMethod.DELETE, 204);
    }

    @Override
    public Likes getNetworkUpdateLikes(String networkUpdateId) {
        this.assertNotNullOrEmpty("network update id", networkUpdateId);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATE_LIKES);
        String apiUrl = builder.withField("updateKey", networkUpdateId).buildUrl();
        return this.readResponse(Likes.class, this.callApiMethod(apiUrl));
    }

    @Override
    public void likePost(String networkUpdateId) {
        this.assertNotNullOrEmpty("network update id", networkUpdateId);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATE_LIKE);
        String apiUrl = builder.withField("updateKey", networkUpdateId).buildUrl();
        Object share = this.OBJECT_FACTORY.createIsLiked(true);
        this.callApiMethod(apiUrl, this.marshallObject(share), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.PUT, 201);
    }

    @Override
    public void postShare(String commentText, String title, String url, String imageUrl, VisibilityType visibility) {
        this.postShare(commentText, title, null, url, imageUrl, visibility, false);
    }

    @Override
    public void postShare(String commentText, String title, String url, String imageUrl, VisibilityType visibilityType, boolean postToTwitter) {
        this.postShare(commentText, title, null, url, imageUrl, visibilityType, postToTwitter);
    }

    @Override
    public void postShare(String commentText, String title, String description, String url, String imageUrl, VisibilityType visibilityType) {
        this.postShare(commentText, title, description, url, imageUrl, visibilityType, false);
    }

    @Override
    public void postShare(String commentText, String title, String description, String url, String imageUrl, VisibilityType visibilityType, boolean postToTwitter) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.POST_SHARE);
        if (postToTwitter) {
            builder.withParameter("twitter-post", "true");
        }
        String apiUrl = builder.buildUrl();
        Share share = this.OBJECT_FACTORY.createShare();
        share.setComment(commentText);
        Content content = this.OBJECT_FACTORY.createContent();
        content.setSubmittedUrl(url);
        content.setSubmittedImageUrl(imageUrl);
        content.setTitle(title);
        content.setDescription(description);
        share.setContent(content);
        Visibility visibility = this.OBJECT_FACTORY.createVisibility();
        visibility.setCode(visibilityType);
        share.setVisibility(visibility);
        this.callApiMethod(apiUrl, this.marshallObject(share), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public void reShare(String shareId, String commentText, VisibilityType visibilityType) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.RE_SHARE);
        String apiUrl = builder.buildUrl();
        Share share = this.OBJECT_FACTORY.createShare();
        share.setComment(commentText);
        Attribution attribution = this.OBJECT_FACTORY.createAttribution();
        Share refShare = this.OBJECT_FACTORY.createShare();
        refShare.setId(shareId);
        attribution.setShare(refShare);
        share.setAttribution(attribution);
        Visibility visibility = this.OBJECT_FACTORY.createVisibility();
        visibility.setCode(visibilityType);
        share.setVisibility(visibility);
        this.callApiMethod(apiUrl, this.marshallObject(share), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public void unlikePost(String networkUpdateId) {
        this.assertNotNullOrEmpty("network update id", networkUpdateId);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.NETWORK_UPDATE_LIKE);
        String apiUrl = builder.withField("updateKey", networkUpdateId).buildUrl();
        Object share = this.OBJECT_FACTORY.createIsLiked(false);
        this.callApiMethod(apiUrl, this.marshallObject(share), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.PUT, 201);
    }

    @Override
    public void bookmarkJob(String jobId) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.BOOKMARK_JOB);
        String apiUrl = builder.buildUrl();
        JobBookmark bookmark = this.OBJECT_FACTORY.createJobBookmark();
        Job job = this.OBJECT_FACTORY.createJob();
        job.setId(jobId);
        bookmark.setJob(job);
        this.callApiMethod(apiUrl, this.marshallObject(bookmark), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public void closeJob(String partnerJobId) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.CLOSE_JOB);
        String apiUrl = builder.withField("id", partnerJobId).buildUrl();
        this.callApiMethod(apiUrl, null, null, HttpMethod.DELETE, 200);
    }

    @Override
    public JobBookmarks getJobBookmarks() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_JOB_BOOKMARKS);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        return this.readResponse(JobBookmarks.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobBookmarks getJobBookmarks(Set<JobField> jobFields) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_JOB_BOOKMARKS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).buildUrl();
        return this.readResponse(JobBookmarks.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Job getJobById(String id) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_JOB_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).buildUrl();
        return this.readResponse(Job.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Job getJobById(String id, Set<JobField> jobFields) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_JOB_BY_ID);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withField("id", id).buildUrl();
        return this.readResponse(Job.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Jobs getJobSuggestions() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_JOB_SUGGESTIONS);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        JobSuggestions response = this.readResponse(JobSuggestions.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs getJobSuggestions(Set<JobField> jobFields) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_JOB_SUGGESTIONS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).buildUrl();
        JobSuggestions response = this.readResponse(JobSuggestions.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public void postJob(Job job) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.POST_JOB);
        String apiUrl = builder.buildUrl();
        this.callApiMethod(apiUrl, this.marshallObject(job), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 200);
    }

    @Override
    public void renewJob(String partnerJobId, String contractId) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.RENEW_JOB);
        String apiUrl = builder.withField("id", partnerJobId).buildUrl();
        Job job = this.OBJECT_FACTORY.createJob();
        job.setContractId(Long.parseLong(contractId));
        job.setRenewal(this.OBJECT_FACTORY.createRenewal());
        this.callApiMethod(apiUrl, this.marshallObject(job), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.PUT, 200);
    }

    @Override
    public Jobs searchJobs() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters) {
        this.assertNotNull("search parameters", searchParameters);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("job fields", jobFields);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public Jobs searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        JobSearch response = this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getJobs();
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public JobSearch searchJobs(Map<SearchParameter, String> searchParameters, Set<JobField> jobFields, Set<FacetField> facetFields, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("job fields", jobFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.JOBS);
        this.filterFacets(facets, JOB_FACETS, SearchScope.JOBS);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_JOBS_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", jobFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(JobSearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public void unbookmarkJob(String jobId) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.UNBOOKMARK_JOB);
        String apiUrl = builder.withField("id", jobId).buildUrl();
        this.callApiMethod(apiUrl, null, null, HttpMethod.DELETE, 204);
    }

    @Override
    public void updateJob(String partnerJobId, Job job) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.RENEW_JOB);
        String apiUrl = builder.withField("id", partnerJobId).buildUrl();
        this.callApiMethod(apiUrl, this.marshallObject(job), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.PUT, 200);
    }

    @Override
    public void followCompany(String id) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.FOLLOW_COMPANY);
        String apiUrl = builder.buildUrl();
        Company company = this.OBJECT_FACTORY.createCompany();
        company.setId(id);
        this.callApiMethod(apiUrl, this.marshallObject(company), ApplicationConstants.CONTENT_TYPE_XML, HttpMethod.POST, 201);
    }

    @Override
    public Companies getCompaniesByEmailDomain(String emailDomain) {
        this.assertNotNullOrEmpty("email domain", emailDomain);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANIES_BY_EMAIL_DOMAIN);
        String apiUrl = builder.withEmptyField("profileFields").withField("email", emailDomain).buildUrl();
        return this.readResponse(Companies.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Companies getCompaniesByEmailDomain(String emailDomain, Set<CompanyField> companyFields) {
        this.assertNotNullOrEmpty("email domain", emailDomain);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANIES_BY_EMAIL_DOMAIN);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withField("email", emailDomain).buildUrl();
        return this.readResponse(Companies.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Company getCompanyById(String id) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_BY_ID);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).buildUrl();
        return this.readResponse(Company.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Company getCompanyById(String id, Set<CompanyField> companyFields) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_BY_ID);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withField("id", id).buildUrl();
        return this.readResponse(Company.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Company getCompanyByUniversalName(String universalName) {
        this.assertNotNullOrEmpty("universal name", universalName);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_BY_UNIVERSAL_NAME);
        String apiUrl = builder.withEmptyField("profileFields").withField("name", universalName).buildUrl();
        return this.readResponse(Company.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Company getCompanyByUniversalName(String universalName, Set<CompanyField> companyFields) {
        this.assertNotNullOrEmpty("universal name", universalName);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_BY_UNIVERSAL_NAME);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withField("name", universalName).buildUrl();
        return this.readResponse(Company.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Products getCompanyProducts(String id) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_PRODUCTS);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).buildUrl();
        return this.readResponse(Products.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Products getCompanyProducts(String id, Set<ProductField> productFields) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_PRODUCTS);
        String apiUrl = builder.withFieldEnumSet("profileFields", productFields).withField("id", id).buildUrl();
        return this.readResponse(Products.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Products getCompanyProducts(String id, int start, int count) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_PRODUCTS);
        String apiUrl = builder.withEmptyField("profileFields").withField("id", id).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Products.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Products getCompanyProducts(String id, Set<ProductField> productFields, int start, int count) {
        this.assertNotNullOrEmpty("id", id);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_COMPANY_PRODUCTS);
        String apiUrl = builder.withFieldEnumSet("profileFields", productFields).withField("id", id).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(Products.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Companies getFollowedCompanies() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_FOLLOWED_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        return this.readResponse(Companies.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Companies getFollowedCompanies(Set<CompanyField> companyFields) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_FOLLOWED_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).buildUrl();
        return this.readResponse(Companies.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Companies getSuggestedCompanies() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_SUGGESTED_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        return this.readResponse(Companies.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Companies getSuggestedCompanies(Set<CompanyField> companyFields) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.GET_SUGGESTED_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).buildUrl();
        return this.readResponse(Companies.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Companies searchCompanies() {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters) {
        this.assertNotNull("search parameters", searchParameters);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withEmptyField("profileFields").withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("company fields", companyFields);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public Companies searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        CompanySearch response = this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
        return response == null ? null : response.getCompanies();
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, int start, int count) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, int start, int count, SearchSortOrder sortOrder) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, int start, int count, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertNotNull("sort order", sortOrder);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public CompanySearch searchCompanies(Map<SearchParameter, String> searchParameters, Set<CompanyField> companyFields, Set<FacetField> facetFields, int start, int count, SearchSortOrder sortOrder, List<Parameter<FacetType, String>> facets) {
        this.assertNotNull("search parameters", searchParameters);
        this.assertNotNull("company fields", companyFields);
        this.assertNotNull("facet fields", facetFields);
        this.assertNotNullOrEmpty("facets", facets);
        this.assertPositiveNumber("start", start);
        this.assertPositiveNumber("count", count);
        this.filterSearchParameters(searchParameters, SearchScope.COMPANIES);
        this.filterFacets(facets, COMPANY_FACETS, SearchScope.COMPANIES);
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.SEARCH_COMPANIES_FACETS);
        String apiUrl = builder.withFieldEnumSet("profileFields", companyFields).withFieldEnumSet("facetFields", facetFields).withParameterEnumMap(searchParameters).withFacets(facets).withParameterEnum("sort", sortOrder).withParameter("start", String.valueOf(start)).withParameter("count", String.valueOf(count)).buildUrl();
        return this.readResponse(CompanySearch.class, this.callApiMethod(apiUrl));
    }

    @Override
    public void unfollowCompany(String id) {
        LinkedInApiUrls.LinkedInApiUrlBuilder builder = this.createLinkedInApiUrlBuilder(LinkedInApiUrls.UNFOLLOW_COMPANY);
        String apiUrl = builder.withField("id", id).buildUrl();
        this.callApiMethod(apiUrl, null, null, HttpMethod.DELETE, 204);
    }

    protected <T> T readResponse(Class<T> clazz, InputStream is) {
        try {
            T t = this.unmarshallObject(clazz, is);
            return t;
        }
        finally {
            this.closeStream(is);
        }
    }

    protected InputStream callApiMethod(String apiUrl) {
        List<HttpHeader> httpHeaders = Collections.emptyList();
        return this.callApiMethod(apiUrl, 200, httpHeaders);
    }

    protected InputStream callApiMethod(String apiUrl, List<HttpHeader> httpHeaders) {
        return this.callApiMethod(apiUrl, 200, httpHeaders);
    }

    protected InputStream callApiMethod(String apiUrl, int expected, List<HttpHeader> httpHeaders) {
        try {
            LinkedInOAuthService oAuthService = LinkedInOAuthServiceFactory.getInstance().createLinkedInOAuthService(this.apiConsumer.getConsumerKey(), this.apiConsumer.getConsumerSecret());
            URL url = new URL(apiUrl);
            HttpURLConnection request = (HttpURLConnection)url.openConnection();
            if (ApplicationConstants.CONNECT_TIMEOUT > -1) {
                request.setConnectTimeout(ApplicationConstants.CONNECT_TIMEOUT);
            }
            if (ApplicationConstants.READ_TIMEOUT > -1) {
                request.setReadTimeout(ApplicationConstants.READ_TIMEOUT);
            }
            for (String headerName : this.requestHeaders.keySet()) {
                request.setRequestProperty(headerName, this.requestHeaders.get(headerName));
            }
            for (HttpHeader header : httpHeaders) {
                request.setRequestProperty(header.getName(), header.getValue());
            }
            oAuthService.signRequestWithToken(request, this.accessToken);
            request.connect();
            if (request.getResponseCode() != expected) {
                Error error = this.readResponse(Error.class, this.getWrappedInputStream(request.getErrorStream(), GZIP_ENCODING.equalsIgnoreCase(request.getContentEncoding())));
                throw this.createLinkedInApiClientException(error);
            }
            return this.getWrappedInputStream(request.getInputStream(), GZIP_ENCODING.equalsIgnoreCase(request.getContentEncoding()));
        }
        catch (IOException e) {
            throw new LinkedInApiClientException(e);
        }
    }

    protected InputStream callApiMethod(String apiUrl, String xmlContent, String contentType, HttpMethod method, int expected) {
        try {
            LinkedInOAuthService oAuthService = LinkedInOAuthServiceFactory.getInstance().createLinkedInOAuthService(this.apiConsumer.getConsumerKey(), this.apiConsumer.getConsumerSecret());
            URL url = new URL(apiUrl);
            HttpURLConnection request = (HttpURLConnection)url.openConnection();
            if (ApplicationConstants.CONNECT_TIMEOUT > -1) {
                request.setConnectTimeout(ApplicationConstants.CONNECT_TIMEOUT);
            }
            if (ApplicationConstants.READ_TIMEOUT > -1) {
                request.setReadTimeout(ApplicationConstants.READ_TIMEOUT);
            }
            for (String headerName : this.requestHeaders.keySet()) {
                request.setRequestProperty(headerName, this.requestHeaders.get(headerName));
            }
            request.setRequestMethod(method.fieldName());
            request.setDoOutput(true);
            oAuthService.signRequestWithToken(request, this.accessToken);
            if (contentType != null) {
                request.setRequestProperty("Content-Type", contentType);
            }
            if (xmlContent != null) {
                PrintWriter out = new PrintWriter(new OutputStreamWriter(request.getOutputStream(), UTF_8_CHAR_SET));
                out.print(xmlContent);
                out.flush();
                out.close();
            }
            request.connect();
            if (request.getResponseCode() != expected) {
                Error error = this.readResponse(Error.class, this.getWrappedInputStream(request.getErrorStream(), GZIP_ENCODING.equalsIgnoreCase(request.getContentEncoding())));
                throw this.createLinkedInApiClientException(error);
            }
            return this.getWrappedInputStream(request.getInputStream(), GZIP_ENCODING.equalsIgnoreCase(request.getContentEncoding()));
        }
        catch (IOException e) {
            throw new LinkedInApiClientException(e);
        }
    }

    protected void closeStream(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            this.LOG.log(Level.SEVERE, "An error occurred while closing stream.", e);
        }
    }

    protected void closeConnection(HttpURLConnection connection) {
        try {
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "An error occurred while disconnecting connection.", e);
        }
    }

    protected LinkedInApiClientException createLinkedInApiClientException(Error error) {
        String message = error.getMessage();
        String errorCode = error.getErrorCode();
        String requestId = error.getRequestId();
        int statusCode = error.getStatus() == null ? 0 : error.getStatus().intValue();
        Date timestamp = error.getTimestamp() == null ? new Date() : new Date(error.getTimestamp());
        return new LinkedInApiClientException(message, statusCode, errorCode, timestamp, requestId);
    }

    protected InputStream getWrappedInputStream(InputStream is, boolean gzip) throws IOException {
        if (gzip) {
            return new BufferedInputStream(new GZIPInputStream(is));
        }
        return new BufferedInputStream(is);
    }

    protected boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void assertNotNullOrEmpty(String name, String value) {
        if (this.isNullOrEmpty(value)) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null or empty.");
        }
    }

    protected void assertNotNullOrEmpty(String name, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null or empty.");
        }
    }

    protected void assertPositiveNumber(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be less than zero.");
        }
    }

    protected void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null.");
        }
    }

    protected void filterSearchParameters(Map<SearchParameter, String> searchParameters, SearchScope scope) {
        Iterator<SearchParameter> iter = searchParameters.keySet().iterator();
        while (iter.hasNext()) {
            SearchParameter parameter = iter.next();
            if (parameter.hasScope(scope)) continue;
            this.LOG.warning("Parameter " + parameter + " is not valid for scope " + scope + ". It will be dropped from the criteria.");
            iter.remove();
        }
    }

    protected void filterFacets(List<Parameter<FacetType, String>> facets, Set<FacetType> allowedFacets, SearchScope scope) {
        Iterator<Parameter<FacetType, String>> iter = facets.iterator();
        while (iter.hasNext()) {
            Parameter<FacetType, String> facet = iter.next();
            if (allowedFacets.contains((Object)facet.getName())) continue;
            this.LOG.warning("Facet " + (Object)((Object)facet.getName()) + " is not valid for scope " + scope + ". It will be dropped from the criteria.");
            iter.remove();
        }
    }

    protected static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    protected abstract <T> T unmarshallObject(Class<T> var1, InputStream var2);

    protected abstract String marshallObject(Object var1);

    protected abstract LinkedInApiUrls.LinkedInApiUrlBuilder createLinkedInApiUrlBuilder(String var1);

    protected abstract SchemaElementFactory<?> createObjectFactory();
}

