/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.constant;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApplicationConstants {
    public static final String APP_CONSTANTS_FILE = "ApplicationConstants.properties";
    private static final Logger LOG = Logger.getLogger(ApplicationConstants.class.getCanonicalName());
    private static final Properties applicationConstants = new Properties();
    public static final boolean VALIDATE_XML;
    public static final String OAUTH_VERSION;
    public static final int DEFAULT_RESULT_SIZE;
    public static final String CONTENT_TYPE_XML;
    public static final String CONTENT_ENCODING;
    public static final String CLIENT_DEFAULT_IMPL;
    public static final int CONNECT_TIMEOUT;
    public static final int READ_TIMEOUT;
    public static final String AUTH_HEADER_NAME;
    public static final String FORMAT_HEADER_NAME;
    public static final String EXPIRATION_PARAMETER_NAME;

    static {
        try {
            applicationConstants.load(ApplicationConstants.class.getResourceAsStream(APP_CONSTANTS_FILE));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "An error occurred while loading properties.", e);
        }
        VALIDATE_XML = ApplicationConstants.getBooleanProperty("com.google.code.linkedinapi.client.validateXml");
        OAUTH_VERSION = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.oauthVersion");
        DEFAULT_RESULT_SIZE = ApplicationConstants.getIntProperty("com.google.code.linkedinapi.client.defaultResultSize");
        CONTENT_TYPE_XML = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.contentTypeXml");
        CONTENT_ENCODING = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.encoding");
        CLIENT_DEFAULT_IMPL = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.defaultImpl");
        CONNECT_TIMEOUT = ApplicationConstants.getIntProperty("com.google.code.linkedinapi.client.connectTimeout");
        READ_TIMEOUT = ApplicationConstants.getIntProperty("com.google.code.linkedinapi.client.readTimeout");
        AUTH_HEADER_NAME = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.authHeaderName");
        FORMAT_HEADER_NAME = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.formatHeaderName");
        EXPIRATION_PARAMETER_NAME = ApplicationConstants.getProperty("com.google.code.linkedinapi.client.expirationParameterName");
    }

    private ApplicationConstants() {
    }

    public static String getProperty(String key) {
        return applicationConstants.getProperty(key);
    }

    public static int getIntProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return 0;
        }
        return Integer.parseInt(property);
    }

    public static boolean getBooleanProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return false;
        }
        return Boolean.parseBoolean(property);
    }

    public static double getDoubleProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return 0.0;
        }
        return Double.parseDouble(property);
    }

    public static long getLongProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return 0L;
        }
        return Long.parseLong(property);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

