/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.constant;

import com.google.code.linkedinapi.client.Parameter;
import com.google.code.linkedinapi.client.constant.ApplicationConstants;
import com.google.code.linkedinapi.client.enumeration.CompositeEnum;
import com.google.code.linkedinapi.client.enumeration.FieldEnum;
import com.google.code.linkedinapi.client.enumeration.SearchParameter;
import com.google.code.linkedinapi.schema.FacetType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LinkedInApiUrls {
    public static final String API_URLS_FILE = "LinkedInApiUrls.properties";
    private static final Logger LOG = Logger.getLogger(LinkedInApiUrls.class.getCanonicalName());
    private static final Properties linkedInApiUrls = new Properties();
    public static final String GET_PROFILE_FOR_CURRENT_USER;
    public static final String GET_PROFILE_BY_ID;
    public static final String GET_PROFILE_BY_URL;
    public static final String SEARCH_PEOPLE;
    public static final String SEARCH_FACETS;
    public static final String SEARCH_PEOPLE_FACETS;
    public static final String POST_UPDATE;
    public static final String POST_STATUS;
    public static final String POST_COMMENT;
    public static final String SEND_MESSAGE;
    public static final String LINKED_IN_OAUTH_REQUEST_TOKEN_URL;
    public static final String LINKED_IN_OAUTH_AUTHORIZE_URL;
    public static final String LINKED_IN_OAUTH_ACCESS_TOKEN_URL;
    public static final String LINKED_IN_OAUTH_INVALIDATE_TOKEN_URL;
    public static final String NETWORK_UPDATES;
    public static final String USER_UPDATES;
    public static final String NETWORK_UPDATE_COMMENTS;
    public static final String NETWORK_UPDATE_LIKES;
    public static final String NETWORK_UPDATE_LIKE;
    public static final String GET_CONNECTIONS_FOR_CURRENT_USER;
    public static final String GET_CONNECTIONS_BY_ID;
    public static final String GET_CONNECTIONS_BY_EMAIL;
    public static final String GET_CONNECTIONS_BY_URL;
    public static final String SEND_MESSAGE_PERSON_PATH;
    public static final String SEND_INVITE_ID_PERSON_PATH;
    public static final String SEND_INVITE_EMAIL_PERSON_PATH;
    public static final String POST_SHARE;
    public static final String RE_SHARE;
    public static final String GET_COMPANY_BY_ID;
    public static final String GET_COMPANY_BY_UNIVERSAL_NAME;
    public static final String GET_COMPANIES_BY_EMAIL_DOMAIN;
    public static final String SEARCH_COMPANIES;
    public static final String SEARCH_FACETS_FOR_COMPANIES;
    public static final String SEARCH_COMPANIES_FACETS;
    public static final String GET_FOLLOWED_COMPANIES;
    public static final String GET_SUGGESTED_COMPANIES;
    public static final String FOLLOW_COMPANY;
    public static final String UNFOLLOW_COMPANY;
    public static final String GET_COMPANY_PRODUCTS;
    public static final String GET_JOB_BY_ID;
    public static final String SEARCH_JOBS;
    public static final String SEARCH_FACETS_FOR_JOBS;
    public static final String SEARCH_JOBS_FACETS;
    public static final String GET_JOB_BOOKMARKS;
    public static final String BOOKMARK_JOB;
    public static final String UNBOOKMARK_JOB;
    public static final String GET_JOB_SUGGESTIONS;
    public static final String POST_JOB;
    public static final String EDIT_JOB;
    public static final String RENEW_JOB;
    public static final String CLOSE_JOB;

    static {
        try {
            linkedInApiUrls.load(LinkedInApiUrls.class.getResourceAsStream(API_URLS_FILE));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "An error occurred while loading urls.", e);
        }
        GET_PROFILE_FOR_CURRENT_USER = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getProfileForCurrentUser");
        GET_PROFILE_BY_ID = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getProfileById");
        GET_PROFILE_BY_URL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getProfileByUrl");
        SEARCH_PEOPLE = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchPeople");
        SEARCH_FACETS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchFacets");
        SEARCH_PEOPLE_FACETS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchPeopleFacets");
        POST_UPDATE = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.postUpdate");
        POST_STATUS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.postStatus");
        POST_COMMENT = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.postComment");
        SEND_MESSAGE = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.sendMessage");
        LINKED_IN_OAUTH_REQUEST_TOKEN_URL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.oauth.requestToken");
        LINKED_IN_OAUTH_AUTHORIZE_URL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.oauth.authorize");
        LINKED_IN_OAUTH_ACCESS_TOKEN_URL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.oauth.accessToken");
        LINKED_IN_OAUTH_INVALIDATE_TOKEN_URL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.oauth.invalidateToken");
        NETWORK_UPDATES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.networkUpdates");
        USER_UPDATES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.userUpdates");
        NETWORK_UPDATE_COMMENTS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.networkUpdateComments");
        NETWORK_UPDATE_LIKES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.networkUpdateLikes");
        NETWORK_UPDATE_LIKE = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.networkUpdateLike");
        GET_CONNECTIONS_FOR_CURRENT_USER = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getConnectionsForCurrentUser");
        GET_CONNECTIONS_BY_ID = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getConnectionsById");
        GET_CONNECTIONS_BY_EMAIL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getConnectionsByEmail");
        GET_CONNECTIONS_BY_URL = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getConnectionsByUrl");
        SEND_MESSAGE_PERSON_PATH = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.messagePersonPath");
        SEND_INVITE_ID_PERSON_PATH = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.inviteIdPersonPath");
        SEND_INVITE_EMAIL_PERSON_PATH = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.inviteEmailPersonPath");
        POST_SHARE = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.postShare");
        RE_SHARE = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.reShare");
        GET_COMPANY_BY_ID = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getCompanyById");
        GET_COMPANY_BY_UNIVERSAL_NAME = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getCompanyByUniversalName");
        GET_COMPANIES_BY_EMAIL_DOMAIN = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getCompaniesByEmailDomain");
        SEARCH_COMPANIES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchCompanies");
        SEARCH_FACETS_FOR_COMPANIES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchFacetsForCompanies");
        SEARCH_COMPANIES_FACETS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchCompaniesAndFacets");
        GET_FOLLOWED_COMPANIES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getFollowedCompanies");
        GET_SUGGESTED_COMPANIES = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getSuggestedCompanies");
        FOLLOW_COMPANY = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.followCompany");
        UNFOLLOW_COMPANY = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.unfollowCompany");
        GET_COMPANY_PRODUCTS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getCompanyProducts");
        GET_JOB_BY_ID = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getJobById");
        SEARCH_JOBS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchJobs");
        SEARCH_FACETS_FOR_JOBS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchFacetsForJobs");
        SEARCH_JOBS_FACETS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.searchJobsAndFacets");
        GET_JOB_BOOKMARKS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getJobBookmarks");
        BOOKMARK_JOB = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.bookmarkJob");
        UNBOOKMARK_JOB = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.unbookmarkJob");
        GET_JOB_SUGGESTIONS = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.getJobSuggestions");
        POST_JOB = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.postJob");
        EDIT_JOB = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.editJob");
        RENEW_JOB = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.renewJob");
        CLOSE_JOB = linkedInApiUrls.getProperty("com.google.code.linkedinapi.client.closeJob");
    }

    private LinkedInApiUrls() {
    }

    public static class LinkedInApiUrlBuilder {
        private static final char API_URLS_PLACEHOLDER_START = '{';
        private static final char API_URLS_PLACEHOLDER_END = '}';
        private static final String QUERY_PARAMETERS_PLACEHOLDER = "queryParameters";
        private String urlFormat;
        private String urlType;
        private Map<String, Collection<String>> parametersMap = new HashMap<String, Collection<String>>();
        private Map<String, String> fieldsMap = new HashMap<String, String>();

        public LinkedInApiUrlBuilder(String urlFormat) {
            this.urlFormat = urlFormat;
        }

        public LinkedInApiUrlBuilder(String urlFormat, String urlType) {
            this.urlFormat = urlFormat;
            this.urlType = urlType;
        }

        public LinkedInApiUrlBuilder withParameter(String name, String value) {
            if (value != null && value.length() > 0) {
                this.parametersMap.put(name, (Collection<String>)Collections.singleton(LinkedInApiUrlBuilder.encodeUrl(value)));
            }
            return this;
        }

        public LinkedInApiUrlBuilder withParameters(String name, Collection<String> values) {
            ArrayList<String> encodedValues = new ArrayList<String>(values.size());
            for (String value : values) {
                encodedValues.add(LinkedInApiUrlBuilder.encodeUrl(value));
            }
            this.parametersMap.put(name, encodedValues);
            return this;
        }

        public LinkedInApiUrlBuilder withParameterEnumSet(String name, Set<? extends FieldEnum> enumSet) {
            HashSet<String> values = new HashSet<String>(enumSet.size());
            for (FieldEnum fieldEnum : enumSet) {
                values.add(LinkedInApiUrlBuilder.encodeUrl(fieldEnum.fieldName()));
            }
            this.parametersMap.put(name, values);
            return this;
        }

        public LinkedInApiUrlBuilder withParameterEnum(String name, FieldEnum value) {
            this.withParameter(name, value.fieldName());
            return this;
        }

        public LinkedInApiUrlBuilder withParameterEnumMap(Map<? extends FieldEnum, String> enumMap) {
            for (FieldEnum fieldEnum : enumMap.keySet()) {
                this.withParameter(fieldEnum.fieldName(), enumMap.get(fieldEnum));
            }
            return this;
        }

        public LinkedInApiUrlBuilder withEmptyField(String name) {
            this.fieldsMap.put(name, "");
            return this;
        }

        public LinkedInApiUrlBuilder withField(String name, String value) {
            this.withField(name, value, false);
            return this;
        }

        public LinkedInApiUrlBuilder withField(String name, String value, boolean escape) {
            if (escape) {
                this.fieldsMap.put(name, LinkedInApiUrlBuilder.encodeUrl(value));
            } else {
                this.fieldsMap.put(name, value);
            }
            return this;
        }

        public LinkedInApiUrlBuilder withFieldEnum(String name, FieldEnum value) {
            if (value.fieldName() == null || value.fieldName().length() == 0) {
                this.fieldsMap.put(name, "");
            } else {
                this.fieldsMap.put(name, ":" + value.fieldName());
            }
            return this;
        }

        public LinkedInApiUrlBuilder withFieldEnumSet(String name, Set<? extends CompositeEnum<?>> enumSet) {
            StringBuilder builder = new StringBuilder();
            if (!enumSet.isEmpty()) {
                Map<CompositeEnum<?>, Set<CompositeEnum<?>>> enumMap = this.convertIntoEnumMap(enumSet);
                builder.append(":");
                builder.append("(");
                Set<CompositeEnum<?>> orphanFields = enumMap.remove(null);
                if (orphanFields != null) {
                    orphanFields.removeAll((Collection)enumMap.keySet());
                    this.appendChildEnums(builder, orphanFields);
                }
                if (orphanFields != null && !orphanFields.isEmpty() && !enumMap.isEmpty()) {
                    builder.append(",");
                }
                if (!enumMap.isEmpty()) {
                    Iterator<CompositeEnum<?>> parentIter = enumMap.keySet().iterator();
                    while (parentIter.hasNext()) {
                        CompositeEnum<?> parent = parentIter.next();
                        Set<CompositeEnum<?>> childEnums = enumMap.get(parent);
                        if (enumMap.containsKey(parent.parent())) continue;
                        builder.append(parent.fieldName());
                        builder.append(":");
                        builder.append("(");
                        this.appendChildEnums(builder, childEnums, enumMap);
                        builder.append(")");
                        if (!parentIter.hasNext()) continue;
                        builder.append(",");
                    }
                }
                builder.append(")");
            }
            this.fieldsMap.put(name, builder.toString());
            return this;
        }

        private void appendChildEnums(StringBuilder builder, Set<? extends CompositeEnum<?>> childEnums, Map<? extends CompositeEnum<?>, Set<CompositeEnum<?>>> enumMap) {
            Iterator<CompositeEnum<?>> childIter = childEnums.iterator();
            while (childIter.hasNext()) {
                CompositeEnum<?> fieldEnum = childIter.next();
                builder.append(fieldEnum.fieldName());
                if (enumMap.containsKey(fieldEnum)) {
                    builder.append(":");
                    builder.append("(");
                    this.appendChildEnums(builder, enumMap.get(fieldEnum), enumMap);
                    builder.append(")");
                }
                if (!childIter.hasNext()) continue;
                builder.append(",");
            }
        }

        private void appendChildEnums(StringBuilder builder, Set<? extends CompositeEnum<?>> childEnums) {
            Iterator<CompositeEnum<?>> childIter = childEnums.iterator();
            while (childIter.hasNext()) {
                CompositeEnum<?> fieldEnum = childIter.next();
                builder.append(fieldEnum.fieldName());
                if (!childIter.hasNext()) continue;
                builder.append(",");
            }
        }

        private Map<? extends CompositeEnum<?>, Set<CompositeEnum<?>>> convertIntoEnumMap(Set<? extends CompositeEnum<?>> enumSet) {
            HashMap enumMap = new HashMap();
            for (CompositeEnum<?> e : enumSet) {
                while (e != null) {
                    HashSet childEnums = (HashSet)enumMap.get(e.parent());
                    if (childEnums == null) {
                        childEnums = new HashSet();
                        enumMap.put(e.parent(), childEnums);
                    }
                    childEnums.add(e);
                    e = e.parent();
                }
            }
            return enumMap;
        }

        public LinkedInApiUrlBuilder withFacets(List<Parameter<FacetType, String>> facets) {
            HashMap<FacetType, ArrayList<String>> facetsMap = new HashMap<FacetType, ArrayList<String>>();
            for (Parameter<FacetType, String> facet : facets) {
                ArrayList<String> lstFacets = (ArrayList<String>)facetsMap.get((Object)facet.getName());
                if (lstFacets == null) {
                    lstFacets = new ArrayList<String>();
                    facetsMap.put(facet.getName(), lstFacets);
                }
                lstFacets.add(facet.getValue());
            }
            ArrayList<String> facetParamValues = new ArrayList<String>();
            for (Map.Entry entry : facetsMap.entrySet()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(((FacetType)((Object)entry.getKey())).value());
                for (String facetValue : (List)entry.getValue()) {
                    buffer.append(",");
                    buffer.append(facetValue);
                }
                facetParamValues.add(buffer.toString());
            }
            return this.withParameters(SearchParameter.FACET.fieldName(), facetParamValues);
        }

        public String buildUrl() {
            StringBuilder urlBuilder = new StringBuilder();
            StringBuilder placeHolderBuilder = new StringBuilder();
            boolean placeHolderFlag = false;
            int i = 0;
            while (i < this.urlFormat.length()) {
                if (this.urlFormat.charAt(i) == '{') {
                    placeHolderBuilder = new StringBuilder();
                    placeHolderFlag = true;
                } else if (placeHolderFlag && this.urlFormat.charAt(i) == '}') {
                    String placeHolder = placeHolderBuilder.toString();
                    if (this.fieldsMap.containsKey(placeHolder)) {
                        urlBuilder.append(this.fieldsMap.get(placeHolder));
                    } else if (QUERY_PARAMETERS_PLACEHOLDER.equals(placeHolder)) {
                        StringBuilder builder = new StringBuilder();
                        if (!this.parametersMap.isEmpty()) {
                            builder.append("?");
                            Iterator<String> iter = this.parametersMap.keySet().iterator();
                            while (iter.hasNext()) {
                                String name = iter.next();
                                Collection<String> parameterValues = this.parametersMap.get(name);
                                Iterator<String> iterParam = parameterValues.iterator();
                                while (iterParam.hasNext()) {
                                    builder.append(name);
                                    builder.append("=");
                                    builder.append(iterParam.next());
                                    if (!iterParam.hasNext()) continue;
                                    builder.append("&");
                                }
                                if (!iter.hasNext()) continue;
                                builder.append("&");
                            }
                        }
                        urlBuilder.append(builder.toString());
                    } else {
                        urlBuilder.append('{');
                        urlBuilder.append(placeHolder);
                        urlBuilder.append('}');
                    }
                    placeHolderFlag = false;
                } else if (placeHolderFlag) {
                    placeHolderBuilder.append(this.urlFormat.charAt(i));
                } else {
                    urlBuilder.append(this.urlFormat.charAt(i));
                }
                ++i;
            }
            return urlBuilder.toString();
        }

        private static String encodeUrl(String original) {
            try {
                return URLEncoder.encode(original, ApplicationConstants.CONTENT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                return original;
            }
        }
    }
}

