/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client;

import com.google.code.linkedinapi.client.AsyncLinkedInApiClient;
import com.google.code.linkedinapi.client.CommunicationsApiClient;
import com.google.code.linkedinapi.client.CompaniesApiClient;
import com.google.code.linkedinapi.client.JobsApiClient;
import com.google.code.linkedinapi.client.LinkedInApiClient;
import com.google.code.linkedinapi.client.LinkedInApiClientException;
import com.google.code.linkedinapi.client.NetworkUpdatesApiClient;
import com.google.code.linkedinapi.client.PeopleApiClient;
import com.google.code.linkedinapi.client.constant.ApplicationConstants;
import com.google.code.linkedinapi.client.impl.AsyncLinkedInApiClientAdapter;
import com.google.code.linkedinapi.client.oauth.LinkedInAccessToken;
import com.google.code.linkedinapi.client.oauth.LinkedInApiConsumer;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LinkedInApiClientFactory {
    private static final Map<LinkedInApiConsumer, LinkedInApiClientFactory> factoriesMap = new ConcurrentHashMap<LinkedInApiConsumer, LinkedInApiClientFactory>();
    private ExecutorService taskExecutor = Executors.newCachedThreadPool();
    private LinkedInApiConsumer apiConsumer;
    private Constructor<? extends LinkedInApiClient> defaultClientImpl;

    private LinkedInApiClientFactory(LinkedInApiConsumer apiConsumer) {
        this.apiConsumer = apiConsumer;
    }

    public void setTaskExecutor(ExecutorService taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public static LinkedInApiClientFactory newInstance(String consumerKey, String consumerSecret) {
        return LinkedInApiClientFactory.newInstance(new LinkedInApiConsumer(consumerKey, consumerSecret));
    }

    public static synchronized LinkedInApiClientFactory newInstance(LinkedInApiConsumer apiConsumer) {
        LinkedInApiClientFactory.validateConsumerKey(apiConsumer);
        LinkedInApiClientFactory factory = factoriesMap.get(apiConsumer);
        if (factory == null) {
            factory = new LinkedInApiClientFactory(apiConsumer);
            factoriesMap.put(apiConsumer, factory);
        }
        return factory;
    }

    public LinkedInApiClient createLinkedInApiClient(LinkedInAccessToken accessToken) {
        this.validateAccessToken(accessToken);
        try {
            if (this.defaultClientImpl == null) {
                Class<?> clazz = Class.forName(ApplicationConstants.CLIENT_DEFAULT_IMPL);
                this.defaultClientImpl = clazz.getConstructor(String.class, String.class);
            }
            LinkedInApiClient client = this.defaultClientImpl.newInstance(this.apiConsumer.getConsumerKey(), this.apiConsumer.getConsumerSecret());
            client.setAccessToken(accessToken);
            return client;
        }
        catch (Exception e) {
            throw new LinkedInApiClientException(e);
        }
    }

    public LinkedInApiClient createLinkedInApiClient(Class<? extends LinkedInApiClient> implClass, LinkedInAccessToken accessToken) {
        this.validateAccessToken(accessToken);
        try {
            LinkedInApiClient client = implClass.getConstructor(String.class, String.class).newInstance(this.apiConsumer.getConsumerKey(), this.apiConsumer.getConsumerSecret());
            client.setAccessToken(accessToken);
            return client;
        }
        catch (Exception e) {
            throw new LinkedInApiClientException(e);
        }
    }

    public AsyncLinkedInApiClient createAsyncLinkedInApiClient(LinkedInAccessToken accessToken) {
        this.validateAccessToken(accessToken);
        LinkedInApiClient client = this.createLinkedInApiClient(accessToken);
        return new AsyncLinkedInApiClientAdapter(client, this.taskExecutor);
    }

    public LinkedInApiClient createLinkedInApiClient(String token, String tokenSecret) {
        return this.createLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    public PeopleApiClient createPeopleApiClient(LinkedInAccessToken accessToken) {
        return this.createLinkedInApiClient(accessToken);
    }

    public PeopleApiClient createPeopleApiClient(String token, String tokenSecret) {
        return this.createLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    public CompaniesApiClient createCompaniesApiClient(LinkedInAccessToken accessToken) {
        return this.createLinkedInApiClient(accessToken);
    }

    public CompaniesApiClient createCompaniesApiClient(String token, String tokenSecret) {
        return this.createLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    public JobsApiClient createJobsApiClient(LinkedInAccessToken accessToken) {
        return this.createLinkedInApiClient(accessToken);
    }

    public JobsApiClient createJobsApiClient(String token, String tokenSecret) {
        return this.createLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    public CommunicationsApiClient createCommunicationsApiClient(LinkedInAccessToken accessToken) {
        return this.createLinkedInApiClient(accessToken);
    }

    public CommunicationsApiClient createCommunicationsApiClient(String token, String tokenSecret) {
        return this.createLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    public NetworkUpdatesApiClient createNetworkUpdatesApiClient(LinkedInAccessToken accessToken) {
        return this.createLinkedInApiClient(accessToken);
    }

    public NetworkUpdatesApiClient createNetworkUpdatesApiClient(String token, String tokenSecret) {
        return this.createLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    public AsyncLinkedInApiClient createAsyncLinkedInApiClient(String token, String tokenSecret) {
        return this.createAsyncLinkedInApiClient(new LinkedInAccessToken(token, tokenSecret));
    }

    private static void validateConsumerKey(LinkedInApiConsumer apiConsumer) {
        if (apiConsumer == null) {
            throw new IllegalArgumentException("api consumer cannot be null.");
        }
        if (apiConsumer.getConsumerKey() == null || apiConsumer.getConsumerKey().length() == 0) {
            throw new IllegalArgumentException("consumer key cannot be null or empty.");
        }
        if (apiConsumer.getConsumerSecret() == null || apiConsumer.getConsumerSecret().length() == 0) {
            throw new IllegalArgumentException("consumer secret cannot be null or empty.");
        }
    }

    private void validateAccessToken(LinkedInAccessToken accessToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("access token cannot be null.");
        }
        if (accessToken.getToken() == null || accessToken.getToken().length() == 0) {
            throw new IllegalArgumentException("access token cannot be null or empty.");
        }
        if (accessToken.getTokenSecret() == null || accessToken.getTokenSecret().length() == 0) {
            throw new IllegalArgumentException("access token secret cannot be null or empty.");
        }
    }
}

