package models
{
   import flash.utils.IDataInput;

   /**
    * Ta klasa reprezentuje obiekt mogcy by pojedynczym utworem lub pojemnikiem
    * na inne utwory.
    */  
   public class MusicEntry {
      private var _name:String;
      private var _url:String;
      private var _streamFunc:Function;
   
      public function MusicEntry(name:String, url:String, streamFunc:Function) {
         _name = name;
         _url = url;
         _streamFunc = streamFunc;
      }

      public function get name():String {
         return _name;
      }
    
      public function get url():String {
         return _url;
      }
    
      /**
       * @return Strumie, jeli obiekt jest prawidowym utworem. W przeciwnym wypadku null.
       */
      public function get stream():IDataInput {
         return _streamFunc == null ? null : _streamFunc();
      }
    
      public function get isSong():Boolean {
         return _streamFunc != null;
      }
   }
}
