import org.osmf.elements.LightweightVideoElement;
import org.osmf.elements.VideoElement;
import org.osmf.events.DisplayObjectEvent;
import org.osmf.events.MediaElementEvent;
import org.osmf.events.TimeEvent;
import org.osmf.media.MediaPlayer;
import org.osmf.media.URLResource;
import org.osmf.net.NetLoader;

private static const sourceURL:String = "http://ia600408.us.archive.org"+
  "/26/items/BigBuckBunny_328/BigBuckBunny_512kb.mp4";

private var player:MediaPlayer;
private var duration:String;

private function onInitialize():void {
  var element:LightweightVideoElement;
  element = new LightweightVideoElement(new URLResource(sourceURL));
  
  player = new MediaPlayer(element);
  videoContainer.addChild(player.displayObject);
  
  player.addEventListener(DisplayObjectEvent.MEDIA_SIZE_CHANGE, onSize);
  player.addEventListener(TimeEvent.CURRENT_TIME_CHANGE, onTimeChange);
  player.addEventListener(TimeEvent.DURATION_CHANGE, onDurationChange);
  player.addEventListener(TimeEvent.COMPLETE, onVideoComplete);
  player.currentTimeUpdateInterval = 1000;
}

private function onViewDeactivate():void {
  if (player)
    player.stop();
}

private function onPlayPause():void {
  if (playBtn.selected) {
    player.play();
  } else {
    player.pause();
  }
}

private function onDurationChange(event:TimeEvent):void {
  duration = formatSeconds(player.duration);
}

private function onTimeChange(event:TimeEvent):void {
  updateTimeDisplay(formatSeconds(player.currentTime));
}

private function onVideoComplete(event:TimeEvent):void{
  trace("Wideo zostao odtworzone do koca!");
}

private function onSize(event:DisplayObjectEvent):void {
  player.displayObject.x = (width - event.newWidth) / 2;
  player.displayObject.y = (height - event.newHeight) / 2;
}

private function updateTimeDisplay(time:String):void {
  if (duration) 
    time += " / "+ duration;
  
  timeDisplay.text = time;
}

private function formatSeconds(time:Number):String {
  var minutes:int = time / 60;
  var seconds:int = int(time) % 60;
  
  return String(minutes+":"+(seconds<10 ? "0" : "")+seconds);
}
