import flash.display.Screen;

import mx.events.FlexEvent;

import spark.primitives.BitmapImage;

private static const TO_RADIANS:Number = Math.PI / 180;

private static const BROWSE_UNSUPPORTED:String = "Przegldanie za pomoc " +
   "flash.media.CameraRoll nie jest obsugiwane na tym urzdzeniu.";

private var centerPt:Point = new Point();
private var cameraRoll:CameraRoll = new CameraRoll();

private function onCreationComplete():void {
  cameraRoll.addEventListener(MediaEvent.SELECT, onSelect);
  cameraRoll.addEventListener(Event.CANCEL, onSelectCanceled);
  cameraRoll.addEventListener(ErrorEvent.ERROR, onCameraRollError);
  cameraRoll.addEventListener(Event.COMPLETE, onSaveComplete);
  
  // Upewnij si, e wiadomoci tektsowe mieszcz si w obszarze
  // wyznaczonym szerokoci widoku.

  messageLabel.maxWidth = Screen.mainScreen.bounds.width;
  messageLabel.maxHeight = Screen.mainScreen.bounds.height;
  
  if (Multitouch.supportsGestureEvents) {
    showMessage("Gesty obsugiwane");
    Multitouch.inputMode = MultitouchInputMode.GESTURE;
  } else {
    showMessage("Gesty powikszenie i obrt nie s obsugiwane");
  }
}

private function onBrowse():void {
  if (CameraRoll.supportsBrowseForImage) {
    cameraRoll.browseForImage();
  } else {
    showMessage(BROWSE_UNSUPPORTED);
  }
}

private function onClear():void {
  var zoomEvent:String = TransformGestureEvent.GESTURE_ZOOM;
  var rotateEvent:String = TransformGestureEvent.GESTURE_ROTATE;
  
  while (photoContainer.numChildren > 0) {
    var o: DisplayObject = photoContainer.removeChildAt(0);
    o.removeEventListener(zoomEvent, onZoom);
    o.removeEventListener(rotateEvent, onRotate);
    o.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    o.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
  }
  
  photoContainer.scaleX = photoContainer.scaleY = 1;
  photoContainer.width = width;
  photoContainer.height = height;
  
  messageLabel.text = "";
}

private function onSave():void {
  if (CameraRoll.supportsAddBitmapData) {
    var w: Number = photoContainer.width;
    var h: Number = photoContainer.height;
    
    var m: Matrix = new Matrix();
    if (w > 1024 || h > 1024) {
      var scale: Number = 1024/w;
      scale = Math.min(scale, 1024/h);
      m.scale(scale, scale);
      
      w *= scale;
      h *= scale;
    }
    
    var bmpData:BitmapData = new BitmapData(w, h, false, 0x202020);
    bmpData.draw(photoContainer, m);
    cameraRoll.addBitmapData(bmpData);
  }
}

private function onSelect(event:MediaEvent):void {
  var loader: Loader = new Loader();
  loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
  loader.load( new URLRequest(event.data.file.url));
}

private function onSelectCanceled(event:Event):void {
  showMessage("Wybr anulowany");
}

private function onCameraRollError(event:ErrorEvent):void {
  showMessage("Bd: "+event.text);
}

private function onSaveComplete(event:Event):void {
  showMessage("COperacja CameraRoll zakoczona");
}

private function onLoaded(event:Event):void {
  var info: LoaderInfo = event.target as LoaderInfo;
  var bmp: Bitmap = info.content as Bitmap;
  
  scaleContainer(bmp.width, bmp.height);
  
  var sprite: Sprite = new Sprite();
  
  sprite.addEventListener(TransformGestureEvent.GESTURE_ZOOM, onZoom);
  sprite.addEventListener(TransformGestureEvent.GESTURE_ROTATE, onRotate);
  sprite.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
  sprite.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
  sprite.addChild(bmp);
  
  photoContainer.addChild(sprite);
}

private function onMouseDown(event:MouseEvent):void {
  var sprite:Sprite = event.target as Sprite;
  photoContainer.setChildIndex(sprite, photoContainer.numChildren-1);
  sprite.startDrag();
  
  event.stopImmediatePropagation();
}

private function onMouseUp(event:MouseEvent):void {
  var sprite:Sprite = event.target as Sprite;
  sprite.stopDrag();
  
  event.stopImmediatePropagation();
}    

private function onZoom(event:TransformGestureEvent):void {
  var sprite:Sprite = event.target as Sprite;
  sprite.scaleX *= event.scaleX;
  sprite.scaleY *= event.scaleY;
  sprite.stopDrag();
}

private function onRotate(event:TransformGestureEvent):void {
  var sprite:Sprite = event.target as Sprite;
  
  centerPt.x = sprite.width/2;
  centerPt.y = sprite.height/2;
  
  var newMatrix:Matrix = sprite.transform.matrix;
  var rotatedMidPt:Point = newMatrix.transformPoint(centerPt);
  
  newMatrix.translate(-rotatedMidPt.x, -rotatedMidPt.y);
  newMatrix.rotate(event.rotation * TO_RADIANS);
  newMatrix.translate(rotatedMidPt.x, rotatedMidPt.y);
  
  sprite.transform.matrix = newMatrix;
  sprite.stopDrag();
}

private function scaleContainer(w:Number, h:Number):void {
  if (w < photoContainer.width && h < photoContainer.height)
    return;
  
  var scaleFactor: Number;
  if (w > h) {
    scaleFactor = width / w;
  } else {
    scaleFactor = height / h;
  }
  
  photoContainer.scaleX = photoContainer.scaleY = scaleFactor;
}

private function showMessage(msg:String):void {
  if (messageLabel.text && messageLabel.height < height) {
    messageLabel.text += "\n" + msg;
  } else {
    messageLabel.text = msg;
  }
}
