import flash.data.SQLStatement;
import flash.errors.SQLError;
import flash.events.Event;
import flash.events.SQLErrorEvent;
import flash.events.SQLEvent;
import flash.events.TimerEvent;
import flash.filesystem.File;
import flash.utils.Timer;

import mx.collections.ArrayCollection;
import mx.utils.ObjectUtil;

import org.osmf.events.TimeEvent;

// sqlconn przechowuje poczenie z baz danych
public var sqlconn:SQLConnection = new SQLConnection();

// sqlstmt przechowuje zapytania SQL
public var sqlstmt:SQLStatement = new SQLStatement();

// zmienna ArrayCollection typu Bindable - rdo danych dla kontrolki DataGrid
[Bindable]
public var dp:ArrayCollection = new ArrayCollection();

// funkcja wywoywana po zaadowaniu naszej aplikacji
private function start():void {
  // ustaw people.db jako plik dla naszej bazy danych (tworzony po otwarciu)
  var db:File = File.applicationStorageDirectory.resolvePath("people.db");
  
  // otwrz baz danych w trybie asynchronicznym
  sqlconn.openAsync(db);
  
  // detektory zdarze bdw SQL i zdarzenia result
  // s wywoywane przy kadym pobraniu danych z bazy
  sqlconn.addEventListener(SQLEvent.OPEN, db_opened);
  sqlconn.addEventListener(SQLErrorEvent.ERROR, error);
  sqlstmt.addEventListener(SQLErrorEvent.ERROR, error);
  sqlstmt.addEventListener(SQLEvent.RESULT, result);
}

private function db_opened(e:SQLEvent):void {
  // wskazywanie poczenia dla wyraenia SQL
  sqlstmt.sqlConnection = sqlconn;
  
  // Tabela person_table zawiera trzy kolumny:  
  // 1) id (inkrementowana automatycznie liczba cakowita)
  // 2) first_name (imi osoby)
  // 3) last_name (nazwisko osoby)
  sqlstmt.text = "CREATE TABLE IF NOT EXISTS person_table ( id INTEGER PRIMARY KEY AUTOINCREMENT, first_name TEXT, last_name TEXT);";
  
  // wykonaj sglstmt w celu aktualizacji bazy
  sqlstmt.execute();
  
  // odwie DataGrid w celu wywietlenia wszystkich wierszy danych  
  refreshDataGrid();
}

// funkcja dodajca nowy wiersz do tabeli person_table
// kady nowy wiersz zawiera first_name i last_name
private function addPerson():void {
  sqlstmt.text = "INSERT INTO person_table (first_name, last_name) VALUES('"+first_name.text+"','"+last_name.text+"');";
  sqlstmt.execute();
  
  refreshDataGrid();
}

// funkcja odwieajca dane w DataGrid
private function refreshDataGrid(e:TimerEvent = null):void {
  // obiekt timer zatrzymuje i prbuje ponownie wykona zapytanie SQL
  var timer:Timer = new Timer(100,1);
  timer.addEventListener(TimerEvent.TIMER, refreshDataGrid);
  
  if ( !sqlstmt.executing ) {
    sqlstmt.text = "SELECT * FROM person_table"
    sqlstmt.execute();
  } else {
    timer.start();
  }
}

// wywoywana, kiedy otrzymujemy obiekt data z zapytania SQL
private function result(e:SQLEvent):void {
  var data:Array = sqlstmt.getResult().data;
  
  // wypenij DataGrid
  dp = new ArrayCollection(data);
}

// usu osob z tabeli
private function removePerson():void {
  sqlstmt.text = "DELETE FROM person_table WHERE id="+dp[dg.selectedIndex].id;
  sqlstmt.execute();
  refreshDataGrid();
}

// metoda obsugi bdw 
private function error(e:SQLErrorEvent):void {
//  Alert.show(e.toString());
}

