// ItemDivider.java
// Klasa definiująca linie rozdzielające elementy widoku RecyclerView;
// kod oparto na przykładowej implementacji przygotowanej przez firmę Google: bit.ly/DividerItemDecoration.
package com.deitel.addressbook;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;

class ItemDivider extends RecyclerView.ItemDecoration {
   private final Drawable divider;

   // konstruktor ładuje wbudowany w system Android element dzielący listy
   public ItemDivider(Context context) {
      int[] attrs = {android.R.attr.listDivider};
      divider = context.obtainStyledAttributes(attrs).getDrawable(0);
   }

   // rysuje linie rozdzielające elementy widoku RecyclerView
   @Override
   public void onDrawOver(Canvas c, RecyclerView parent,
      RecyclerView.State state) {
      super.onDrawOver(c, parent, state);

      // oblicz współrzędne x w płaszczyźnie lewo-prawo wszystkich linii rozdzielających
      int left = parent.getPaddingLeft();
      int right = parent.getWidth() - parent.getPaddingRight();

      // linię narysuj pod każdym z elementów poza ostatnim elementem
      for (int i = 0; i < parent.getChildCount() - 1; ++i) {
         View item = parent.getChildAt(i); // odczytaj i-ty element listy

         // oblicz współrzędne y w płaszczyźnie góra-dół wszystkich linii rozdzielających
         int top = item.getBottom() + ((RecyclerView.LayoutParams)
            item.getLayoutParams()).bottomMargin;
         int bottom = top + divider.getIntrinsicHeight();

         // rysuj linię rozdzielającą korzystając z obliczonych granic
         divider.setBounds(left, top, right, bottom);
         divider.draw(c);
      }
   }
}


/**************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************/
