// ContactsAdapter.java
// Podklasa RecyclerView.Adapter wiążąca kontakty z widokiem RecyclerView.
package com.deitel.addressbook;

import android.database.Cursor;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.deitel.addressbook.data.DatabaseDescription.Contact;

public class ContactsAdapter
   extends RecyclerView.Adapter<ContactsAdapter.ViewHolder> {

   // interfejs implementowany przez ContactsFragment
   // po dotknięciu przez użytkownika elementu wyświetlanego w widoku RecyclerView
   public interface ContactClickListener {
      void onClick(Uri contactUri);
   }

   // zagnieżdżona podklasa RecyclerView.ViewHolder używana do implementacji
   // wzorca ViewHolder w kontekście widoku RecyclerView
   public class ViewHolder extends RecyclerView.ViewHolder {
      public final TextView textView;
      private long rowID;

      // konfiguruje obiekt ViewHolder elementu widoku RecyclerView
      public ViewHolder(View itemView) {
         super(itemView);
         textView = (TextView) itemView.findViewById(android.R.id.text1);

         // dołącz do itemView obiekt nasłuchujący
         itemView.setOnClickListener(
            new View.OnClickListener() {
               // kod wykonywany po kliknięciu kontaktu znajdującego się w tym obiekcie ViewHolder
               @Override
               public void onClick(View view) {
                  clickListener.onClick(Contact.buildContactUri(rowID));
               }
            }
         );
      }

      // określ identyfikator rzędu bazy danych kontaktu znajdującego się w tym obiekcie ViewHolder
      public void setRowID(long rowID) {
         this.rowID = rowID;
      }
   }

   // zmienne egzemplarzowe adaptera ContactsAdapter
   private Cursor cursor = null;
   private final ContactClickListener clickListener;

   // konstruktor
   public ContactsAdapter(ContactClickListener clickListener) {
      this.clickListener = clickListener;
   }

   // ustala nowy element listy i jego obiekt ViewHolder
   @Override
   public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
      // przygotuj do wyświetlenia rozkład android.R.layout.simple_list_item_1
      View view = LayoutInflater.from(parent.getContext()).inflate(
         android.R.layout.simple_list_item_1, parent, false);
      return new ViewHolder(view); // zwróć obiekt ViewHolder bieżącego elementu
   }

   // określa tekst elementu listy w celu wyświetlenia etykiety zapytania
   @Override
   public void onBindViewHolder(ViewHolder holder, int position) {
      cursor.moveToPosition(position);
      holder.setRowID(cursor.getLong(cursor.getColumnIndex(Contact._ID)));
      holder.textView.setText(cursor.getString(cursor.getColumnIndex(
         Contact.COLUMN_NAME)));
   }

   // zwraca liczbę elementów wiązanych przez adapter
   @Override
   public int getItemCount() {
      return (cursor != null) ? cursor.getCount() : 0;
   }

   // zamień bieżący obiekt Cursor adaptera na nowy
   public void swapCursor(Cursor cursor) {
      this.cursor = cursor;
      notifyDataSetChanged();
   }
}


/**************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************/
