// ColorDialogFragment.java
// Umożliwia użytkownikowi wybór koloru, którym wykonuje rysunek.
package com.deitel.doodlz;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;

// klasa okna dialogowego Wybierz kolor
public class ColorDialogFragment extends DialogFragment {
   private SeekBar alphaSeekBar;
   private SeekBar redSeekBar;
   private SeekBar greenSeekBar;
   private SeekBar blueSeekBar;
   private View colorView;
   private int color;

   // stwórz obiekt AlertDialog i go zwróć
   @Override
   public Dialog onCreateDialog(Bundle bundle) {
      // stwórz okno
      AlertDialog.Builder builder =
         new AlertDialog.Builder(getActivity());
      View colorDialogView = getActivity().getLayoutInflater().inflate(
         R.layout.fragment_color, null);
      builder.setView(colorDialogView); // w oknie umieść graficzny interfejs użytkownika

      // stwórz komunikat wyświetlany w oknie AlertDialog
      builder.setTitle(R.string.title_color_dialog);

      // uzyskaj dostęp do pasków SeekBar definiujących kolor i utwórz obiekty onChange nasłuchujące zmian ich położenia
      alphaSeekBar = (SeekBar) colorDialogView.findViewById(
         R.id.alphaSeekBar);
      redSeekBar = (SeekBar) colorDialogView.findViewById(
         R.id.redSeekBar);
      greenSeekBar = (SeekBar) colorDialogView.findViewById(
         R.id.greenSeekBar);
      blueSeekBar = (SeekBar) colorDialogView.findViewById(
         R.id.blueSeekBar);
      colorView = colorDialogView.findViewById(R.id.colorView);

      // zarejestruj zdarzenia nasłuchujące zdarzeń pasków SeekBar
      alphaSeekBar.setOnSeekBarChangeListener(colorChangedListener);
      redSeekBar.setOnSeekBarChangeListener(colorChangedListener);
      greenSeekBar.setOnSeekBarChangeListener(colorChangedListener);
      blueSeekBar.setOnSeekBarChangeListener(colorChangedListener);

      // ustal wartości pasków SeekBar na podstawie bieżącego koloru
      final DoodleView doodleView = getDoodleFragment().getDoodleView();
      color = doodleView.getDrawingColor();
      alphaSeekBar.setProgress(Color.alpha(color));
      redSeekBar.setProgress(Color.red(color));
      greenSeekBar.setProgress(Color.green(color));
      blueSeekBar.setProgress(Color.blue(color));

      // dodaj przycisk Wybierz kolor
      builder.setPositiveButton(R.string.button_set_color,
         new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
               doodleView.setDrawingColor(color);
            }
         }
      );

      return builder.create(); // zwróć okno dialogowe
   }

   // uzyskuje odwołanie do obiektu MainActivityFragment
   private MainActivityFragment getDoodleFragment() {
      return (MainActivityFragment) getFragmentManager().findFragmentById(
         R.id.doodleFragment);
   }

   // poinformuj MainActivityFragment o tym, że okno jest aktualnie wyświetlane
   @Override
   public void onAttach(Activity activity) {
      super.onAttach(activity);
      MainActivityFragment fragment = getDoodleFragment();

      if (fragment != null)
         fragment.setDialogOnScreen(true);
   }

   // poinformuj MainActivityFragment o tym, że okno nie jest już wyświetlane
   @Override
   public void onDetach() {
      super.onDetach();
      MainActivityFragment fragment = getDoodleFragment();

      if (fragment != null)
         fragment.setDialogOnScreen(false);
   }

   // interfejs OnSeekBarChangeListener obsługujący suwaki definiujące kolor
   private final OnSeekBarChangeListener colorChangedListener =
      new OnSeekBarChangeListener() {
         // wyświetl zaktualizowaną próbkę koloru
         @Override
         public void onProgressChanged(SeekBar seekBar, int progress,
            boolean fromUser) {

            if (fromUser) // zmiana położenia suwaka SeekBar została wywołana przez użytkownika, a nie przez program
               color = Color.argb(alphaSeekBar.getProgress(),
                  redSeekBar.getProgress(), greenSeekBar.getProgress(),
                  blueSeekBar.getProgress());
            colorView.setBackgroundColor(color);
         }

         @Override
         public void onStartTrackingTouch(SeekBar seekBar) {} // wymagane

         @Override
         public void onStopTrackingTouch(SeekBar seekBar) {} // wymagane
      };
}

/**************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************/
