// Cannonball.java
// Klasa opisująca kulę wystrzeliwaną przez działo.
package com.deitel.cannongame;

import android.graphics.Canvas;
import android.graphics.Rect;

public class Cannonball extends GameElement {
   private float velocityX;
   private boolean onScreen;

   // konstruktor
   public Cannonball(CannonView view, int color, int soundId, int x,
      int y, int radius, float velocityX, float velocityY) {
      super(view, color, soundId, x, y,
         2 * radius, 2 * radius, velocityY);
      this.velocityX = velocityX;
      onScreen = true;
   }

   // ustal promień kuli
   private int getRadius() {
      return (shape.right - shape.left) / 2;
   }

   // sprawdź, czy kula uderza w dany element GameElement
   public boolean collidesWith(GameElement element) {
      return (Rect.intersects(shape, element.shape) && velocityX > 0);
   }

   // metoda zwraca wartość logiczną true, jeżeli kula znajduje się na ekranie
   public boolean isOnScreen() {
      return onScreen;
   }

   // odwróć zwrot kierunku ruchu kuli w płaszczyźnie poziomej
   public void reverseVelocityX() {
      velocityX *= -1;
   }

   // aktualizuje pozycję kuli
   @Override
   public void update(double interval) {
      super.update(interval); // aktualizuje położenie kuli w płaszczyźnie pionowej

      // aktualizuje położenie w płaszczyźnie poziomej
      shape.offset((int) (velocityX * interval), 0);

      // jeżeli kula znajdzie się poza ekranem
      if (shape.top < 0 || shape.left < 0 ||
         shape.bottom > view.getScreenHeight() ||
         shape.right > view.getScreenWidth())
         onScreen = false; // przypisz wartość pozwalającą na usunięcie kuli
   }

   // rysuje obiekt Cannonball na danym obiekcie canvas
   @Override
   public void draw(Canvas canvas) {
      canvas.drawCircle(shape.left + getRadius(),
         shape.top + getRadius(), getRadius(), paint);
   }
}

/*********************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and * Pearson Education, *
 * Inc. All Rights Reserved. * * DISCLAIMER: The authors and publisher of this   *
 * book have used their * best efforts in preparing the book. These efforts      *
 * include the * development, research, and testing of the theories and programs *
 * * to determine their effectiveness. The authors and publisher make * no       *
 * warranty of any kind, expressed or implied, with regard to these * programs   *
 * or to the documentation contained in these books. The authors * and publisher *
 * shall not be liable in any event for incidental or * consequential damages in *
 * connection with, or arising out of, the * furnishing, performance, or use of  *
 * these programs.                                                               *
 *********************************************************************************/
