/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.internal.zzas;
import com.google.android.gms.drive.internal.zzat;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.zzd;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzrx;

public class DriveId
implements SafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzd();
    final int mVersionCode;
    final String zzagC;
    final long zzagD;
    final long zzagn;
    final int zzagE;
    private volatile String zzagp = null;
    private volatile String zzagF = null;

    public static DriveId zzcC(String string) {
        zzx.zzv((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzagC;
    }

    public int getResourceType() {
        return this.zzagE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    DriveId(int versionCode, String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this.mVersionCode = versionCode;
        this.zzagC = resourceId;
        zzx.zzZ((!"".equals(resourceId) ? 1 : 0) != 0);
        zzx.zzZ((resourceId != null || sqlId != -1L ? 1 : 0) != 0);
        this.zzagD = sqlId;
        this.zzagn = databaseInstanceId;
        this.zzagE = resourceType;
    }

    public DriveId(String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this(1, (String)(resourceId != null && resourceId.startsWith("generated-android-") ? null : resourceId), sqlId, databaseInstanceId, resourceType);
    }

    public int hashCode() {
        if (this.zzagD == -1L) {
            return this.zzagC.hashCode();
        }
        return (String.valueOf(this.zzagn) + String.valueOf(this.zzagD)).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)obj;
        if (driveId.zzagn != this.zzagn) {
            zzy.zzw("DriveId", "Attempt to compare invalid DriveId detected. Has local storage been cleared?");
            return false;
        }
        if (driveId.zzagD == -1L && this.zzagD == -1L) {
            return driveId.zzagC.equals(this.zzagC);
        }
        if (this.zzagC == null || driveId.zzagC == null) {
            return driveId.zzagD == this.zzagD;
        }
        if (driveId.zzagD == this.zzagD) {
            if (driveId.zzagC.equals(this.zzagC)) {
                return true;
            }
            zzy.zzw("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzagp == null) {
            byte[] byArray = this.zzqe();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            this.zzagp = "DriveId:" + string;
        }
        return this.zzagp;
    }

    public final String toInvariantString() {
        if (this.zzagF == null) {
            byte[] byArray = this.zzqk();
            this.zzagF = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzagF;
    }

    final byte[] zzqe() {
        zzas zzas2 = new zzas();
        zzas2.versionCode = this.mVersionCode;
        zzas2.zzajB = this.zzagC == null ? "" : this.zzagC;
        zzas2.zzajC = this.zzagD;
        zzas2.zzajz = this.zzagn;
        zzas2.zzajD = this.zzagE;
        byte[] byArray = zzrx.zzf((zzrx)zzas2);
        return byArray;
    }

    private byte[] zzqk() {
        zzat zzat2 = new zzat();
        zzat2.zzajC = this.zzagD;
        zzat2.zzajz = this.zzagn;
        byte[] byArray = zzrx.zzf((zzrx)zzat2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String s) {
        zzx.zzb((boolean)s.startsWith("DriveId:"), (Object)("Invalid DriveId: " + s));
        String string = s.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string, (int)10);
        return DriveId.zzk(byArray);
    }

    static DriveId zzk(byte[] byArray) {
        zzas zzas2;
        try {
            zzas2 = zzas.zzl(byArray);
        }
        catch (zzrw zzrw2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzas2.zzajB) ? null : zzas2.zzajB;
        DriveId driveId = new DriveId(zzas2.versionCode, string, zzas2.zzajC, zzas2.zzajz, zzas2.zzajD);
        return driveId;
    }
}

