/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzah;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzcp;
import com.google.android.gms.tagmanager.zzdf;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzaOS;
    private final DataLayer zzaOT;
    private zzcp zzaOU;
    private Map<String, FunctionCallMacroCallback> zzaOV = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzaOW = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzaOX;
    private volatile String zzaOY = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzqp.zzc resource) {
        this.mContext = context;
        this.zzaOT = dataLayer;
        this.zzaOS = containerId;
        this.zzaOX = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzaf.zzj resource) {
        this.mContext = context;
        this.zzaOT = dataLayer;
        this.zzaOS = containerId;
        this.zzaOX = lastRefreshTime;
        this.zza(resource.zziR);
        if (resource.zziQ != null) {
            this.zza(resource.zziQ);
        }
    }

    public String getContainerId() {
        return this.zzaOS;
    }

    public boolean getBoolean(String key) {
        zzcp zzcp2 = this.zzzD();
        if (zzcp2 == null) {
            zzbg.e("getBoolean called for closed container.");
            return zzdf.zzBd();
        }
        try {
            return zzdf.zzk(zzcp2.zzeS(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzBd();
        }
    }

    public double getDouble(String key) {
        zzcp zzcp2 = this.zzzD();
        if (zzcp2 == null) {
            zzbg.e("getDouble called for closed container.");
            return zzdf.zzBc();
        }
        try {
            return zzdf.zzj(zzcp2.zzeS(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzBc();
        }
    }

    public long getLong(String key) {
        zzcp zzcp2 = this.zzzD();
        if (zzcp2 == null) {
            zzbg.e("getLong called for closed container.");
            return zzdf.zzBb();
        }
        try {
            return zzdf.zzi(zzcp2.zzeS(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzBb();
        }
    }

    public String getString(String key) {
        zzcp zzcp2 = this.zzzD();
        if (zzcp2 == null) {
            zzbg.e("getString called for closed container.");
            return zzdf.zzBf();
        }
        try {
            return zzdf.zzg(zzcp2.zzeS(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzBf();
        }
    }

    public long getLastRefreshTime() {
        return this.zzaOX;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzaOV;
        synchronized (map) {
            this.zzaOV.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzaOV;
        synchronized (map) {
            this.zzaOV.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzeu(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzaOV;
        synchronized (map) {
            return this.zzaOV.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzaOW;
        synchronized (map) {
            this.zzaOW.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzaOW;
        synchronized (map) {
            this.zzaOW.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback zzev(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzaOW;
        synchronized (map) {
            return this.zzaOW.get(string);
        }
    }

    void zzew(String string) {
        this.zzzD().zzew(string);
    }

    String zzzC() {
        return this.zzaOY;
    }

    private void zza(zzaf.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzqp.zzc zzc2 = null;
        try {
            zzc2 = zzqp.zzb(zzf2);
        }
        catch (zzqp.zzg zzg2) {
            zzbg.e("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzaf.zzi[] zziArray) {
        ArrayList<zzaf.zzi> arrayList = new ArrayList<zzaf.zzi>();
        for (zzaf.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzzD().zzs(arrayList);
    }

    private void zza(zzqp.zzc zzc2) {
        this.zzaOY = zzc2.getVersion();
        zzah zzah2 = this.zzex(this.zzaOY);
        zzcp zzcp2 = new zzcp(this.mContext, zzc2, this.zzaOT, new zza(), new zzb(), zzah2);
        this.zza(zzcp2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzaOT.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzaOS));
        }
    }

    zzah zzex(String string) {
        if (zzcb.zzAv().zzAw().equals((Object)zzcb.zza.zzaRe)) {
            // empty if block
        }
        return new zzbo();
    }

    private synchronized void zza(zzcp zzcp2) {
        this.zzaOU = zzcp2;
    }

    private synchronized zzcp zzzD() {
        return this.zzaOU;
    }

    void release() {
        this.zzaOU = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzd(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzev(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdf.zzBf();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzd(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzeu(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

