/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzly;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.zzc<zze> zzQf = new Api.zzc();
    static final Api.zza<zze, PlusOptions> zzQg = new Api.zza<zze, PlusOptions>(){

        public zze zza(Context context, Looper looper, zzf zzf2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zzf2, new PlusSession(zzf2.zzog().name, zzly.zzc((Set)zzf2.zzoj()), plusOptions.zzaLf.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api("Plus.API", zzQg, zzQf);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final Moments MomentsApi = new zzpq();
    public static final People PeopleApi = new zzpr();
    public static final Account AccountApi = new zzpn();
    public static final zzb zzaLc = new zzpp();
    public static final com.google.android.gms.plus.zza zzaLd = new zzpo();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? (zze)googleApiClient.zza(zzQf) : null;
    }

    public static abstract class zza<R extends Result>
    extends zzc.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzQf, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String zzaLe;
        final Set<String> zzaLf;

        private PlusOptions() {
            this.zzaLe = null;
            this.zzaLf = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.zzaLe = builder.zzaLe;
            this.zzaLf = builder.zzaLf;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String zzaLe;
            final Set<String> zzaLf = new HashSet<String>();

            public Builder setServerClientId(String clientId) {
                this.zzaLe = clientId;
                return this;
            }

            public Builder addActivityTypes(String ... activityTypes) {
                zzx.zzb((Object)activityTypes, (Object)"activityTypes may not be null.");
                for (int i = 0; i < activityTypes.length; ++i) {
                    this.zzaLf.add(activityTypes[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

