/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.Collections;
import java.util.List;

public class Credential
implements SafeParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzRa;
    private final String zzRb;
    private final String zzwj;
    private final String mName;
    private final Uri zzRc;
    private final List<IdToken> zzRd;
    private final String zzRe;
    private final String zzRf;
    private final String zzRg;
    private final String zzRh;

    Credential(int version, String internalCredentialId, String internalServerContext, String id, String name, Uri profilePictureUri, List<IdToken> idTokens, String password, String accountType, String generatedPassword, String generatedHintId) {
        this.mVersionCode = version;
        this.zzRa = internalCredentialId;
        this.zzRb = internalServerContext;
        this.zzwj = zzx.zzv(id);
        this.mName = name;
        this.zzRc = profilePictureUri;
        this.zzRd = idTokens == null ? Collections.emptyList() : Collections.unmodifiableList(idTokens);
        this.zzRe = password;
        this.zzRf = accountType;
        this.zzRg = generatedPassword;
        this.zzRh = generatedHintId;
    }

    public String zzlr() {
        return this.zzRa;
    }

    public String zzls() {
        return this.zzRb;
    }

    public String getId() {
        return this.zzwj;
    }

    public String getName() {
        return this.mName;
    }

    public Uri getProfilePictureUri() {
        return this.zzRc;
    }

    public List<IdToken> zzlt() {
        return this.zzRd;
    }

    public String getPassword() {
        return this.zzRe;
    }

    public String getGeneratedPassword() {
        return this.zzRg;
    }

    public String getAccountType() {
        return this.zzRf;
    }

    public String zzlu() {
        return this.zzRh;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)other;
        return TextUtils.equals((CharSequence)this.zzwj, (CharSequence)credential.zzwj) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzw.equal(this.zzRc, credential.zzRc) && TextUtils.equals((CharSequence)this.zzRe, (CharSequence)credential.zzRe) && TextUtils.equals((CharSequence)this.zzRf, (CharSequence)credential.zzRf) && TextUtils.equals((CharSequence)this.zzRg, (CharSequence)credential.zzRg);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzwj, this.mName, this.zzRc, this.zzRe, this.zzRf, this.zzRg);
    }

    public static class Builder {
        private final String zzwj;
        private String mName;
        private Uri zzRc;
        private List<IdToken> zzRd;
        private String zzRe;
        private String zzRf;
        private String zzRg;
        private String zzRa;
        private String zzRb;
        private String zzRh;

        public Builder(String id) {
            this.zzwj = id;
        }

        public Builder(Credential credential) {
            this.zzwj = credential.zzwj;
            this.mName = credential.mName;
            this.zzRc = credential.zzRc;
            this.zzRd = credential.zzRd;
            this.zzRe = credential.zzRe;
            this.zzRf = credential.zzRf;
            this.zzRg = credential.zzRg;
            this.zzRa = credential.zzRa;
            this.zzRb = credential.zzRb;
            this.zzRh = credential.zzRh;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setProfilePictureUri(Uri profilePictureUri) {
            this.zzRc = profilePictureUri;
            return this;
        }

        public Builder setPassword(String password) {
            this.zzRe = password;
            return this;
        }

        public Builder setAccountType(String accountType) {
            Uri uri = Uri.parse((String)accountType);
            String string2 = uri.getScheme();
            zzx.zzZ("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2));
            this.zzRf = accountType;
            return this;
        }

        public Credential build() {
            if (!TextUtils.isEmpty((CharSequence)this.zzRe) && !TextUtils.isEmpty((CharSequence)this.zzRf)) {
                throw new IllegalStateException("Only one of password or accountType may be set");
            }
            return new Credential(2, this.zzRa, this.zzRb, this.zzwj, this.mName, this.zzRc, this.zzRd, this.zzRe, this.zzRf, this.zzRg, this.zzRh);
        }
    }
}

