/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@zzgk
public class zzew
extends zzfb {
    static final Set<String> zzzo = new HashSet<String>(Arrays.asList("top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"));
    private String zzzp = "top-right";
    private boolean zzzq = true;
    private int zzzr = 0;
    private int zzzs = 0;
    private int zznQ = -1;
    private int zzzt = 0;
    private int zzzu = 0;
    private int zznP = -1;
    private final Object zzpc = new Object();
    private final zzip zzoL;
    private final Activity zzzv;
    private AdSizeParcel zzyK;
    private ImageView zzzw;
    private LinearLayout zzzx;
    private zzfc zzzy;
    private PopupWindow zzzz;
    private RelativeLayout zzzA;
    private ViewGroup zzzB;

    public zzew(zzip zzip2, zzfc zzfc2) {
        super(zzip2, "resize");
        this.zzoL = zzip2;
        this.zzzv = zzip2.zzgN();
        this.zzzy = zzfc2;
    }

    private void zzf(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zznP = zzp.zzbx().zzax(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zznQ = zzp.zzbx().zzax(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzzt = zzp.zzbx().zzax(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzzu = zzp.zzbx().zzax(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzzq = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzzp = string2;
        }
    }

    boolean zzdW() {
        return this.zznP > -1 && this.zznQ > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Map<String, String> map) {
        Object object = this.zzpc;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzzv == null) {
                this.zzah("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzoL.zzaN() == null) {
                this.zzah("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzoL.zzaN().zzsH) {
                this.zzah("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzoL.zzgW()) {
                this.zzah("Cannot resize an expanded banner.");
                return;
            }
            this.zzf(map);
            if (!this.zzdW()) {
                this.zzah("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzzv.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzah("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzdX();
            if (nArray == null) {
                this.zzah("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzk.zzcE().zzb((Context)this.zzzv, this.zznP);
            int n2 = zzk.zzcE().zzb((Context)this.zzzv, this.zznQ);
            ViewParent viewParent = this.zzoL.getWebView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView((View)this.zzoL.getWebView());
                if (this.zzzz == null) {
                    this.zzzB = (ViewGroup)viewParent;
                    bitmap = zzp.zzbx().zzj((View)this.zzoL.getWebView());
                    this.zzzw = new ImageView((Context)this.zzzv);
                    this.zzzw.setImageBitmap(bitmap);
                    this.zzyK = this.zzoL.zzaN();
                    this.zzzB.addView((View)this.zzzw);
                } else {
                    this.zzzz.dismiss();
                }
            } else {
                this.zzah("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzzA = new RelativeLayout((Context)this.zzzv);
            this.zzzA.setBackgroundColor(0);
            this.zzzA.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzzz = zzp.zzbx().zza((View)this.zzzA, n, n2, false);
            this.zzzz.setOutsideTouchable(true);
            this.zzzz.setTouchable(true);
            this.zzzz.setClippingEnabled(!this.zzzq);
            this.zzzA.addView((View)this.zzoL.getWebView(), -1, -1);
            this.zzzx = new LinearLayout((Context)this.zzzv);
            bitmap = new RelativeLayout.LayoutParams(zzk.zzcE().zzb((Context)this.zzzv, 50), zzk.zzcE().zzb((Context)this.zzzv, 50));
            switch (this.zzzp) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzzx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzew.this.zzn(true);
                }
            });
            this.zzzx.setContentDescription((CharSequence)"Close button");
            this.zzzA.addView((View)this.zzzx, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzzz.showAtLocation(window.getDecorView(), 0, zzk.zzcE().zzb((Context)this.zzzv, nArray[0]), zzk.zzcE().zzb((Context)this.zzzv, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzah("Cannot show popup window: " + runtimeException.getMessage());
                this.zzzA.removeView((View)this.zzoL.getWebView());
                if (this.zzzB != null) {
                    this.zzzB.removeView((View)this.zzzw);
                    this.zzzB.addView((View)this.zzoL.getWebView());
                    this.zzoL.zza(this.zzyK);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzoL.zza(new AdSizeParcel((Context)this.zzzv, new AdSize(this.zznP, this.zznQ)));
            this.zzc(nArray[0], nArray[1]);
            this.zzaj("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(boolean bl) {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzzz != null) {
                this.zzzz.dismiss();
                this.zzzA.removeView((View)this.zzoL.getWebView());
                if (this.zzzB != null) {
                    this.zzzB.removeView((View)this.zzzw);
                    this.zzzB.addView((View)this.zzoL.getWebView());
                    this.zzoL.zza(this.zzyK);
                }
                if (bl) {
                    this.zzaj("default");
                    if (this.zzzy != null) {
                        this.zzzy.zzbc();
                    }
                }
                this.zzzz = null;
                this.zzzA = null;
                this.zzzB = null;
                this.zzzx = null;
            }
        }
    }

    private int[] zzdX() {
        if (!this.zzdZ()) {
            return null;
        }
        if (this.zzzq) {
            return new int[]{this.zzzr + this.zzzt, this.zzzs + this.zzzu};
        }
        int[] nArray = zzp.zzbx().zzh(this.zzzv);
        int[] nArray2 = zzp.zzbx().zzj(this.zzzv);
        int n = nArray[0];
        int n2 = this.zzzr + this.zzzt;
        int n3 = this.zzzs + this.zzzu;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zznP > n) {
            n2 = n - this.zznP;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zznQ > nArray2[1]) {
            n3 = nArray2[1] - this.zznQ;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzzr = n;
            this.zzzs = n2;
            if (this.zzzz != null && bl) {
                int[] nArray = this.zzdX();
                if (nArray != null) {
                    this.zzzz.update(zzk.zzcE().zzb((Context)this.zzzv, nArray[0]), zzk.zzcE().zzb((Context)this.zzzv, nArray[1]), this.zzzz.getWidth(), this.zzzz.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzn(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzzy != null) {
            this.zzzy.zza(n, n2, this.zznP, this.zznQ);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzp.zzbx().zzj(this.zzzv)[0];
        this.zzb(n, n2 - n3, this.zznP, this.zznQ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzdY() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzzz != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzzr = n;
        this.zzzs = n2;
    }

    boolean zzdZ() {
        int[] nArray = zzp.zzbx().zzh(this.zzzv);
        int[] nArray2 = zzp.zzbx().zzj(this.zzzv);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zznP < 50 || this.zznP > n) {
            zzb.zzaE("Width is too small or too large.");
            return false;
        }
        if (this.zznQ < 50 || this.zznQ > n2) {
            zzb.zzaE("Height is too small or too large.");
            return false;
        }
        if (this.zznQ == n2 && this.zznP == n) {
            zzb.zzaE("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzzq) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzzp) {
                case "top-left": {
                    n3 = this.zzzr + this.zzzt;
                    n4 = this.zzzs + this.zzzu;
                    break;
                }
                case "top-center": {
                    n3 = this.zzzr + this.zzzt + this.zznP / 2 - 25;
                    n4 = this.zzzs + this.zzzu;
                    break;
                }
                case "center": {
                    n3 = this.zzzr + this.zzzt + this.zznP / 2 - 25;
                    n4 = this.zzzs + this.zzzu + this.zznQ / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzzr + this.zzzt;
                    n4 = this.zzzs + this.zzzu + this.zznQ - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzzr + this.zzzt + this.zznP / 2 - 25;
                    n4 = this.zzzs + this.zzzu + this.zznQ - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzzr + this.zzzt + this.zznP - 50;
                    n4 = this.zzzs + this.zzzu + this.zznQ - 50;
                    break;
                }
                default: {
                    n3 = this.zzzr + this.zzzt + this.zznP - 50;
                    n4 = this.zzzs + this.zzzu;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

