/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzgk
public final class zzdo
implements zzdg {
    private final Map<zzip, Integer> zzxq = new WeakHashMap<zzip, Integer>();

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzk.zzcE().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaE("Could not parse " + string2 + " in a video GMSG: " + string3);
            }
        }
        return n2;
    }

    @Override
    public void zza(zzip zzip2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzb.zzaE("Action missing from video GMSG.");
            return;
        }
        if (zzb.zzM(3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            zzb.zzaC("Video GMSG: " + string2 + " " + object.toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzb.zzaE("Color parameter missing from color video GMSG.");
                return;
            }
            try {
                com.google.android.gms.ads.internal.overlay.zzk zzk2;
                int n = Color.parseColor((String)object);
                zzd zzd2 = zzip2.zzgQ();
                if (zzd2 != null && (zzk2 = zzd2.zzew()) != null) {
                    zzk2.setBackgroundColor(n);
                    return;
                }
                this.zzxq.put(zzip2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzb.zzaE("Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzip2.zzgQ();
        if (object == null) {
            zzb.zzaE("Could not get ad overlay for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzip2.getContext();
            int n2 = zzdo.zza(context, map, "x", 0);
            int n3 = zzdo.zza(context, map, "y", 0);
            int n4 = zzdo.zza(context, map, "w", -1);
            int n5 = zzdo.zza(context, map, "h", -1);
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (bl && ((zzd)object).zzew() == null) {
                ((zzd)object).zza(n2, n3, n4, n5, n);
                if (this.zzxq.containsKey(zzip2)) {
                    int n6 = this.zzxq.get(zzip2);
                    com.google.android.gms.ads.internal.overlay.zzk zzk3 = ((zzd)object).zzew();
                    zzk3.setBackgroundColor(n6);
                }
            } else {
                ((zzd)object).zzd(n2, n3, n4, n5);
            }
        } else {
            com.google.android.gms.ads.internal.overlay.zzk zzk4 = ((zzd)object).zzew();
            if (zzk4 == null) {
                com.google.android.gms.ads.internal.overlay.zzk.zzd(zzip2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzip2.getContext();
                int n = zzdo.zza(context, map, "x", 0);
                int n7 = zzdo.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n7, (int)0);
                zzk4.zzd(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string3 = map.get("time");
                if (string3 == null) {
                    zzb.zzaE("Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string3);
                    int n = (int)(f * 1000.0f);
                    zzk4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzaE("Could not parse time parameter from currentTime video GMSG: " + string3);
                }
            } else if ("hide".equals(string2)) {
                zzk4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk4.zzeP();
            } else if ("mimetype".equals(string2)) {
                zzk4.setMimeType(map.get("mimetype"));
            } else if ("muted".equals(string2)) {
                boolean bl3 = Boolean.parseBoolean(map.get("muted"));
                if (bl3) {
                    zzk4.zzeq();
                } else {
                    zzk4.zzer();
                }
            } else if ("pause".equals(string2)) {
                zzk4.pause();
            } else if ("play".equals(string2)) {
                zzk4.play();
            } else if ("show".equals(string2)) {
                zzk4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk4.zzak(map.get("src"));
            } else if ("volume".equals(string2)) {
                String string4 = map.get("volume");
                if (string4 == null) {
                    zzb.zzaE("Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzk4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzaE("Could not parse volume parameter from volume video GMSG: " + string4);
                }
            } else if ("watermark".equals(string2)) {
                zzk4.zzeQ();
            } else {
                zzb.zzaE("Unknown video action: " + string2);
            }
        }
    }
}

