/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbj;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzlv;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzbk
extends Thread {
    private boolean mStarted = false;
    private boolean zzrO = false;
    private boolean zzam = false;
    private final Object zzpc;
    private final zzbj zzrP;
    private final zzbi zzrQ;
    private final zzgj zzrR;
    private final int zzrS;
    private final int zzrC;
    private final int zzrT;
    private final int zzrE;
    private final int zzrU;

    public zzbk(zzbj zzbj2, zzbi zzbi2, zzgj zzgj2) {
        this.zzrP = zzbj2;
        this.zzrQ = zzbi2;
        this.zzrR = zzgj2;
        this.zzpc = new Object();
        this.zzrC = zzby.zzuF.get();
        this.zzrT = zzby.zzuG.get();
        this.zzrE = zzby.zzuH.get();
        this.zzrU = zzby.zzuI.get();
        this.zzrS = zzby.zzuJ.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzct() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.mStarted) {
                zzb.zzaC("Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzam) {
            Object object;
            try {
                if (this.zzcu()) {
                    object = this.zzrP.getActivity();
                    if (object == null) {
                        zzb.zzaC("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzb.zzaC("ContentFetchTask: sleeping");
                    this.zzcw();
                }
                Thread.sleep(this.zzrS * 1000);
            }
            catch (Throwable throwable) {
                zzb.zzb("Error in ContentFetchTask", throwable);
                this.zzrR.zza(throwable, true);
            }
            object = this.zzpc;
            synchronized (object) {
                while (this.zzrO) {
                    try {
                        zzb.zzaC("ContentFetchTask: waiting");
                        this.zzpc.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzf(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzbk.this.zzg(view);
            }
        });
        return true;
    }

    void zzg(View view) {
        try {
            zzbh zzbh2 = new zzbh(this.zzrC, this.zzrT, this.zzrE, this.zzrU);
            zza zza2 = this.zza(view, zzbh2);
            zzbh2.zzcq();
            if (zza2.zzsb == 0 && zza2.zzsc == 0) {
                return;
            }
            if (zza2.zzsc == 0 && zzbh2.zzcr() == 0) {
                return;
            }
            if (zza2.zzsc == 0 && this.zzrQ.zza(zzbh2)) {
                return;
            }
            this.zzrQ.zzc(zzbh2);
        }
        catch (Exception exception) {
            zzb.zzb("Exception in fetchContentOnUIThread", exception);
            this.zzrR.zza(exception, true);
        }
    }

    boolean zzr(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzcu() {
        try {
            Context context = this.zzrP.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzr(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zzf(view);
    }

    zza zza(View view, zzbh zzbh2) {
        if (view == null) {
            return new zza(0, 0);
        }
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzbh2.zzw(string2);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzip)) {
            zzbh2.zzcp();
            if (this.zza((WebView)view, zzbh2)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzbh2);
                n += zza2.zzsb;
                n2 += zza2.zzsc;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    boolean zza(final WebView webView, final zzbh zzbh2) {
        if (!zzlv.zzpV()) {
            return false;
        }
        zzbh2.zzcp();
        webView.post(new Runnable(){
            ValueCallback<String> zzrX = new ValueCallback<String>(){

                public void zzy(String string2) {
                    zzbk.this.zza(zzbh2, webView, string2);
                }

                public /* synthetic */ void onReceiveValue(Object x0) {
                    this.zzy((String)x0);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzrX);
                    }
                    catch (Throwable throwable) {
                        this.zzrX.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzbh zzbh2, WebView webView, String string2) {
        zzbh2.zzco();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzbh2.zzv(webView.getTitle() + "\n" + string3);
                } else {
                    zzbh2.zzv(string3);
                }
            }
            if (zzbh2.zzcl()) {
                this.zzrQ.zzb(zzbh2);
            }
        }
        catch (JSONException jSONException) {
            zzb.zzaC("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzb.zza("Failed to get webview content.", throwable);
            this.zzrR.zza(throwable, true);
        }
    }

    public zzbh zzcv() {
        return this.zzrQ.zzcs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzrO = false;
            this.zzpc.notifyAll();
            zzb.zzaC("ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcw() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzrO = true;
            zzb.zzaC("ContentFetchThread: paused, mPause = " + this.zzrO);
        }
    }

    public boolean zzcx() {
        return this.zzrO;
    }

    @zzgk
    class zza {
        final int zzsb;
        final int zzsc;

        zza(int n, int n2) {
            this.zzsb = n;
            this.zzsc = n2;
        }
    }
}

