/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.AdActivity;
import com.google.android.gms.ads.internal.client.MobileAdsSettingsParcel;
import com.google.android.gms.ads.internal.client.zzv;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.purchase.InAppPurchaseActivity;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqg;
import java.util.regex.Pattern;

@zzgk
public class zzm
extends zzv.zza
implements zzoj.zza,
zzqg.zza {
    private final Context mContext;
    private static final Object zzpm = new Object();
    private static zzm zzpn;
    zzqf zzpo;
    String zzpp;
    String zzpq;
    private boolean zzpr;
    private boolean zzps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzm zzq(Context context) {
        Object object = zzpm;
        synchronized (object) {
            if (zzpn == null) {
                zzpn = new zzm(context.getApplicationContext());
            }
            return zzpn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzbn() {
        Object object = zzpm;
        synchronized (object) {
            return this.zzps;
        }
    }

    zzm(Context context) {
        this.mContext = context;
        this.zzpr = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(String string, MobileAdsSettingsParcel mobileAdsSettingsParcel) {
        Object object = zzpm;
        synchronized (object) {
            if (this.zzpr) {
                zzb.zzaE("Mobile ads is initialized already.");
                return;
            }
            if (this.mContext == null) {
                zzb.zzaE("Fail to initialize mobile ads because context is null.");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                zzb.zzaE("Fail to initialize mobile ads because ApplicationCode is empty.");
                return;
            }
            this.zzpr = true;
            this.zzb(string, mobileAdsSettingsParcel);
        }
    }

    void zzb(String string, MobileAdsSettingsParcel mobileAdsSettingsParcel) {
        if (mobileAdsSettingsParcel != null && mobileAdsSettingsParcel.zzty) {
            if (!zzp.zzbx().zza(this.mContext.getPackageManager(), this.mContext.getPackageName(), "android.permission.INTERNET")) {
                zzb.e("Missing permission android.permission.INTERNET");
                return;
            }
            if (!zzp.zzbx().zza(this.mContext.getPackageManager(), this.mContext.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                zzb.e("Missing permission android.permission.ACCESS_NETWORK_STATE");
                return;
            }
            if (!Pattern.matches("ca-app-[a-z0-9_-]+~[a-z0-9_-]+", string)) {
                throw new IllegalArgumentException("Please provide a valid application code");
            }
            this.zzps = true;
            this.zzpp = string;
            this.zzpq = mobileAdsSettingsParcel.zztz;
            zzqg zzqg2 = zzqg.zzaR((Context)this.mContext);
            zzqf.zza zza2 = new zzqf.zza(this.zzpp);
            if (!TextUtils.isEmpty((CharSequence)this.zzpq)) {
                zza2.zzfh(this.zzpq);
            }
            zzqg2.zza(zza2.zzBm());
            zzqg2.zza((zzqg.zza)this);
            zzoj zzoj2 = zzoj.zzaJ((Context)this.mContext);
            zzoj2.zza((zzoj.zza)this);
            zzqg2.start();
        }
    }

    public void zzbo() {
        this.zzpo = zzqg.zzaR((Context)this.mContext).zzBn();
    }

    public void zza(zzoq zzoq2, Activity activity) {
        if (zzoq2 == null || activity == null) {
            return;
        }
        if (activity instanceof AdActivity) {
            int n = zzp.zzbx().zzk(activity);
            if (n == 1) {
                zzoq2.zzam(true);
                zzoq2.setScreenName("Interstitial Ad");
            } else if (n == 2 || n == 3) {
                zzoq2.setScreenName("Expanded Ad");
            } else {
                zzoq2.setScreenName(null);
            }
        } else if (activity instanceof InAppPurchaseActivity) {
            zzoq2.setScreenName(null);
        }
    }

    public void zza(zzoq zzoq2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int zzbp() {
        Object object = zzpm;
        synchronized (object) {
            if (!this.zzps) {
                return -1;
            }
            zzoj zzoj2 = zzoj.zzaJ((Context)this.mContext);
            zzoq zzoq2 = zzoj2.zzxw();
            if (zzoq2 != null) {
                return zzoq2.zzbp();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientId() {
        Object object = zzpm;
        synchronized (object) {
            if (!this.zzps) {
                return null;
            }
            GoogleAnalytics googleAnalytics = GoogleAnalytics.getInstance((Context)this.mContext);
            return googleAnalytics.getClientId();
        }
    }
}

