/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzt;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzfm;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzho;
import java.util.HashSet;

@zzgk
public abstract class zza
extends zzr.zza
implements com.google.android.gms.ads.internal.client.zza,
zzn,
zza.zza,
zzdd,
zzga.zza,
zzhn {
    private zzcd zzon;
    private zzcc zzoo;
    private zzcc zzop;
    boolean zzoq = false;
    protected final zzo zzor;
    protected final zzq zzos;
    protected transient AdRequestParcel zzot;
    protected final zzay zzou;
    protected final zzd zzov;

    zza(zzq zzq2, zzo zzo2, zzd zzd2) {
        this.zzos = zzq2;
        this.zzor = zzo2 != null ? zzo2 : new zzo(this);
        this.zzov = zzd2;
        zzp.zzbx().zzJ(this.zzos.context);
        zzp.zzbA().zzb(this.zzos.context, this.zzos.zzqb);
        this.zzou = zzp.zzbA().zzgh();
    }

    void zzaL() {
        this.zzon = new zzcd(zzby.zzuB.get(), "load_ad", this.zzos.zzqf.zzsG);
        this.zzoo = new zzcc(-1L, null, null);
        this.zzop = new zzcc(-1L, null, null);
    }

    @Override
    public void destroy() {
        zzx.zzch((String)"destroy must be called on the main UI thread.");
        this.zzor.cancel();
        this.zzou.zzf(this.zzos.zzqg);
        this.zzos.destroy();
    }

    @Override
    public com.google.android.gms.dynamic.zzd zzaM() {
        zzx.zzch((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzx((Object)((Object)this.zzos.zzqc));
    }

    @Override
    public AdSizeParcel zzaN() {
        zzx.zzch((String)"getAdSize must be called on the main UI thread.");
        return this.zzos.zzqf;
    }

    @Override
    public boolean isReady() {
        zzx.zzch((String)"isLoaded must be called on the main UI thread.");
        return this.zzos.zzqd == null && this.zzos.zzqe == null && this.zzos.zzqg != null;
    }

    @Override
    public void setManualImpressionsEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel) {
        zzx.zzch((String)"loadAd must be called on the main UI thread.");
        if (this.zzos.zzqd != null || this.zzos.zzqe != null) {
            if (this.zzot != null) {
                zzb.zzaE("Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            }
            this.zzot = adRequestParcel;
            return false;
        }
        zzb.zzaD("Starting ad request.");
        this.zzoq = true;
        this.zzaL();
        this.zzoo = this.zzon.zzdl();
        if (!adRequestParcel.zzst) {
            zzb.zzaD("Use AdRequest.Builder.addTestDevice(\"" + zzk.zzcE().zzQ(this.zzos.context) + "\") to get test ads on this device.");
        }
        return this.zza(adRequestParcel, this.zzon);
    }

    protected abstract boolean zza(AdRequestParcel var1, zzcd var2);

    @Override
    public void zza(zzhj.zza zza2) {
        long l;
        if (zza2.zzGM.zzEb != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzGM.zzEl) && (l = this.zzo(zza2.zzGM.zzEl)) != -1L) {
            zzcc zzcc2 = this.zzon.zzb(zza2.zzGM.zzEb + l);
            this.zzon.zza(zzcc2, "stc");
        }
        this.zzon.zzR(zza2.zzGM.zzEl);
        this.zzon.zza(this.zzoo, "arf");
        this.zzop = this.zzon.zzdl();
        this.zzos.zzqd = null;
        this.zzos.zzqh = zza2;
        this.zza(zza2, this.zzon);
    }

    protected abstract void zza(zzhj.zza var1, zzcd var2);

    boolean zza(zzhj zzhj2) {
        return false;
    }

    @Override
    public void zzb(zzhj zzhj2) {
        this.zzon.zza(this.zzop, "awr");
        this.zzos.zzqe = null;
        if (zzhj2.errorCode != -2 && zzhj2.errorCode != 3) {
            zzp.zzbA().zzb(this.zzos.zzbL());
        }
        if (zzhj2.errorCode == -1) {
            this.zzoq = false;
            return;
        }
        if (this.zza(zzhj2)) {
            zzb.zzaC("Ad refresh scheduled.");
        }
        if (zzhj2.errorCode != -2) {
            this.zze(zzhj2.errorCode);
            return;
        }
        if (this.zzos.zzqx == null) {
            this.zzos.zzqx = new zzho(this.zzos.zzpZ);
        }
        this.zzou.zze(this.zzos.zzqg);
        if (this.zza(this.zzos.zzqg, zzhj2)) {
            this.zzos.zzqg = zzhj2;
            this.zzos.zzbS();
            this.zzon.zzd("is_mraid", this.zzos.zzqg.zzbY() ? "1" : "0");
            this.zzon.zzd("is_mediation", this.zzos.zzqg.zzDX ? "1" : "0");
            if (this.zzos.zzqg.zzAR != null && this.zzos.zzqg.zzAR.zzgS() != null) {
                this.zzon.zzd("is_video", this.zzos.zzqg.zzAR.zzgS().zzhc() ? "1" : "0");
            }
            this.zzon.zza(this.zzoo, "ttc");
            if (zzp.zzbA().zzgc() != null) {
                zzp.zzbA().zzgc().zza(this.zzon);
            }
            if (this.zzos.zzbP()) {
                this.zzaT();
            }
        }
    }

    protected abstract boolean zza(zzhj var1, zzhj var2);

    @Override
    public void onAdClicked() {
        if (this.zzos.zzqg == null) {
            zzb.zzaE("Ad state was null when trying to ping click URLs.");
            return;
        }
        zzb.zzaC("Pinging click URLs.");
        this.zzos.zzqi.zzfU();
        if (this.zzos.zzqg.zzyw != null) {
            zzp.zzbx().zza(this.zzos.context, this.zzos.zzqb.zzIz, zzp.zzbx().zza(this.zzos.context, this.zzos.zzqg.zzyw, this.zzos.zzqg.zzDO));
        }
        if (this.zzos.zzqj != null) {
            try {
                this.zzos.zzqj.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not notify onAdClicked event.", remoteException);
            }
        }
    }

    @Override
    public void zzaO() {
        this.zzaR();
    }

    @Override
    public void onAppEvent(String name, String info) {
        if (this.zzos.zzql != null) {
            try {
                this.zzos.zzql.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    @Override
    public void zzaP() {
        zzx.zzch((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzos.zzqg == null) {
            zzb.zzaE("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzb.zzaC("Pinging manual tracking URLs.");
        if (this.zzos.zzqg.zzDZ != null) {
            zzp.zzbx().zza(this.zzos.context, this.zzos.zzqb.zzIz, zzp.zzbx().zza(this.zzos.context, this.zzos.zzqg.zzDZ, this.zzos.zzqg.zzDO));
        }
    }

    @Override
    public void pause() {
        zzx.zzch((String)"pause must be called on the main UI thread.");
    }

    @Override
    public void resume() {
        zzx.zzch((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzb(AdRequestParcel adRequestParcel) {
        ViewParent viewParent = this.zzos.zzqc.getParent();
        return viewParent instanceof View && ((View)viewParent).isShown() && zzp.zzbx().zzgq();
    }

    public void zzc(AdRequestParcel adRequestParcel) {
        if (this.zzb(adRequestParcel)) {
            this.zza(adRequestParcel);
        } else {
            zzb.zzaD("Ad is not visible. Not refreshing ad.");
            this.zzor.zzf(adRequestParcel);
        }
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzn zzn2) {
        zzx.zzch((String)"setAdListener must be called on the main UI thread.");
        this.zzos.zzqk = zzn2;
    }

    @Override
    public void zza(zzm zzm2) {
        zzx.zzch((String)"setAdListener must be called on the main UI thread.");
        this.zzos.zzqj = zzm2;
    }

    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        zzx.zzch((String)"setAdSize must be called on the main UI thread.");
        this.zzos.zzqf = adSizeParcel;
        if (this.zzos.zzqg != null && this.zzos.zzqg.zzAR != null && this.zzos.zzqz == 0) {
            this.zzos.zzqg.zzAR.zza(adSizeParcel);
        }
        if (this.zzos.zzqc == null) {
            return;
        }
        if (this.zzos.zzqc.getChildCount() > 1) {
            this.zzos.zzqc.removeView(this.zzos.zzqc.getNextView());
        }
        this.zzos.zzqc.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzos.zzqc.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzos.zzqc.requestLayout();
    }

    @Override
    public void zza(zzt zzt2) {
        zzx.zzch((String)"setAppEventListener must be called on the main UI thread.");
        this.zzos.zzql = zzt2;
    }

    @Override
    public void zza(zzfm zzfm2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    @Override
    public void zza(zzch zzch2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    @Override
    public void zza(zzfq zzfq2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    @Override
    public void zza(zzu zzu2) {
        zzx.zzch((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzos.zzqm = zzu2;
    }

    @Override
    public void stopLoading() {
        zzx.zzch((String)"stopLoading must be called on the main UI thread.");
        this.zzoq = false;
        this.zzos.zzf(true);
    }

    @Override
    public boolean isLoading() {
        return this.zzoq;
    }

    Bundle zza(zzbk zzbk2) {
        if (zzbk2 == null) {
            return null;
        }
        if (zzbk2.zzcx()) {
            zzbk2.wakeup();
        }
        zzbh zzbh2 = zzbk2.zzcv();
        String string = null;
        if (zzbh2 != null) {
            string = zzbh2.zzcm();
            zzb.zzaC("In AdManger: loadAd, " + zzbh2.toString());
        }
        if (string != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string);
            bundle.putInt("v", 1);
            return bundle;
        }
        return null;
    }

    long zzo(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzb.zzaE("Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzb.zzaE("Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        this.zzos.zzqc.addView(view, zzp.zzbz().zzgy());
    }

    protected boolean zzaQ() {
        zzb.v("Ad closing.");
        if (this.zzos.zzqk == null) {
            return false;
        }
        try {
            this.zzos.zzqk.onAdClosed();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdClosed().", remoteException);
            return false;
        }
    }

    private boolean zzaR() {
        zzb.zzaD("Ad leaving application.");
        if (this.zzos.zzqk == null) {
            return false;
        }
        try {
            this.zzos.zzqk.onAdLeftApplication();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLeftApplication().", remoteException);
            return false;
        }
    }

    protected boolean zzaS() {
        zzb.zzaD("Ad opening.");
        if (this.zzos.zzqk == null) {
            return false;
        }
        try {
            this.zzos.zzqk.onAdOpened();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdOpened().", remoteException);
            return false;
        }
    }

    protected boolean zzaT() {
        zzb.zzaD("Ad finished loading.");
        this.zzoq = false;
        if (this.zzos.zzqk == null) {
            return false;
        }
        try {
            this.zzos.zzqk.onAdLoaded();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLoaded().", remoteException);
            return false;
        }
    }

    protected boolean zze(int n) {
        zzb.zzaE("Failed to load ad: " + n);
        this.zzoq = false;
        if (this.zzos.zzqk == null) {
            return false;
        }
        try {
            this.zzos.zzqk.onAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    protected void recordImpression() {
        this.zzc(this.zzos.zzqg);
    }

    protected void zzc(zzhj zzhj2) {
        if (zzhj2 == null) {
            zzb.zzaE("Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzb.zzaC("Pinging Impression URLs.");
        this.zzos.zzqi.zzfT();
        if (zzhj2.zzyx != null) {
            zzp.zzbx().zza(this.zzos.context, this.zzos.zzqb.zzIz, zzp.zzbx().zza(this.zzos.context, zzhj2.zzyx, zzhj2.zzDO));
        }
    }

    @Override
    public void zza(HashSet<zzhk> hashSet) {
        this.zzos.zza(hashSet);
    }
}

